#!/usr/bin/python
# -*- coding: utf-8 -*-

import datetime
from ui_newitem import *
from tagsselect import TagsSelect
from PyQt4 import QtGui,QtCore
import datastore

maemo = False
try:
    maemotest = QtCore.Qt.WA_Maemo5StackedWindow
    maemo = True
except:
    pass

class NewItem(QtGui.QMainWindow):
    def __init__(self, dstore, edititem=None, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.dstore = dstore
        if maemo:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
        self.ui = Ui_NewItem()
        self.ui.setupUi(self)
        self.ui.dateDue.setDate(QtCore.QDate.currentDate())
        # Make 'due by yesterday' valid ;) (but no earlier)
        self.ui.dateDue.setMinimumDate(QtCore.QDate.currentDate().addDays(-1))
        self.ui.dateStart.setDate(QtCore.QDate.currentDate())
        self.ui.dateStart.setMinimumDate(QtCore.QDate.currentDate().addDays(-1))
        self.updateProjects(dstore.getProjects())
        self.connect(self.ui.btnAdd, QtCore.SIGNAL('clicked()'), self.onAdd)
        self.connect(self.ui.cbHasDue,
                QtCore.SIGNAL('stateChanged(int)'), self.onHasDueChanged)
        self.connect(self.ui.cbHasStart,
                QtCore.SIGNAL('stateChanged(int)'), self.onHasStartChanged)
        self.connect(self.ui.btnTags, QtCore.SIGNAL('clicked()'), self.onTags)
        self.edititem = edititem
        if edititem is None:
            self.connect(self.ui.btnAddBack, QtCore.SIGNAL('clicked()'),
                self.onAddBack)
        else:
            # set fields from values in edititem
            self.ui.description.setPlainText(QtCore.QString(edititem.desc))
            self.ui.btnTags.setText(QtCore.QString(edititem.tags))
            self.ui.cbHasStart.setChecked(edititem.start is not None)
            if edititem.start is not None:
                self.ui.dateStart.setDate(QtCore.QDate(edititem.start))
                self.ui.dateStart.setEnabled(True)
            self.ui.cbHasDue.setChecked(edititem.due is not None)
            if edititem.due is not None:
                self.ui.dateDue.setDate(QtCore.QDate(edititem.due))
                self.ui.dateDue.setEnabled(True)
            self.updateProjects(dstore.getProjects(), edititem.projectnum)
            self.connect(self.ui.btnAddBack, QtCore.SIGNAL('clicked()'),
                self.onCancel)
            self.ui.btnAddBack.setText(QtGui.QApplication.translate("NewItem", "Cancel", None, QtGui.QApplication.UnicodeUTF8))
            self.ui.btnAdd.setText(QtGui.QApplication.translate("NewItem", "Save", None, QtGui.QApplication.UnicodeUTF8))
        self.ui.description.setFocus()

    def updateProjects(self, projs, selnum=0):
        self.ui.projectCombo.clear()
        i = 0
        for p in projs:
            self.ui.projectCombo.addItem(projs[p], QtCore.QVariant(p))
            if selnum == i:
                self.ui.projectCombo.setCurrentIndex(i)
            i += 1

    def onAdd(self):
        newtask = datastore.Task()
        newtask.desc = str(self.ui.description.toPlainText())
        newtask.created = datetime.datetime.now()
        if self.ui.cbHasDue.isChecked():
            newtask.due = self.ui.dateDue.dateTime().toPyDateTime()
        if self.ui.cbHasStart.isChecked():
            newtask.start = self.ui.dateStart.dateTime().toPyDateTime()
        sel = self.ui.projectCombo.currentIndex()
        newtask.projectnum = self.ui.projectCombo.itemData(sel).toPyObject()
        newtask.tags = str(self.ui.btnTags.text())
        if self.edititem is None:
            self.dstore.addTask(newtask)
        else:
            self.edititem.assign(newtask)
            self.dstore.updateTask(self.edititem)
            self.hide()
        self.reset()
        self.ui.description.setFocus()

    def onAddBack(self):
        self.onAdd()
        self.hide()

    def onCancel(self):
        self.hide()

    def onHasDueChanged(self, v):
        self.ui.dateDue.setEnabled(self.ui.cbHasDue.isChecked())

    def onHasStartChanged(self, v):
        self.ui.dateStart.setEnabled(self.ui.cbHasStart.isChecked())

    def onTags(self):
        ts = TagsSelect("Tag with...", True, self)
        currenttags = str(self.ui.btnTags.text()).split(',')
        ts.setTags(
                list(set.union(set(self.dstore.getAllTags()), 
                    set(currenttags))),
                currenttags)
        if ts.exec_() == QtGui.QDialog.Accepted:
            alltags, selectedtags = ts.getTags()
            self.ui.btnTags.setText(','.join(selectedtags))
        ts = None

    def reset(self):
        self.ui.description.setPlainText(QtCore.QString(""))
        self.ui.btnTags.setText(QtCore.QString(""))
        self.ui.cbHasStart.setChecked(False)
        self.ui.dateStart.setEnabled(False)
        self.ui.cbHasDue.setChecked(False)
        self.ui.dateDue.setEnabled(False)

