#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import os
from ui_mainwindow import *
from PyQt4 import QtGui,QtCore
import datastore
from itemview import ItemView
from newitem import NewItem
from projects import ProjectsView

TodoFile = "~/.pebble-do"
maemo = False
try:
    maemotest = QtCore.Qt.WA_Maemo5StackedWindow
    TodoFile = "~/MyDocs/.pebble-do"
    maemo = True
except:
    pass

class MainWindow(QtGui.QMainWindow):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        filename = os.path.expanduser(TodoFile)
        self.dstore = datastore.DataStore()
        try:
            self.dstore.load(filename)
        except IOError:
            pass
        if maemo:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.itemview = ItemView(self.dstore, self)
        self.itemview.hide()
        self.newitem = NewItem(self.dstore, None, self)
        self.newitem.hide()
        self.projectsview = ProjectsView(self.dstore, self)
        self.projectsview.hide()
        self.connect(self.ui.btnNew, QtCore.SIGNAL('clicked()'), self.onNew)
        self.connect(self.ui.btnToday, QtCore.SIGNAL('clicked()'), self.onToday)
        self.connect(self.ui.btnNext, QtCore.SIGNAL('clicked()'), self.onNext)
        self.connect(self.ui.btnScheduled, QtCore.SIGNAL('clicked()'),
            self.onScheduled)
        self.connect(self.ui.btnSomeday, QtCore.SIGNAL('clicked()'),
            self.onSomeday)
        self.connect(self.ui.btnProjects, QtCore.SIGNAL('clicked()'),
            self.onProjects)
        self.connect(self.ui.btnCompleted, QtCore.SIGNAL('clicked()'),
            self.onCompleted)
        self.connect(self.dstore, QtCore.SIGNAL('updated()'), self.updateCounts)
        self.updateCounts()

    def onNew(self):
        self.newitem.show()

    def onToday(self):
        self.itemview.setItems(self.dstore.getTasks(datastore.getToday))
        self.itemview.show()

    def onNext(self):
        self.itemview.setItems(self.dstore.getTasks(datastore.getNext))
        self.itemview.show()

    def onScheduled(self):
        self.itemview.setItems(self.dstore.getTasks(datastore.getScheduled))
        self.itemview.show()

    def onCompleted(self):
        self.itemview.setItems(self.dstore.getTasks(datastore.getComplete))
        self.itemview.show()

    def onSomeday(self):
        self.itemview.setItems(self.dstore.getTasks(datastore.getTags, ['someday']))
        self.itemview.show()

    def onProjects(self):
        self.projectsview.updateProjects()
        self.projectsview.show()

    def updateCounts(self):
        self.ui.btnToday.setText(
                QtGui.QApplication.translate("MainWindow", "Today", None,
                    QtGui.QApplication.UnicodeUTF8)
                +' ('+ str(self.dstore.countTasks(datastore.getToday)) +')')
        self.ui.btnNext.setText(
                QtGui.QApplication.translate("MainWindow", "Next", None,
                    QtGui.QApplication.UnicodeUTF8)
                +' ('+ str(self.dstore.countTasks(datastore.getNext)) +')')
        self.ui.btnScheduled.setText(
                QtGui.QApplication.translate("MainWindow", "Scheduled", None,
                    QtGui.QApplication.UnicodeUTF8)
                +' ('+ str(self.dstore.countTasks(datastore.getScheduled)) +')')
        self.ui.btnSomeday.setText(
                QtGui.QApplication.translate("MainWindow", "Some day", None,
                    QtGui.QApplication.UnicodeUTF8)
                +' ('+ str(self.dstore.countTasks(datastore.getTags, ['someday'])) +')')
        self.newitem.updateProjects(self.dstore.getProjects())


if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    myapp = MainWindow()
    myapp.show()
    sys.exit(app.exec_())

