/*
 * (C) notaz, 2010
 *
 * This work is licensed under the terms of the GNU GPLv2 or later.
 * See the COPYING file in the top-level directory.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "plugin_lib.h"
#include "menu.h"
#include "pcnt.h"
#include "../libpcsxcore/new_dynarec/new_dynarec.h"

void *pl_fbdev_buf;

static int pl_fbdev_w, pl_fbdev_h, pl_fbdev_bpp;
static int flip_cnt, flips_per_sec, tick_per_sec;
extern float fps_cur; // XXX

static int get_cpu_ticks(void)
{
	static unsigned long last_utime;
	static int fd;
	unsigned long utime, ret;
	char buf[128];

	if (fd == 0)
		fd = open("/proc/self/stat", O_RDONLY);
	lseek(fd, 0, SEEK_SET);
	buf[0] = 0;
	read(fd, buf, sizeof(buf));
	buf[sizeof(buf) - 1] = 0;

	sscanf(buf, "%*d %*s %*c %*d %*d %*d %*d %*d %*u %*u %*u %*u %*u %lu", &utime);
	ret = utime - last_utime;
	last_utime = utime;
	return ret;
}

static void print_fps(void)
{
	if (pl_fbdev_bpp == 16)
		pl_text_out16(2, pl_fbdev_h - 10, "%2d %4.1f", flips_per_sec, fps_cur);
}

static void print_cpu_usage(void)
{
	if (pl_fbdev_bpp == 16)
		pl_text_out16(pl_fbdev_w - 28, pl_fbdev_h - 10, "%3d", tick_per_sec);
}


void pl_text_out16(int x, int y, const char *texto, ...)
{
	va_list args;
	char    buffer[256];

	va_start(args, texto);
	vsnprintf(buffer, sizeof(buffer), texto, args);
	va_end(args);

	printf (buffer);
}

static void pl_get_layer_pos(int *x, int *y, int *w, int *h)
{
	*x = 0;
	*y = 0;
	*w = 800;
	*h = 640;
}

extern int UseFrameSkip; // hmh

const struct rearmed_cbs pl_rearmed_cbs = {
	pl_get_layer_pos,
	pl_fbdev_open,
	pl_fbdev_set_mode,
	pl_fbdev_flip,
	pl_fbdev_close,
	&UseFrameSkip,
};

