/*
 * Copyright (c) 2009 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Walter Guerra <walter.guerra@signove.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_ENVIRONMENT_MANAGER_H__
#define __NM_ENVIRONMENT_MANAGER_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "nm_conn_widget.h"

G_BEGIN_DECLS

#define TMPFILE                     "/tmp/pc-connectivity"
#define NM_ENVIRONMENT_MANAGER_NONE "None"

#define NM_ENVIRONMENT_MANAGER_TYPE            (nm_environment_manager_get_type ())
#define NM_ENVIRONMENT_MANAGER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_ENVIRONMENT_MANAGER_TYPE, NmEnvironmentManager))
#define NM_ENVIRONMENT_MANAGER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_ENVIRONMENT_MANAGER_TYPE, NmEnvironmentManagerClass))
#define IS_NM_ENVIRONMENT_MANAGER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_ENVIRONMENT_MANAGER_TYPE))
#define IS_NM_ENVIRONMENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_ENVIRONMENT_MANAGER_TYPE))
#define NM_ENVIRONMENT_MANAGER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_ENVIRONMENT_MANAGER_TYPE, NmEnvironmentManagerClass))

typedef struct _NmEnvironmentManager      NmEnvironmentManager;
typedef struct _NmEnvironmentManagerClass NmEnvironmentManagerClass;

struct _NmEnvironmentManagerClass
{
    GtkDialogClass parent_class;
};

struct _NmEnvironmentManager
{
    GtkDialog parent;
};


GtkWidget* nm_environment_manager_new ();
GType nm_environment_manager_get_type ();
gchar** nm_environment_manager_get_list(gsize *);
gchar* nm_environment_manager_get_active();
void nm_environment_manager_set_active(gchar *);
gchar* nm_environment_manager_show_dialog(NmEnvironmentManager *);

G_END_DECLS

#endif /* __NM_ENVIRONMENT_MANAGER_H__ */
