/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>

#include "nm_main_dialog.h"

osso_return_t
execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
    GtkWidget *dialog;

    dialog = nm_main_dialog_new();

    nm_main_dialog_run(NM_MAIN_DIALOG(dialog), NM_CONTROL_PANEL);

    /* Free the dialog (and it's children) */
    gtk_widget_destroy(GTK_WIDGET(dialog));

    return OSSO_OK;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
    return OSSO_OK;
}


