#!/usr/bin/env python
import pygame, math, random,time
pygame.init()
pygame.display.set_caption("Paper Toss N900")
pygame.mouse.set_visible(0)

y=range(100)
rightsmack=[283,289,297,303,306,310,313,315,318,321,500,494,490,495,500,510,522,536,554,593]
leftsmack=[197,191,183,177,174,170,167,165,162,159]
try :
	fo=open("/opt/papertoss/game.dat","r")
except:
	best_score=0
else:	
	best_score=int(fo.read())
	fo.close()
score=0
for x in range (100):
    y[x]=int((math.sin(x/31.83)*600)*((50+((100-x)/2))/100.0))+(x*2)
x=0
throw = False
smack=0
windx=(random.randint(0,80)/8.0)-5
paperdir=0
paperx=240

screen=pygame.display.set_mode([800,480],pygame.FULLSCREEN)
backdrop=pygame.image.load("/opt/papertoss/office.png").convert()
paper=pygame.image.load("/opt/papertoss/paper.png").convert()
bin=pygame.image.load("/opt/papertoss/bin.png").convert()
bin.set_colorkey((255,255,255))
digits=pygame.image.load("/opt/papertoss/digits.png").convert()
digits.set_colorkey((255,0,255))
fan1=pygame.image.load("/opt/papertoss/fan1.png").convert()
fan2=pygame.image.load("/opt/papertoss/fan2.png").convert()
pygame.mixer.init()
sound = pygame.mixer.Sound("/opt/papertoss/hit.wav")
bounce_off = pygame.mixer.Sound("/opt/papertoss/miss.wav")

mainloop = True
while mainloop:
	for event in pygame.event.get():
		if event.type == pygame.QUIT:
			mainloop = False
		elif event.type == pygame.MOUSEBUTTONUP:
			mpos=pygame.mouse.get_pos()
			if (mpos[0]<40 ) and (mpos[1]<80): mainloop=False
			if not throw:
				throw = True
				pos=pygame.mouse.get_pos()
				paperdir=(240-(480-pos[1]))/50.0
	pos=pygame.mouse.get_pos()
	screen.blit (backdrop,(0,0))

	wind2=int(abs(windx)*100)
	screen.blit(digits,(21,256),((0,((wind2 % 10)*30)),(38,30)))
	wind2=int(wind2/10)
	screen.blit(digits,(21,286),((0,((wind2 % 10)*30)),(38,30)))
	screen.blit(digits,(21,306),((0,300),(38,30)))
	wind2=int(wind2/10)
	screen.blit(digits,(21,324),((0,((wind2 % 10)*30)),(38,30)))
	
	screen.blit(digits,(82,264),((0,(score % 10)*30),(38,30)))
	score2=int(score/10)
	screen.blit(digits,(82,294),((0,(score2 % 10)*30),(38,30)))
	score2=int(score2/10)
	screen.blit(digits,(82,324),((0,(score2 % 10)*30),(38,30)))

	screen.blit(digits,(143,264),((0,(best_score % 10)*30),(38,30)))
	score2=int(best_score/10)
	screen.blit(digits,(143,294),((0,(score2 % 10)*30),(38,30)))
	score2=int(score2/10)
	screen.blit(digits,(143,324),((0,(score2 % 10)*30),(38,30)))

	if windx>0:
		screen.blit(fan1,(508,368))
		screen.blit(digits,(615,192),((38,100),(38,100)))
	else:
		screen.blit(fan2,(580,0))
		screen.blit(digits,(615,192),((38,0),(38,100)))
	if x<100:
		tmpsurface=pygame.transform.rotozoom(paper, x*8, (100-(x/1.5))/100.0).convert()
		tmpsurface.set_colorkey((0,0,0))
		if(x>89):
			if smack==2:
				screen.blit (tmpsurface,(rightsmack[x-80]-(tmpsurface.get_height()/2),rightsmack[x-90]-(tmpsurface.get_width()/2)))
				paperx=321
			elif smack==1:
				screen.blit (tmpsurface,(rightsmack[x-80]-(tmpsurface.get_height()/2),leftsmack[x-90]-(tmpsurface.get_width()/2)))
				paperx=159
			elif smack==0:
				screen.blit (tmpsurface,(800-(y[x]+25)-(tmpsurface.get_width()/2),paperx-(tmpsurface.get_height()/2)))
		else:
			screen.blit (tmpsurface,(800-(y[x]+25)-(tmpsurface.get_width()/2),paperx-(tmpsurface.get_height()/2)))
	else:
		tmpsurface=pygame.transform.rotozoom(paper, 99, (100-(99/1.5))/100.0).convert()
		tmpsurface.set_colorkey((0,0,0))
		screen.blit (tmpsurface,(800-(y[99]+25)-(tmpsurface.get_height()/2),paperx-(tmpsurface.get_width()/2)))
	if x>50: screen.blit(bin,(500,193))
	pygame.display.update()
	if throw:
		x+=1
		if x<90:
			paperx=paperx+paperdir
			paperdir=paperdir-(windx/50.0)
		if x==90:
			if (paperx>180) and (paperx<206):
				smack=1
				bounce_off.play()
				score=0
			elif (paperx>205) and (paperx<275):
				paperx=240
				sound.play()
				score+=1
				if score>best_score: 
					best_score=score
					fo=open("/opt/papertoss/game.dat","w")
					fo.write(str(best_score))
					fo.close()
			elif (paperx>274) and (paperx<300):
				smack=2
				bounce_off.play()
				score=0
			else:
				bounce_off.play()
				score=0
		if x>199: 
			throw = False
			x=0
			paperx=240
			windx=(random.randint(0,80)/8.0)-5
			smack=0
	else:
		time.sleep(.1)
