#ifndef PACKAGEDETAILS_H
#define PACKAGEDETAILS_H

/*
  PackageView - Show debian package details
  Copyright (C) 2008  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dlg/ActionDialog.h>

#include "Package.h"

class PackageDetails : public Lum::Dlg::ActionDialog
{
private:
  Package&                package;
  std::list<std::wstring> files;

private:
  Lum::Object* GetTextField(const std::wstring& text) const;

public:
  PackageDetails(Package& package);

  Lum::Object* GetContent();
  void GetActions(std::vector<Lum::Dlg::ActionInfo>& actions);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif

