/*
  PackageView - Show debian package details
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Package.h"

#include <iostream>
#include <fstream>

#include <Lum/Base/String.h>

#include <Lum/Panel.h>
#include <Lum/Text.h>

#include "Globals.h"

Package::Package()
: state(pkgCache::State::NotInstalled),
  size(0),
  installedSize(0)
{
  // no code
}

Package::~Package()
{
}

void Package::SetName(const std::wstring& name)
{
  this->name=name;
}

std::wstring Package::GetName() const
{
  return name;
}

void Package::SetVersion(const std::wstring& version)
{
  this->version=version;
}

std::wstring Package::GetVersion() const
{
  return version;
}

void Package::SetSection(const std::wstring& section)
{
  this->section=section;
}

std::wstring Package::GetSection() const
{
  return section;
}

void Package::SetShortDescription(const std::wstring& shortDescription)
{
  this->shortDesc=shortDescription;
}

std::wstring Package::GetShortDescription() const
{
  return shortDesc;
}

void Package::SetDescription(const std::wstring& description)
{
  this->longDesc=description;
}

std::wstring Package::GetDescription() const
{
  return longDesc;
}

void Package::SetMaintainer(const std::wstring& maintainer)
{
  this->maintainer=maintainer;
}

std::wstring Package::GetMaintainer() const
{
  return maintainer;
}

void Package::SetHomepage(const std::wstring& homepage)
{
  this->homepage=homepage;
}

std::wstring Package::GetHomepage() const
{
  return homepage;
}

void Package::SetDependencies(const std::wstring& dependencies)
{
  this->dependencies=dependencies;
}

void Package::SetState(pkgCache::State::PkgCurrentState state)
{
  this->state=state;
}

std::wstring Package::GetDependencies() const
{
  return dependencies;
}

void Package::SetPackageSize(size_t packageSize)
{
  size=packageSize;
}

size_t Package::GetPackageSize() const
{
  return size;
}

void Package::SetInstalledSize(size_t installedSize)
{
  this->installedSize=installedSize;
}

size_t Package::GetInstalledSize() const
{
  return installedSize;
}

bool Package::LoadPackageContent(std::list<std::wstring>& content)
{
  content.clear();

  std::ifstream file;
  std::string   line;

  file.open(Lum::Base::WStringToString(L"/var/lib/dpkg/info/"+name+L".list").c_str(),std::ios::in);

  if (!file) {
    std::cerr << "Cannot open package file list!" << std::endl;
    return false;
  }

  while (std::getline(file,line)) {
    content.push_back(Lum::Base::StringToWString(line));
  }

  file.close();

  return true;
}

PackageEntry::PackageEntry(Package* package)
 : package(package),
   nameObject(NULL)
{
}

PackageEntry::~PackageEntry()
{
  delete nameObject;
}

Lum::Object* PackageEntry::GetObject(size_t column) const
{
  switch (column) {
  case 1:
    if (nameObject==NULL) {
      Lum::Panel *panel;
      Lum::Text  *text;

      panel=Lum::VPanel::Create(true,true);

      text=new Lum::Text();
      text->SetFlex(true,true);
      text->AddText(package->GetName(),Lum::OS::Font::bold);
      text->AddText(L" (");
      text->AddText(package->GetSection(),
                    Lum::OS::Font::normal,
                    Lum::OS::display->GetFont(Lum::OS::Display::fontScaleFootnote));
      text->AddText(L")");
      panel->Add(text);

      text=new Lum::Text(package->GetShortDescription(),
                         Lum::OS::Font::italic,
                         Lum::Text::left,
                         Lum::OS::display->GetFont(Lum::OS::Display::fontScaleFootnote));
      text->SetFlex(true,true);
      panel->Add(text);

      nameObject=panel;
    }
    return nameObject;
  default:
    return NULL;
  }
}

std::wstring PackageEntry::GetString(size_t column) const
{
  switch (column) {
  case 1:
    return L"";
  case 2:
    return package->GetVersion();
  default:
    assert(false);
  }
}

Package* PackageEntry::GetPackage() const
{
  return package;
}

