/*
  MaemoRate - Rate maemo packages
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Package.h"

#include <Lum/Image.h>
#include <Lum/Panel.h>
#include <Lum/Text.h>

#include "Globals.h"

Package::Package(Lum::Model::ListTable *table,
                 const std::wstring& name,
                 const std::wstring& version,
                 const std::wstring& description,
                 int score)
: Lum::Model::ListTable::Entry(table),
  name(name),
  version(version),
  description(description),
  score(score),
  nameObject(NULL),
  ratingObject(NULL)
{
  // no code
}

Package::~Package()
{
  delete nameObject;
}

Lum::Object* Package::GetObject(size_t column) const
{
  switch (column) {
  case 1:
    if (nameObject==NULL) {
      Lum::Panel *panel;
      Lum::Text  *text;

      panel=Lum::VPanel::Create(true,true);

      text=new Lum::Text(name,
                         Lum::OS::Font::bold,
                         Lum::Text::left);
      text->AddText(L" "+version);
      text->SetFlex(true,false);
      panel->Add(text);

      text=new Lum::Text(description,
                         Lum::OS::Font::italic,
                         Lum::Text::left,
                         Lum::OS::display->GetFont(Lum::OS::Display::fontScaleFootnote));
      text->SetFlex(true,false);
      panel->Add(text);

      nameObject=panel;
    }
    return nameObject;
  case 2:
    if (ratingObject==NULL) {
      Lum::Image *image;
      Lum::Panel *panel;

      panel=new Lum::HPanel();
      if (score>=0) {
        for (size_t i=1; i<=5; i++) {
          image=new Lum::Image();
          if (i<=(size_t)score) {
            image->SetImage(fullStar);
          }
          else {
            image->SetImage(emptyStar);
          }
          panel->Add(image);
        }
      }

      ratingObject=panel;
    }
    return ratingObject;
  default:
    return NULL;
  }
}


std::wstring Package::GetString(size_t column) const
{
  switch (column) {
  case 1:
    return L"";
  case 2:
    return L"";
  default:
    assert(false);
  }
}

std::wstring Package::GetName() const
{
  return name;
}

std::wstring Package::GetVersion() const
{
  return version;
}

bool Package::IsGreater(const Entry* other, size_t column) const
{
  return name>dynamic_cast<const Package*>(other)->name;
}

void Package::UpdateScore(int score)
{
  this->score=score;

  delete ratingObject;
  ratingObject=NULL;

  table->RedrawCell(2,table->GetRow(this));
}

