#!/usr/bin/python
# -*- coding: utf-8 -*-

import gobject, gtk
import hildondesktop
import hildon
import subprocess
import time
from os import path
from ConfigParser import SafeConfigParser

class opensshStatus(hildondesktop.StatusMenuItem):
    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)

        self.confirmDisconnect = True
        self.showConnected = True
        self.stopTracking = False
        self.skipSystemCheck = False
        connectedIcon = "symbol"
        if path.isfile("/home/user/.openssh-status-widget"):
            parser = SafeConfigParser()
            try:
                parser.read('/home/user/.openssh-status-widget')
            except:
                subprocess.call(["rm", "/home/user/.openssh-status-widget"])
            if parser.has_option('options', 'confirmDisconnect'):
                self.confirmDisconnect = parser.getboolean('options', 'confirmDisconnect')
            if parser.has_option('options', 'showConnected'):
                self.showConnected = parser.getboolean('options', 'showConnected')
            if parser.has_option('options', 'stopTracking'):
                self.stopTracking = parser.getboolean('options', 'stopTracking')
            if parser.has_option('options', 'skipSystemCheck'):
                self.skipSystemCheck = parser.getboolean('options', 'skipSystemCheck')
            if parser.has_option('options', 'connectedIcon'):
                connectedIcon = parser.get('options', 'connectedIcon')
            
        self.icon=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_no-users.png")
        try:
            self.icon_plus=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_users_"+connectedIcon.lower().strip('_')+".png")
        except:
            self.icon_plus=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_users_symbol.png")

        self.button=hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button.set_alignment(0.2,0.5,1,1)

        self.image_off=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_off.png")
        self.image_on=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_on.png")
        self.button.set_image_position(gtk.POS_LEFT)

        self.add(self.button)
        self.show_all()

        self.on = False
        self.connected = False
        self.refresh = False
        self.sshJustOff = 0
        
        self.start()

        self.button.connect("clicked", self.buttonClicked)
        self.button.tap_and_hold_setup(None, None, 0)
        self.button.connect("tap-and-hold", self.buttonPressed)
        
    def start(self):
        if not self.skipSystemCheck:
            sshSystemRespawn = False
            if path.isfile("/etc/event.d/sshd"):
                sshFile = open("/etc/event.d/sshd",'r')
                lines = sshFile.readlines()
                sshFile.close()
                for line in lines:
                    if line.strip('\n').strip(' ') == "respawn":
                        sshSystemRespawn = True
            if sshSystemRespawn:
                self.adjustSshFile()
        
        self.sshStatus()
        self.sshUsers()
        if self.sshRunning:
            self.on = True
            self.button.set_image(self.image_on)
            if self.sshConnected and self.showConnected:
                self.connected = True
                self.set_status_area_icon(self.icon_plus)
            else:
                self.set_status_area_icon(self.icon)
            self.refresh = True
            gobject.timeout_add(2000, self.sshTracker)
        else:
            self.button.set_image(self.image_off)
            if self.sshConnected:
                if self.showConnected:
                    self.connected = True
                    self.set_status_area_icon(self.icon_plus)
                else:
                    self.set_status_area_icon(self.icon)
                self.refresh = True
                gobject.timeout_add(2000, self.sshTracker)
            else:
                self.set_status_area_icon(None)
                self.button.set_text("OpenSSH Server", "Off")
                if not self.stopTracking:
                    self.refresh = True
                    gobject.timeout_add(2000, self.sshTracker)
            
    def adjustSshFile(self):
        self.dialog = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("The widget has detected a system configuration for respawning the OpenSSH server. "
        "For error-free function of this widget respawning the server should be disabled.\n\nDo you want the widget to disable it now?\n")
        text.set_line_wrap(True)
        self.dialog.vbox.pack_start(text)
        buttonYes = self.dialog.add_button("Yes", gtk.RESPONSE_YES)
        buttonNo = self.dialog.add_button("No", gtk.RESPONSE_NO)
        buttonDetails = self.dialog.add_button("Details", gtk.RESPONSE_NONE)
        
        buttonYes.connect("clicked", self.adjustYes)
        buttonNo.connect("clicked", self.adjustNo)
        buttonDetails.connect("clicked", self.detailsMessage)
        
        self.dialog.show_all()
        
    def adjustYes(self, dummy):
        subprocess.call(["sudo", "/usr/sbin/openssh-status.sh", "disable_respawn"])
        self.dialog.destroy()
        message = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("Done! Please reboot the N900.")
        text.set_line_wrap(True)
        message.vbox.add(text)
        message.add_button("Close", gtk.RESPONSE_OK)
            
        message.show_all()
        message.run()
        message.destroy()
        
    def adjustNo(self, dummy):
        self.dialog.destroy()

    def detailsMessage(self,dummy):
        message = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("The widget will modify the file\n\n/etc/event.d/sshd\n\nby commenting out the relevant line\nin the existing file. Nothing will be deleted.")
        text.set_line_wrap(True)
        message.vbox.add(text)
        message.add_button("Close", gtk.RESPONSE_OK)
            
        message.show_all()
        message.run()
        message.destroy()
        
    def sshStatus(self):
        shellCommand1=subprocess.Popen(["ps", "aux"], stdout=subprocess.PIPE)
        shellCommand2=subprocess.Popen(["grep", "-c", "/usr/sbin/sshd"], stdin=shellCommand1.stdout, stdout=subprocess.PIPE)
        shellCommand1.stdout.close()
        self.sshRunning=int(shellCommand2.communicate()[0])-1
        
    def sshUsers(self):
        shellCommand1=subprocess.Popen(["ps", "aux"], stdout=subprocess.PIPE)
        shellCommand2=subprocess.Popen(["grep", "sshd:"], stdin=shellCommand1.stdout, stdout=subprocess.PIPE)
        shellCommand3=subprocess.Popen(["grep", "-c", "@"], stdin=shellCommand2.stdout, stdout=subprocess.PIPE)
        shellCommand1.stdout.close()
        shellCommand2.stdout.close()
        self.sshConnected = int(shellCommand3.communicate()[0])
        
    def sshTracker(self):
        self.sshStatus()
        self.sshUsers()
        if self.sshRunning and self.sshJustOff:
            self.sshJustOff = 0
        if not self.sshRunning and self.on:
            self.on = False
            self.button.set_image(self.image_off)
        if self.sshRunning and not self.on:
            self.on = True
            self.button.set_image(self.image_on)
            if self.sshConnected and self.showConnected:
                self.connected = True
                self.set_status_area_icon(self.icon_plus)
            else:
                self.connected = False
                self.set_status_area_icon(self.icon)
        if self.showConnected:
            if self.sshConnected and not self.connected:
                self.connected = True
                self.set_status_area_icon(self.icon_plus)
            if self.sshRunning and not self.sshConnected and self.connected:
                self.connected = False
                self.set_status_area_icon(self.icon)
        if self.sshConnected == 1:
            self.button.set_text("OpenSSH Server", str(self.sshConnected)+" connection")
            return True
        elif self.sshConnected > 1 or (not self.sshConnected and self.sshRunning):
            self.button.set_text("OpenSSH Server", str(self.sshConnected)+" connections")
            return True
        else:
            if self.sshJustOff < 1:
                self.sshJustOff += 1
                return True
            else:
                self.on = False
                self.button.set_image(self.image_off)
                self.set_status_area_icon(None)
                self.button.set_text("OpenSSH Server", "Off")
                if self.stopTracking:
                    if self.sshJustOff < 5:
                        self.sshJustOff += 1
                        return True
                    else:
                        self.sshJustOff = 0
                        self.refresh = False
                        return False
                else:
                    return True
        
    def buttonClicked(self, dummy):
        self.sshStatus()
        if self.sshRunning and self.on:
            subprocess.call(["sudo", "/usr/sbin/openssh-status.sh", "stop_sshd"])
            time.sleep(0.5)
            self.sshStatus()
            if self.sshRunning:
                self.printDialog("Could NOT stop OpenSSH Server!")
            else:
                self.on = False
                self.button.set_image(self.image_off)
                self.sshUsers()
                if not self.sshConnected:
                    self.set_status_area_icon(None)
                    self.button.set_text("OpenSSH Server", "Off")
        elif self.sshRunning and not self.on:
            self.on = True
            self.button.set_image(self.image_on)
            self.sshUsers()
            if self.sshConnected:
                self.button.set_text("OpenSSH Server", "")
                if self.showConnected:
                    self.connected = True
                    self.set_status_area_icon(self.icon_plus)
                else:
                    self.connected = False
                    self.set_status_area_icon(self.icon)
            else:
                self.button.set_text("OpenSSH Server", "0 connections")
                self.connected = False
                self.set_status_area_icon(self.icon)
            if not self.refresh:
                self.refresh = True
                gobject.timeout_add(2000, self.sshTracker)
            self.printDialog("OpenSSH Server already running! Display updated.")
        else:
            subprocess.call(["sudo", "/usr/sbin/openssh-status.sh", "start_sshd"])
            time.sleep(0.5)
            self.sshStatus()
            self.sshUsers()
            if self.sshRunning:
                self.on = True
                self.button.set_image(self.image_on)
                if not self.sshConnected:
                    self.button.set_text("OpenSSH Server", "0 connections")
                    self.connected = False
                    self.set_status_area_icon(self.icon)
                if not self.refresh:
                    self.refresh = True
                    gobject.timeout_add(2000, self.sshTracker)
            else:
                self.printDialog("Could NOT start OpenSSH Server!")

    def buttonPressed(self, dummy):
        self.button.get_toplevel().hide()
        self.sshStatus()
        self.sshUsers()
        if (self.sshRunning or self.sshConnected) and self.confirmDisconnect:
            self.dialog = gtk.Dialog("OpenSSH status", None)
            text = gtk.Label("Disconnect and stop server?\n")
            text.set_line_wrap(True)
            self.dialog.vbox.pack_start(text)
            self.dialog.add_button("Disconnect", gtk.RESPONSE_YES)
            self.dialog.add_button("Abort", gtk.RESPONSE_NO)
            self.dialog.show_all()
            response = self.dialog.run()
            if response <> gtk.RESPONSE_YES:
                self.dialog.destroy()
                return
            else:
                self.dialog.destroy()
                self.sshDisconnect() 
        elif self.sshRunning or self.sshConnected:
            self.sshDisconnect()
        else:
            time.sleep(0.5)
            self.printDialog("OpenSSH Server already stopped!")
        
    def sshDisconnect(self):
        self.sshStatus()
        self.sshUsers()
        if self.sshRunning:
            subprocess.call(["sudo", "/usr/sbin/openssh-status.sh", "kill_sshd"])
            time.sleep(0.5)
            self.sshStatus()
            self.sshUsers()
            if self.sshRunning:
                self.printDialog("Could NOT stop OpenSSH Server!")
            elif self.sshConnected:
                self.printDialog("Could NOT close OpenSSH connections!")
            else:
                self.on = False
                self.button.set_text("OpenSSH Server", "Off")
                self.button.set_image(self.image_off)
                self.set_status_area_icon(None)
        elif self.sshConnected:
            subprocess.call(["sudo", "/usr/sbin/openssh-status.sh", "kill_sshd"])
            time.sleep(0.5)
            self.sshUsers()
            if self.sshConnected:
                self.printDialog("Could NOT close OpenSSH connections!")
            else:
                self.on = False
                self.button.set_text("OpenSSH Server", "Off")
                self.button.set_image(self.image_off)
                self.set_status_area_icon(None)
        else:
            time.sleep(0.5)
            self.printDialog("OpenSSH Server already stopped!")
            
    def printDialog(self, msg):
        subprocess.call(["run-standalone.sh", "dbus-send", "--print-reply", \
        "--type=method_call", "--dest=org.freedesktop.Notifications", \
        "/org/freedesktop/Notifications", "org.freedesktop.Notifications.SystemNoteDialog", \
        "string:"+msg, "uint32:0", "string:"])

hd_plugin_type = opensshStatus
