#!/usr/bin/python
# -*- coding: utf-8 -*-

import gobject, gtk
import hildondesktop
import hildon
import subprocess
import time

class opensshStatus(hildondesktop.StatusMenuItem):
    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)

        self.icon=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status.png")

        self.button=hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button.set_alignment(0.2,0.5,1,1)

        self.image_off=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_off.png")
        self.image_on=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_on.png")
        self.button.set_image_position(gtk.POS_LEFT)

        self.add(self.button)
        self.show_all()

        self.start()

        self.button.connect("clicked", self.buttonClicked)
        self.button.tap_and_hold_setup(None, None, 0)
        self.button.connect("tap-and-hold", self.buttonPressed)
        
    
    def start(self):
        self.sshStatus()
        if self.sshRunning:
            self.button.set_image(self.image_on)
            self.set_status_area_icon(self.icon)
            gobject.timeout_add(2000, self.sshConnections)
        else:
            self.button.set_image(self.image_off)
            self.sshUsers()
            if self.sshConnected:
                self.set_status_area_icon(self.icon)
                gobject.timeout_add(2000, self.sshConnections)
            else:
                self.set_status_area_icon()
                self.button.set_text("OpenSSH Server", "Off")
        
    def sshStatus(self):
        shellCommand1=subprocess.Popen(["ps", "aux"], stdout=subprocess.PIPE)
        shellCommand2=subprocess.Popen(["grep", "-c", "/usr/sbin/sshd"], stdin=shellCommand1.stdout, stdout=subprocess.PIPE)
        shellCommand1.stdout.close()
        self.sshRunning=int(shellCommand2.communicate()[0])-1
        
    def sshUsers(self):
        shellCommand1=subprocess.Popen(["ps", "aux"], stdout=subprocess.PIPE)
        shellCommand2=subprocess.Popen(["grep", "sshd:"], stdin=shellCommand1.stdout, stdout=subprocess.PIPE)
        shellCommand3=subprocess.Popen(["grep", "-c", "@"], stdin=shellCommand2.stdout, stdout=subprocess.PIPE)
        shellCommand1.stdout.close()
        shellCommand2.stdout.close()
        self.sshConnected = int(shellCommand3.communicate()[0])
        
    def sshConnections(self):
        self.sshStatus()
        self.sshUsers()
        if self.sshConnected == 1:
            self.button.set_text("OpenSSH Server", str(self.sshConnected)+" connection")
            return True
        elif self.sshConnected > 1 or (not self.sshConnected and self.sshRunning):
            self.button.set_text("OpenSSH Server", str(self.sshConnected)+" connections")
            return True
        else:
            self.set_status_area_icon()
            self.button.set_text("OpenSSH Server", "Off")
            return False
        
    def buttonClicked(self, dummy):
        self.sshStatus()
        if self.sshRunning:
            subprocess.call(["sudo", "/etc/init.d/ssh", "stop"])
            time.sleep(0.5)
            self.sshStatus()
            if self.sshRunning:
                self.printDialog("Could NOT stop OpenSSH Server!")
            else:
                self.button.set_image(self.image_off)
                self.sshUsers()
                if not self.sshConnected:
                    self.set_status_area_icon()
                    self.button.set_text("OpenSSH Server", "Off")
        else:
            self.sshUsers()
            subprocess.call(["sudo", "/etc/init.d/ssh", "start"])
            time.sleep(0.5)
            self.sshStatus()
            if self.sshRunning:
                self.button.set_image(self.image_on)
                if not self.sshConnected:
                    self.set_status_area_icon(self.icon)
                    self.button.set_text("OpenSSH Server", "0 connections")
                    gobject.timeout_add(2000, self.sshConnections)
            else:
                self.printDialog("Could NOT start OpenSSH Server!")

    def buttonPressed(self, dummy):
        self.button.get_toplevel().hide()
        self.sshStatus()
        self.sshUsers()
        if self.sshRunning or self.sshConnected:
            subprocess.call(["sudo", "killall", "sshd"])
            time.sleep(0.5)
            self.sshStatus()
            self.sshUsers()
            if self.sshRunning:
                self.printDialog("Could NOT stop OpenSSH Server!")
            elif self.sshConnected:
                self.printDialog("Could NOT close OpenSSH connections!")
            else:
                self.button.set_text("OpenSSH Server", "Off")
                self.button.set_image(self.image_off)
                self.set_status_area_icon()
        else:
            time.sleep(0.5)
            self.printDialog("OpenSSH Server already stopped!")

    def printDialog(self, msg):
        subprocess.call(["run-standalone.sh", "dbus-send", "--print-reply", \
        "--type=method_call", "--dest=org.freedesktop.Notifications", \
        "/org/freedesktop/Notifications", "org.freedesktop.Notifications.SystemNoteDialog", \
        "string:"+msg, "uint32:0", "string:"])
hd_plugin_type = opensshStatus
