#!/usr/bin/env python

import dbus
from PyQt4 import QtCore

#Thanks to code from http://qt-mobility.blogspot.com/2010/03/getting-n900-battery-level-via-python-d.html

class LevelReader(QtCore.QObject):
    #Declare signals
    battery_change = QtCore.pyqtSignal(int) #Fired when battery level changes
    signal_change = QtCore.pyqtSignal(int)   #Fired when signal level changes
    
    #Class level variables
    battery_level = -666 #initialize to invalid number
    signal_level = -666 #initialize to invalid number
    refresh_seconds = 5 #frequency of refresh
    timer = QtCore.QTimer()
    battery_dev_obj = None
    phone_net_intf = None
    
    def __init__(self):
        QtCore.QObject.__init__(self)
        
        #Need the system bus locally
        bus = dbus.SystemBus()

        #Set up battery dbus object interface as class-level variable
        try:
            hal_obj = bus.get_object('org.freedesktop.Hal','/org/freedesktop/Hal/Manager')
            hal = dbus.Interface(hal_obj,'org.freedesktop.Hal.Manager')
            uids = hal.FindDeviceByCapability('battery')
            self.battery_dev_obj = bus.get_object('org.freedesktop.Hal', uids[0])
        except dbus.DBusException:
            print "ERROR: Unable to connect to battery charge dbus object"
            self.battery_dev_obj  = None
        except Exception,e:
            print "ERROR: Unknown exception connecting to DBus for battery charge: ",  e
            self.battery_dev_obj  = None
        
        #Set up signal level dbus interface as class-level variable
        try:
            phone_net_obj = bus.get_object('com.nokia.phone.net','/com/nokia/phone/net', introspect=False)
            self.phone_net_intf = dbus.Interface(self.phone_net_obj,'Phone.Net')
        except dbus.DBusException:
            print "ERROR: Unable to connect to signal level dbus object"
            self.phone_net_intf = None
        except Exception,e:
            print "ERROR: Unknown exception connecting to DBus for signal level: ",  e
            self.phone_net_intf = None
        
        #bind my checks to the timer
        QtCore.QObject.connect(self.timer, QtCore.SIGNAL("timeout()"), self,  QtCore.SLOT("check_battery_change()"))
        QtCore.QObject.connect(self.timer, QtCore.SIGNAL("timeout()"), self,  QtCore.SLOT("check_signal_change()"))
        self.timer.start(5 * self.refresh_seconds)

    # Read the dbus values

    def get_battery_percentage(self):
        if self.battery_dev_obj==None:
            return 0
        try:
            prop_value = self.battery_dev_obj.GetProperty('battery.charge_level.percentage')
            int_value = int(prop_value)
            return int_value
        except dbus.DBusException:
            return 0
    
    def get_signal_percentage(self):
        if self.phone_net_intf==None:
            return 0
        try:
            dbus_return = self.phone_net_intf.get_signal_strength()
            return int(dbus_return[0])
        except dbus.DBusException:
            return 0
    
    #Declare my Qt Slots for binding with the timer
    
    @QtCore.pyqtSlot()
    def check_battery_change(self):
        new_battery_level = self.get_battery_percentage()
        if new_battery_level==self.battery_level:
            return
        self.battery_level = new_battery_level
        self.battery_change.emit(new_battery_level)
    
    @QtCore.pyqtSlot()
    def check_signal_change(self):
        new_signal_level = self.get_signal_percentage()
        if new_signal_level==self.signal_level:
            return
        self.signal_level = new_signal_level
        self.signal_change.emit(new_signal_level)
