﻿ #!/usr/bin/env python
# -*- coding: utf-8 -*-
# 

import pygtk
import sqlite3
import gtk
from gtk import Window, Button, Widget
import hildon
import time
import string

import gobject, dbus
from dbus.mainloop.glib import DBusGMainLoop
 
#DB_PATH = "/home/opt/Caller/phonedb.db3"

def show_notification_dialog(message):
	window = hildon.Window()
	banner = hildon.hildon_banner_show_information(window, "", message)
	banner.set_timeout(20000)
	
def handle_call_incoming(obj_path, callernumber):
    #print '%s is calling' % callernumber
    handle_parse_number(callernumber)

def handle_call_outgoing(obj_path, callernumber):
    if obj_path == "/com/nokia/csd/call/1":
        #print 'calling to %s' % callernumber
        handle_parse_number(callernumber)

def handle_parse_number(callernumber):
    l = len(callernumber)
    f = callernumber[0]
    s = callernumber[1]
    if l < 6:
        show_notification_dialog('特服号')
    elif f == '0' and s < '3':
        getarea(callernumber[1:3])
    elif f == '0' and s > '3':
        getarea(callernumber[1:4])
    elif l > 8 and f == '1':
        getarea(callernumber[0:7])
    else:
        show_notification_dialog('号码归属地与类型未知')
    
    #update number location for call log.
    parseNumberLocation(callernumber, "")
        
    
def parseNumberLocation(number, location):
    number=string.replace(number, "+86", "")
    location = getnumberlocation(number)
    
    conn = sqlite3.connect("/home/user/.rtcom-eventlogger/el-v1.db")
    cur = conn.cursor()
    
    #print 'update remotes set remote_name=remote_uid||\'('+location+')\' where remote_uid=\''+number+'\''
    cur.execute('update remotes set remote_name=remote_uid||\'('+location+')\' where remote_uid=\''+number+'\'')
            
    conn.commit()
    cur.close()
    conn.close()
     
def getnumberlocation(callernumber):
    l = len(callernumber)
    f = callernumber[0]
    s = callernumber[1]
    if l < 6:
        return '特服号'
    elif f == '0' and s < '3':
        return getarealocation(callernumber[1:3])
    elif f == '0' and s > '3':
        return getarealocation(callernumber[1:4])
    elif l > 8 and f == '1':
        return getarealocation(callernumber[0:7])
    else:
        return '未知'
        
def getarealocation(areacode):
    conn = sqlite3.connect("/home/user/apps/numberlocation/location.db3")
    cur = conn.cursor()
    cur.execute('select s_area,s_type from cw where n_phonenum='+areacode)
    row = cur.fetchone()
    #show_notification_dialog('号码归属地:'+row[0]+'\n号码类型:'+row[1])
    cur.close()
    if row:
        return row[0]
    else:
        return '未知'
    

def getarea(areacode):
    conn = sqlite3.connect("/home/user/apps/numberlocation/location.db3")
    cur = conn.cursor()
    cur.execute('select s_area,s_type from cw where n_phonenum='+areacode)
    row = cur.fetchone()
    show_notification_dialog('号码归属地:'+row[0]+'\n号码类型:'+row[1])
    cur.close()

DBusGMainLoop(set_as_default=True)
bus = dbus.SystemBus()

#---Incoming callbacks------------------------------------
#[SIGNAL] com.nokia.csd.Call.Coming  /com/nokia/csd/call  :1.17
bus.add_signal_receiver(handle_call_incoming,
                        dbus_interface=None,
                        signal_name="Coming",
                        bus_name="com.nokia.csd",
                        path="/com/nokia/csd/call",
                        )

#---Outgoing callbacks------------------------------------
#[SIGNAL] com.nokia.csd.Call.Created  /com/nokia/csd/call  :1.17
bus.add_signal_receiver(handle_call_outgoing,
                        dbus_interface=None,
                        signal_name="Created",
                        bus_name="com.nokia.csd",
                        path="/com/nokia/csd/call",
                        )
                        
gobject.MainLoop().run()

if __name__ == '__main__':
    gtk.main()

