<instrumentationManifest
    xmlns="http://schemas.microsoft.com/win/2004/08/events" 
    xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events"
    xmlns:xs="http://www.w3.org/2001/XMLSchema">
    <instrumentation>
        <events>
            <provider name="NodeJS-ETW-provider" 
                guid="{77754E9B-264B-4D8D-B981-E4135C1ECB0C}" 
                symbol="NODE_ETW_PROVIDER" 
                resourceFileName="node.exe" 
                messageFileName="node.exe">

                <opcodes>
                    <opcode name="NODE_HTTP_SERVER_REQUEST" value="10"/>
                    <opcode name="NODE_HTTP_SERVER_RESPONSE" value="11"/>
                    <opcode name="NODE_HTTP_CLIENT_REQUEST" value="12"/>
                    <opcode name="NODE_HTTP_CLIENT_RESPONSE" value="13"/>
                    <opcode name="NODE_NET_SERVER_CONNECTION" value="14"/>
                    <opcode name="NODE_NET_STREAM_END" value="15"/>
                    <opcode name="NODE_GC_START" value="16"/>
                    <opcode name="NODE_GC_DONE" value="17"/>
                </opcodes>

                <templates>
                    <template tid="node_connection">
                        <data name="fd" inType="win:UInt32" />
                        <data name="port" inType="win:UInt32" />
                        <data name="remote" inType="win:AnsiString" />
                        <data name="buffered" inType="win:UInt32" />
                    </template>

                    <template tid="node_http_client_request">
                        <data name="url" inType="win:AnsiString" />
                        <data name="method" inType="win:AnsiString" />
                        <data name="fd" inType="win:UInt32" />
                        <data name="port" inType="win:UInt32" />
                        <data name="remote" inType="win:AnsiString" />
                        <data name="buffered" inType="win:UInt32" />
                    </template>

                    <template tid="node_http_server_request">
                        <data name="url" inType="win:AnsiString" />
                        <data name="method" inType="win:AnsiString" />
                        <data name="forwardedFor" inType="win:AnsiString" />
                        <data name="fd" inType="win:UInt32" />
                        <data name="port" inType="win:UInt32" />
                        <data name="remote" inType="win:AnsiString" />
                        <data name="buffered" inType="win:UInt32" />
                    </template>

                    <template tid="node_gc">
                        <data name="gctype" inType="win:UInt32" />
                        <data name="gccallbackflags" inType="win:UInt32" />
                    </template>
                </templates>

                <events>
                    <event value="1" 
                        opcode="NODE_HTTP_SERVER_REQUEST"
                        template="node_http_server_request"
                        symbol="NODE_HTTP_SERVER_REQUEST_EVENT"
                        level="win:Informational"/>
                    <event value="2" 
                        opcode="NODE_HTTP_SERVER_RESPONSE"
                        template="node_connection"
                        symbol="NODE_HTTP_SERVER_RESPONSE_EVENT"
                        level="win:Informational"/>
                    <event value="3" 
                        opcode="NODE_HTTP_CLIENT_REQUEST"
                        template="node_http_client_request"
                        symbol="NODE_HTTP_CLIENT_REQUEST_EVENT"
                        level="win:Informational"/>
                    <event value="4" 
                        opcode="NODE_HTTP_CLIENT_RESPONSE"
                        template="node_connection"
                        symbol="NODE_HTTP_CLIENT_RESPONSE_EVENT"
                        level="win:Informational"/>
                    <event value="5" 
                        opcode="NODE_NET_SERVER_CONNECTION"
                        template="node_connection"
                        symbol="NODE_NET_SERVER_CONNECTION_EVENT"
                        level="win:Informational"/>
                    <event value="6" 
                        opcode="NODE_NET_STREAM_END"
                        template="node_connection"
                        symbol="NODE_NET_STREAM_END_EVENT"
                        level="win:Informational"/>
                    <event value="7" 
                        opcode="NODE_GC_START"
                        template="node_gc"
                        symbol="NODE_GC_START_EVENT"
                        level="win:Informational"/>
                    <event value="8" 
                        opcode="NODE_GC_DONE"
                        template="node_gc"
                        symbol="NODE_GC_DONE_EVENT"
                        level="win:Informational"/>
                </events>
            </provider>
        </events>
    </instrumentation>
</instrumentationManifest>
