import QtQuick 2.0
import Sailfish.Silica 1.0
import "../components"

PageWrapper {
    id: welcomePage
    signal login()

    property bool newuser: false
    headerText: ""

    function load() {
        welcomePage.login.connect(function(){
            //create login Component
            stack.push(Qt.resolvedUrl("Login24sq.qml"));
        });
    }

    Column{
        id: loginBox
        anchors.centerIn: parent
        spacing: 20

        Image {
            anchors.horizontalCenter: parent.horizontalCenter
            source: "../images/harbour-nelisquare256.png"
        }

        Text {
            anchors.horizontalCenter: parent.horizontalCenter
            text: qsTr("Welcome!")
            color: myTheme.highlightColor
            font.pixelSize: myTheme.fontSizeLarge
            visible: newuser
        }

        Text {
            anchors.horizontalCenter: parent.horizontalCenter
            text: qsTr("Please, login with Foursquare!")
            color: myTheme.primaryColor
            font.pixelSize: myTheme.fontSizeMedium
        }
        Button {
            id: loginButton
            anchors.horizontalCenter: parent.horizontalCenter
            text: qsTr("Login")
            onClicked: {
                welcomePage.login();
            }
        }

        Item {
            width: parent.width
            height: 50
        }

        Text {
            anchors.horizontalCenter: parent.horizontalCenter
            text: qsTr("Foursquare privacy policy")
            color: myTheme.secondaryHighlightColor
            font.underline: true
            font.pixelSize: myTheme.fontSizeSmall
            MouseArea {
                anchors.fill: parent
                onClicked: {
                    Qt.openUrlExternally("https://foursquare.com/legal/terms")
                }
            }
        }

        Text {
            anchors.horizontalCenter: parent.horizontalCenter
            text: qsTr("Nelisquare privacy policy")
            color: myTheme.secondaryHighlightColor
            font.underline: true
            font.pixelSize: myTheme.fontSizeSmall
            MouseArea {
                anchors.fill: parent
                onClicked: {
                    Qt.openUrlExternally("http://thecust.net/nelisquare/privacy.txt")
                }
            }
        }
    }
}
