import QtQuick 2.0

import "../components"
import "../js/utils.js" as Utils

Item {
    id: eventItem

    signal userClicked()
    signal areaClicked()
    signal areaPressAndHold()

    property variant object

    //Old Values
    property string objectId: object.id
    property string userName: "%1 %2".arg(object.user.firstName).arg(Utils.parseString(object.user.lastName))
    property string userShout: Utils.parseString(object.shout)
    property string venueName: object.venue.name
    property variant checkinPhotos: object.photos.items
    property string createdAt: Utils.makeTime(object.createdAt)

    property int commentsCount: comments.count
    property int likesCount: object.likes.count
    property int photosCount: object.photos.count

    property string userPhoto: Utils.makeUserPhoto(object.user.photo)
    property bool activeWhole: true

    ListModel {
        id: comments
    }

    onObjectChanged: {
        if (object.comments && object.comments.count) {
            object.comments.items.forEach(function(comment) {
                comments.append(comment);
            });
        }
        if (object.posts && object.posts.count) {
            object.posts.items.forEach(function(post) {
                comments.append({"user": object.user ,"text": post.text});
            });
        }
    }



    width: parent.width
    height: Math.max(statusTextArea.height,profileImage.height)

    ProfilePhoto {
        id: profileImage
        masked: true
        photoUrl: userPhoto

        onClicked: {
            eventItem.userClicked();
        }
    }

    Column {
        id: statusTextArea
        spacing: 4
        anchors {
            left: profileImage.right
            leftMargin: 12
            right: parent.right
            rightMargin: 12
        }

        Text {
            id: messageText
            color: myTheme.highlightColor
            font.pixelSize: myTheme.fontSizeMedium
            width: parent.width
            text: "%1 @ %2".arg(userName).arg(venueName)
            wrapMode: Text.Wrap
            visible: messageText.text != ""
        }

        Text {
            id: commentText
            color: myTheme.primaryColor
            font.pixelSize: myTheme.fontSizeSmall
            width: parent.width
            text: userShout
            wrapMode: Text.Wrap
            visible: text.length > 1
        }
        Row {
            width: parent.width
            //TODO: add Tiles as photo2 photo3
            ProfilePhoto {
                photoUrl: checkinPhotos.length > 0 ? Utils.makePhoto(checkinPhotos[0],300,100) : ""
                photoCache: true
                photoHeight: 200
                photoWidth: parent.width
                photoBorder: 2
            }
            visible: checkinPhotos.length>0
        }
        Row {
            width: parent.width
            spacing: 10
            Text {
                anchors.verticalCenter: parent.verticalCenter
                color: myTheme.secondaryColor
                font.pixelSize: myTheme.fontSizeSmall
                text: createdAt
                wrapMode: Text.Wrap
                visible: createdAt.length>0
            }
            Image {
                id: commentImage
                anchors.verticalCenter: parent.verticalCenter
                source: "../pics/commentcount.png"
                asynchronous: true
                smooth: true
                height: 32
                fillMode: Image.PreserveAspectFit
                visible: commentsCount>0
            }
            Text {
                id: textComment
                anchors.verticalCenter: parent.verticalCenter
                color: myTheme.secondaryColor
                font.pixelSize: myTheme.fontSizeSmall
                text: commentsCount
                visible: commentsCount>0
            }
            Image {
                id: photoImage
                anchors.verticalCenter: parent.verticalCenter
                source: "../pics/photocount.png"
                asynchronous: true
                smooth: true
                height: 32
                fillMode: Image.PreserveAspectFit
                visible: photosCount>0
            }
            Text {
                id: textPhotos
                anchors.verticalCenter: parent.verticalCenter
                color: myTheme.secondaryColor
                font.pixelSize: myTheme.fontSizeSmall
                text: photosCount
                visible: photosCount>0
            }
            Image {
                id: likesImage
                anchors.verticalCenter: parent.verticalCenter
                source: "../pics/venuelikes_heart.png"
                asynchronous: true
                smooth: true
                height: 32
                fillMode: Image.PreserveAspectFit
                visible: likesCount>0
            }
            Text {
                id: textLikes
                anchors.verticalCenter: parent.verticalCenter
                color: myTheme.secondaryColor
                font.pixelSize: myTheme.fontSizeSmall
                text: likesCount
                visible: likesCount>0
            }
            visible: createdAt.length>0 || commentsCount>0 || likesCount>0 || photosCount>0
        }

        Repeater {
            width: parent.width
            delegate: commentsDelegate
            model: comments
            visible: comments.count>0
        }
    }

    MouseArea {
        anchors.fill: statusTextArea
        onClicked: {
            eventItem.areaClicked();
        }
        onPressAndHold: {
            eventItem.areaPressAndHold();
        }
    }

    Component {
        id: commentsDelegate

        Text {
            width: statusTextArea.width
            color: myTheme.primaryColor
            text: "<b>" + model.user.firstName + "</b>: " + model.text
            font.pixelSize: myTheme.fontSizeSmall
            wrapMode: Text.Wrap

            Image {
                id: commentImage
                anchors.right: parent.left
                anchors.rightMargin: 10
                source: "../pics/commentcount.png"
                asynchronous: true
                smooth: true
                height: 32
                fillMode: Image.PreserveAspectFit
            }
        }
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        onClicked: {
            eventItem.areaClicked();
        }
        onPressAndHold: {
            eventItem.areaPressAndHold();
        }
        visible: activeWhole
    }
}
