import QtQuick 1.1

import "../build.info.js" as BuildInfo
import "../js/update.js" as Updater
import "../js/storage.js" as Storage
import "../js/api.js" as Api

Item   {
    id: configuration

    property string platform: windowHelper.isMaemo() ? "maemo" : "meego"

    property string orientationType: "auto"
    property string mapprovider: "google"
    property string checkupdates: "none"

    property string imageLoadType: "all"
    property int gpsUplockTime: 0 //in seconds
    property int feedAutoUpdate: 0 //in seconds

    property int commentUpdateRate: 300 //currently hardcoded to be 5 mins

    property string accessToken: "empty"

    onCheckupdatesChanged: {
        if (checkupdates!="none") {
            Updater.getUpdateInfo(checkupdates,onUpdateAvailable);
        }
    }

    Component.onCompleted: {
        Storage.getKeyValue("accesstoken", settingLoaded);

        Storage.getKeyValue("settings.orientation", settingLoaded);
        Storage.getKeyValue("settings.mapprovider", settingLoaded);
        Storage.getKeyValue("settings.checkupdates", settingLoaded);
        Storage.getKeyValue("settings.molome", settingLoaded);

        Storage.getKeyValue("settings.imageload", settingLoaded);
        Storage.getKeyValue("settings.gpsunlock", settingLoaded);
        Storage.getKeyValue("settings.feedupdate", settingLoaded);
        Storage.getKeyValue("settings.theme", settingLoaded);

        Storage.getKeyValue("settings.push.enabled",settingLoaded);
    }

    function settingLoaded(key, value) {
        if(key==="accesstoken") {
            console.log("token loaded: " + value);
            Api.setAccessToken(value);
        } else if (key === "settings.orientation") {
            if (value === "") value = "auto";
            configuration.orientationType = value;
            windowHelper.setOrientation(value);
        } else if (key === "settings.mapprovider") {
            if (value === "") value = "google";
            configuration.mapprovider = value;
        } else if (key === "settings.checkupdates") {
            if (value === "") value = "stable";
            configuration.checkupdates = value;
        } else if (key === "settings.molome") {
            //TODO: make install/uninstall (first see) notification enable
            //console.log("molome settings loaded");
            molome.updateinfo();
        } else if (key === "settings.imageload") {
            if (value === "") value = "all";
            configuration.imageLoadType = value;
            cache.loadtype(value);
        } else if (key === "settings.gpsunlock") {
            if (value === "") value = 0;
            configuration.gpsUplockTime = value;
        } else if (key === "settings.feedupdate") {
            if (value === "") value = 0;
            if (value === 60) value = 120;
            configuration.feedAutoUpdate = value;
        } else if (key === "settings.theme") {
            if (value === "") value = "light";
            theme.loadTheme(value);
        } else if (key === "settings.push.enabled") {
            if (value === "")
                pushNotificationDialog.state = "shown";
        } else {
            console.log("Unknown setting: " + key + "=" + value);
        }
    }

    function settingChanged(key, value) {
        Storage.setKeyValue(key, value);
        configuration.settingLoaded(key, value);
    }

    function onUpdateAvailable(build, version, changelog, url) {
        var update = false;
        if (checkupdates == "developer") {
            if (build > BuildInfo.build) {
                update = true;
            }
        } else if (checkupdates == "alpha") {
            if (build > BuildInfo.build) {
                update = true;
            }
        } else if (checkupdates == "stable") {
            if (version !== BuildInfo.version || build !== BuildInfo.build) {
                update = true;
            }
        }

        if (update){
            console.log("UPDATE IS AVAILABLE: " + build);
            /*
            //TODO: Create update "Sheet" component
            */
            updateDialog.build = build;
            updateDialog.version = version;
            updateDialog.url = url;
            updateDialog.changelog = changelog;
            updateDialog.state = "shown";
        }
    }
}
