#include "UIControl.h"
#include "Player.h"

UIControl::UIControl(Player* parent)
{
    this->parent = parent;
    buttonPlay = new QPushButton(QIcon("/opt/necroplayer2/icons/64x64/play.png"),"");
    buttonStop = new QPushButton(QIcon("/opt/necroplayer2/icons/64x64/stop.png"),"");
    buttonNext = new QPushButton(QIcon("/opt/necroplayer2/icons/64x64/next.png"),"");
    buttonPrev = new QPushButton(QIcon("/opt/necroplayer2/icons/64x64/previous.png"),"");

    layoutControl1= new QHBoxLayout;
    layoutControl1->setMargin(4);
    layoutControl1->addSpacing(6);
    layoutControl1->addWidget(buttonPrev);
    layoutControl1->addWidget(buttonPlay);
    layoutControl1->addWidget(buttonStop);
    layoutControl1->addWidget(buttonNext);
    layoutControl1->addSpacing(6);
    layoutControl1->setAlignment(Qt::AlignBottom);

    connect(buttonPrev, SIGNAL(clicked()), SLOT(prev()));
    connect(buttonPlay, SIGNAL(clicked()), SLOT(play()));
    connect(buttonStop, SIGNAL(clicked()), SLOT(stop()));
    connect(buttonNext, SIGNAL(clicked()), SLOT(next()));

    this->setLayout(layoutControl1);
}

UIControl::~UIControl()
{

}

void
UIControl::blockButtons()
{
    buttonPrev->blockSignals(true);
    buttonPlay->blockSignals(true);
    buttonStop->blockSignals(true);
    buttonNext->blockSignals(true);
}

void
UIControl::unblockButtons()
{
    buttonPrev->blockSignals(false);
    buttonPlay->blockSignals(false);
    buttonStop->blockSignals(false);
    buttonNext->blockSignals(false);
}

void
UIControl::play()
{
    parent->play(-1, 0);
}

void
UIControl::stop()
{
    parent->stop();
}

void
UIControl::next()
{
    parent->next(true);
}

void
UIControl::prev()
{
    parent->prev();
}

void
UIControl::setPlayIcon(Phonon::State state)
{
    switch (state)
    {
    case Phonon::PlayingState:
        buttonPlay->setIcon(QIcon("/opt/necroplayer2/icons/64x64/play.png"));
        break;
    case Phonon::PausedState:
        buttonPlay->setIcon(QIcon("/opt/necroplayer2/icons/64x64/pause.png"));
        break;
    default:
        break;
    }
}
