#ifndef SIMPLEVIEWFM_H
#define SIMPLEVIEWFM_H

#include <QtGui>
#include "QDBusMessage"

class UI;

class SimpleViewFM : public QWidget
{
    Q_OBJECT
public:
    explicit SimpleViewFM(UI *parent);
    ~SimpleViewFM();

    void setFMFreq(quint32 f);

    QLabel& getFMFreqLabel()
    {
        return *fmFreqLabel;
    }

public slots:

private:
    QGridLayout *simpleFMLayout;
    QPushButton *backButton;
    QLabel *fmTitle, *fmFreqLabel;
    QPushButton *fmFreqDown, *fmFreqUp;
    quint32 fmFreq;

    QDBusMessage msgSetFMFreq;

    UI *parent;

private slots:
    void fmFreqDownClicked();
    void fmFreqUpClicked();

};

#endif // SIMPLEVIEWFM_H
