#include "DBusService.h"
#include "Player.h"
#include <QDBusConnection>

DBusService::DBusService(Player *parent)
{
    this->parent = parent;

    QDBusConnection connection = QDBusConnection::sessionBus();
    connection.registerService("org.maemo.necroplayer2");
    connection.registerObject("/", this, QDBusConnection::ExportAllSlots);
}

void DBusService::play_resource(QString uri)
{
    parent->playResource(QUrl::fromPercentEncoding(QByteArray(QUrl(uri).path().toAscii())));
}

QString DBusService::get_state()
{
    QString printState;

    switch (parent->engine->getReadingState())
    {
    case Phonon::PlayingState:
        printState = "playing";
        break;
    case Phonon::LoadingState:
        if (!parent->engine->getInitialLoadingState())
        {
            printState = "playing";
        }
        else
        {
            printState = "stopped";
        }
        break;
    case Phonon::BufferingState:
        printState = "playing";
        break;
    case Phonon::PausedState:
        printState = "paused";
        break;
    default:
        printState = "stopped";
        break;
    }

    return printState;
}

void DBusService::play_or_pause()
{
    parent->play(-1, 0);
}

void DBusService::stop()
{
    parent->stop();
}

void DBusService::previous()
{
    parent->prev();
}

void DBusService::next()
{
    parent->next(true);
}

void DBusService::toggle_mute()
{
    parent->engine->dbusVolumeButtonClicked();
}

void DBusService::show()
{
    parent->showApp();
}
