#include <iostream>
#include <QtGui>
#include "DelegatePlaylist.h"
#include "Player.h"

UIPlaylist::UIPlaylist(Player* parent)
{
    this->parent = parent;

    trClearPlaylist = tr("Clear playlist");

    widgetPlaylist = new QListWidget(this);
    QPalette p = widgetPlaylist->palette();
    p.setBrush(QPalette::Base, QBrush(QImage("/opt/necroplayer2/images/background.png")));
    widgetPlaylist->setPalette(p);
    widgetPlaylist->setItemDelegate(new DelegatePlaylist(widgetPlaylist));
    setTransparentBackground();

    // Layout
    layout = new QHBoxLayout();
    layout->setMargin(0);

    connect(widgetPlaylist, SIGNAL(itemClicked(QListWidgetItem*)), SLOT(playlistClicked(QListWidgetItem*)));
    connect(widgetPlaylist, SIGNAL(itemDoubleClicked(QListWidgetItem*)), SLOT(playlistDoubleClicked()));

    layout->addSpacing(8);
    layout->addWidget(widgetPlaylist);
    layout->addSpacing(8);
    setLayout(layout);

    boldRow = -1;
}

UIPlaylist::~UIPlaylist()
{
    if (widgetPlaylist)
        delete widgetPlaylist;
    if (layout)
        delete layout;
}

void
UIPlaylist::setTransparentBackground()
{
    if (parent->config->transparentPlaylist)
    {
        widgetPlaylist->setAlternatingRowColors(false);
    }
    else
    {
        widgetPlaylist->setAlternatingRowColors(true);
    }
}

void
UIPlaylist::playlistClicked(QListWidgetItem* item)
{
    if (!item)
        return;

    if (previousItem == item && !itemDeselected)
    {
        if (selectedRow() >= 0)
        {
            widgetPlaylist->item(selectedRow())->setSelected(false);
            itemDeselected = true;
        }
    }
    else if (previousItem != item)
    {
        previousItem = item;
        itemDeselected = false;
    }
    else if (itemDeselected)
        itemDeselected = false;
}

void
UIPlaylist::playlistDoubleClicked()
{
    parent->play(widgetPlaylist->row(previousItem), 2);
}

void
UIPlaylist::addItem(QString s)
{
    QListWidgetItem* item = new QListWidgetItem();
    widgetPlaylist->addItem(item);
    if (!parent->config->useTags || parent->config->updateOnPlay)
    {
        item->setData(UserRoleTitle, s);
        item->setData(UserRoleTitleDefault, s);
    }
}

void
UIPlaylist::changeItem(QString title, QString artist, QString totalTime, int row, short status)
{
    QListWidgetItem* item = widgetPlaylist->item(row);
    if (item)
    {
        item->setData(UserRoleTitle, title);
        item->setData(UserRoleArtist, artist);
        item->setData(UserRoleTotalTime, totalTime);
        if (status != 1)
        {
            item->setData(UserRoleArtistDefault, artist);
            item->setData(UserRoleTotalTimeDefault, totalTime);
            if (status == 0)
                item->setData(UserRoleTitleDefault, title);
            else
                item->setData(UserRoleTitleDisabled, title);
        }
        if (status == 1)
        {
            item->setData(UserRoleTitleActive, title);
            item->setData(UserRoleArtistActive, artist);
            item->setData(UserRoleTotalTimeActive, totalTime);
            parent->engine->currentInfosUpdated(row);
        }
    }
}

void
UIPlaylist::delItem()
{
    int row = selectedRow();
    QListWidgetItem* item = widgetPlaylist->takeItem(row);
    if (item)
    {
        delete item;
        parent->engine->delMedia(row);

        if (!widgetPlaylist->selectedItems().isEmpty())
        {
            previousItem = widgetPlaylist->selectedItems().at(0);
        }

        if (row == boldRow)
        {
            boldRow = -1;
            if (parent->engine->getReadingState() == Phonon::StoppedState)
            {
                parent->ui->setInfos("\n", "");
                parent->engine->getTotalTime()->setText(" /  0:00");
            }
        }

        if (row < boldRow)
        {
            boldRow -= 1;
        }
    }
}

void
UIPlaylist::unsetBoldRow()
{
    boldRow = -1;
}

void
UIPlaylist::setBold(unsigned int row, bool b)
{
    QListWidgetItem* item = widgetPlaylist->item(row);

    if (b && (int)row != boldRow)
    {
        if (item->data(UserRoleTitleDisabled).isNull())
        {
            item->setData(UserRoleTitleActive, item->data(UserRoleTitle));
            item->setData(UserRoleTitleDefault, "");
        }
        else
        {
            item->setData(UserRoleTitleDisabledActive, item->data(UserRoleTitle));
            item->setData(UserRoleTitleDisabled, "");
        }
        item->setData(UserRoleArtistActive, item->data(UserRoleArtist));
        item->setData(UserRoleTotalTimeActive, item->data(UserRoleTotalTime));
        item->setData(UserRoleArtistDefault, "");
        item->setData(UserRoleTotalTimeDefault, "");
    }
    else if (!b)
    {
        if (item->data(UserRoleTitleDisabledActive).isNull())
        {
            item->setData(UserRoleTitleDefault, item->data(UserRoleTitle));
            item->setData(UserRoleTitleActive, "");
        }
        else
        {
            item->setData(UserRoleTitleDisabled, item->data(UserRoleTitle));
            item->setData(UserRoleTitleDisabledActive, "");
        }
        item->setData(UserRoleArtistDefault, item->data(UserRoleArtist));
        item->setData(UserRoleTotalTimeDefault, item->data(UserRoleTotalTime));
        item->setData(UserRoleArtistActive, "");
        item->setData(UserRoleTotalTimeActive, "");
    }

    // workaround to recognize change of playlist size if playlist isn't shown
    int pos = widgetPlaylist->verticalScrollBar()->value();
    widgetPlaylist->scrollToItem(widgetPlaylist->item(row), QAbstractItemView::PositionAtCenter);
    widgetPlaylist->verticalScrollBar()->setValue(pos);

    if (b)
    {
        pos = row * 68 + 34 - widgetPlaylist->height() / 2;
        widgetPlaylist->property("kineticScroller").value<QAbstractKineticScroller*>()
                    ->scrollTo(QPoint(0, qBound(1, pos, widgetPlaylist->verticalScrollBar()->maximum() - 1)));
        boldRow = row;
        parent->engine->currentInfosUpdated(row);
    }
}

void
UIPlaylist::buttonClearPlaylist()
{
    clearPlaylistDialog = new QDialog(this);
    clearPlaylistDialog->setWindowTitle("NecroPlayer2");
    layoutConfirm = new QHBoxLayout;
    buttonConfirmClearPL = new QPushButton(QIcon("/opt/necroplayer2/icons/32x32/delete.png"), trClearPlaylist);
    buttonConfirmClearPL->setFixedHeight(80);
    layoutConfirm->addWidget(buttonConfirmClearPL);
    clearPlaylistDialog->setLayout(layoutConfirm);
    clearPlaylistDialog->show();

    connect(buttonConfirmClearPL, SIGNAL(clicked()), SLOT(buttonConfirmedClearPL()));
}

void
UIPlaylist::buttonConfirmedClearPL()
{
    clearPlaylistDialog->close();
    parent->engine->clearPlayList();
}

void
UIPlaylist::clearPlaylist()
{
    widgetPlaylist->scrollToTop();
    widgetPlaylist->clear();
    boldRow = -1;
}


void UIPlaylist::upItem()
{
    int row = selectedRow();

    if (row > 0)
    {
        QListWidgetItem* item = widgetPlaylist->takeItem(row-1);
        widgetPlaylist->insertItem(row, item);

        parent->engine->moveMedia(row, true);

        if (row == boldRow)
        {
            boldRow -= 1;
        }
        else if (row == boldRow + 1)
        {
            boldRow += 1;
        }

        int pos = row * 68;
        if (pos - 68 < widgetPlaylist->verticalScrollBar()->value())
        {
            widgetPlaylist->property("kineticScroller").value<QAbstractKineticScroller*>()
                        ->scrollTo(QPoint(0, qBound(1, pos - 68, widgetPlaylist->verticalScrollBar()->maximum() - 1)));
        }
        if (pos > widgetPlaylist->verticalScrollBar()->value() + widgetPlaylist->height())
        {
            widgetPlaylist->property("kineticScroller").value<QAbstractKineticScroller*>()
                        ->scrollTo(QPoint(0, qBound(1, pos - widgetPlaylist->height(), widgetPlaylist->verticalScrollBar()->maximum() - 1)));
        }
    }
}

void UIPlaylist::topItem()
{
    int row = selectedRow();

    if (row > 0)
    {
        QListWidgetItem* item = widgetPlaylist->takeItem(row);
        widgetPlaylist->insertItem(0, item);
        int pos = widgetPlaylist->verticalScrollBar()->value();
        widgetPlaylist->setCurrentRow(0);
        widgetPlaylist->verticalScrollBar()->setValue(pos);

        if (row == boldRow)
        {
            boldRow = 0;
        }
        else if (row > boldRow && boldRow > -1)
        {
            boldRow += 1;
        }

        widgetPlaylist->property("kineticScroller").value<QAbstractKineticScroller*>()
                    ->scrollTo(QPoint(0, 0));

        while (row > 0)
        {
            parent->engine->moveMedia(row,true);
            row -= 1;
        }
    }
}

void UIPlaylist::downItem()
{
    int row = selectedRow();

    if((row < widgetPlaylist->count()-1) && (row >= 0))
    {
        QListWidgetItem* item = widgetPlaylist->takeItem(row+1);
        widgetPlaylist->insertItem(row,item);

        parent->engine->moveMedia(row,false);

        if (row == boldRow)
        {
            boldRow += 1;
        }
        else  if (row == boldRow - 1)
        {
            boldRow -= 1;
        }

        int pos = row * 68 + 68;
        if (pos < widgetPlaylist->verticalScrollBar()->value())
        {
            widgetPlaylist->property("kineticScroller").value<QAbstractKineticScroller*>()
                        ->scrollTo(QPoint(0, qBound(1, pos, widgetPlaylist->verticalScrollBar()->maximum() - 1)));
        }
        if (pos + 68 > widgetPlaylist->verticalScrollBar()->value() + widgetPlaylist->height())
        {
            widgetPlaylist->property("kineticScroller").value<QAbstractKineticScroller*>()
                        ->scrollTo(QPoint(0, qBound(1, pos - widgetPlaylist->height() + 68, widgetPlaylist->verticalScrollBar()->maximum() - 1)));
        }
    }
}

void UIPlaylist::bottomItem()
{
    int row = selectedRow();

    if((row < widgetPlaylist->count()-1) && (row >= 0))
    {
        QListWidgetItem* item = widgetPlaylist->takeItem(row);
        widgetPlaylist->insertItem(widgetPlaylist->count(), item);
        int pos = widgetPlaylist->verticalScrollBar()->value();
        widgetPlaylist->setCurrentRow(widgetPlaylist->count() - 1);
        widgetPlaylist->verticalScrollBar()->setValue(pos);

        if (row == boldRow)
        {
            boldRow = widgetPlaylist->count() - 1;
        }
        else if (row < boldRow)
        {
            boldRow -= 1;
        }

        widgetPlaylist->property("kineticScroller").value<QAbstractKineticScroller*>()
                    ->scrollTo(QPoint(0, widgetPlaylist->verticalScrollBar()->maximum()));

        while (row < widgetPlaylist->count() - 1)
        {
            parent->engine->moveMedia(row, false);
            row += 1;
        }
    }
}

int UIPlaylist::selectedRow()
{
    //this hack is needed for scroll bug in maemo: current item is changed when scrolling playlist
    int selected = -1;
    QList<QListWidgetItem *> list = widgetPlaylist->selectedItems();
    if(!list.isEmpty())
    {
        QListWidgetItem * item;
        //qDebug()<<"---";

        item = list.at(0);
        selected = widgetPlaylist->row(item);
    }
    return selected;
}


