#include "SimpleViewFM.h"
#include "QDBusConnection"
#include "QDBusVariant"

SimpleViewFM::SimpleViewFM(UI *parent)
{
    this->parent = parent;

    setStyleSheet("background: black;");

    simpleFMLayout = new QGridLayout(this);

    backButton = new QPushButton();
    backButton->setFixedSize(168, 84);
    backButton->setIcon(QIcon("/opt/necroplayer2/images/simpleviewfm_back.png"));
    backButton->setIconSize(QSize(140, 70));

    backButton->setStyleSheet("QPushButton {border-radius: 2px;}"
                              "QPushButton:pressed {background-color: rgb(96, 96, 96);}");

    QFont f;
    fmTitle = new QLabel(tr("FM transmission frequency (MHz)"));
    f.setPointSize(32);
    fmTitle->setFont(f);
    fmFreqLabel = new QLabel();
    f.setPointSize(72);
    fmFreqLabel->setFont(f);

    fmFreqDown = new QPushButton();
    fmFreqDown->setIcon(QIcon(QPixmap("/opt/necroplayer2/icons/64x64/fmfreq_down.png").
                              scaled(80, 80, Qt::KeepAspectRatio, Qt::SmoothTransformation)));
    fmFreqUp = new QPushButton();
    fmFreqUp->setIcon(QIcon(QPixmap("/opt/necroplayer2/icons/64x64/fmfreq_up.png").
                              scaled(80, 80, Qt::KeepAspectRatio, Qt::SmoothTransformation)));

    fmFreqDown->setFixedSize(340, 100);
    fmFreqUp->setFixedSize(340, 100);

    fmFreqDown->setStyleSheet("QPushButton {background-color: rgb(28, 28, 28); border-radius: 10px;}"
                            "QPushButton:pressed {background-color: rgb(96, 96, 96);}");
    fmFreqUp->setStyleSheet("QPushButton {background-color: rgb(28, 28, 28); border-radius: 10px;}"
                            "QPushButton:pressed {background-color: rgb(96, 96, 96);}");

    fmFreqDown->setAutoRepeat(true);
    fmFreqDown->setAutoRepeatDelay(500);
    fmFreqDown->setAutoRepeatInterval(75);

    fmFreqUp->setAutoRepeat(true);
    fmFreqUp->setAutoRepeatDelay(500);
    fmFreqUp->setAutoRepeatInterval(75);

    connect(backButton, SIGNAL(clicked()), this, SLOT(hide()));

    connect(fmFreqDown, SIGNAL(clicked()), this, SLOT(fmFreqDownClicked()));
    connect(fmFreqUp, SIGNAL(clicked()), this, SLOT(fmFreqUpClicked()));

    simpleFMLayout->setColumnMinimumWidth(1,10);
    simpleFMLayout->setRowStretch(6, 1);

    simpleFMLayout->addWidget(backButton, 0, 0, 1, 3, Qt::AlignRight | Qt::AlignTop);
    simpleFMLayout->setRowMinimumHeight(1, 0);
    simpleFMLayout->addWidget(fmTitle, 2, 0, 1, 3, Qt::AlignHCenter | Qt::AlignTop);
    simpleFMLayout->setRowMinimumHeight(3, 10);
    simpleFMLayout->addWidget(fmFreqLabel, 4, 0, 1, 3, Qt::AlignHCenter | Qt::AlignTop);
    simpleFMLayout->setRowMinimumHeight(5, 30);
    simpleFMLayout->addWidget(fmFreqDown, 6, 0, Qt::AlignRight | Qt::AlignTop);
    simpleFMLayout->addWidget(fmFreqUp, 6, 2, Qt::AlignLeft | Qt::AlignTop);

    msgSetFMFreq = QDBusMessage::createMethodCall("com.nokia.FMTx", "/com/nokia/fmtx/default",
                                                  "org.freedesktop.DBus.Properties", "Set");
}

SimpleViewFM::~SimpleViewFM()
{

}

void
SimpleViewFM::fmFreqDownClicked()
{
    fmFreq -= 100;
    if (fmFreq == 88000) fmFreq = 107900;

    msgSetFMFreq.setArguments(QList<QVariant>() << "com.nokia.FMTx.Device" << "frequency"
                     << QVariant::fromValue(QDBusVariant(fmFreq)));

    QDBusConnection::systemBus().call(msgSetFMFreq, QDBus::NoBlock);
}

void
SimpleViewFM::fmFreqUpClicked()
{
    fmFreq += 100;
    if (fmFreq == 108000) fmFreq = 88100;

    msgSetFMFreq.setArguments(QList<QVariant>() << "com.nokia.FMTx.Device" << "frequency"
                     << QVariant::fromValue(QDBusVariant(fmFreq)));

    QDBusConnection::systemBus().call(msgSetFMFreq, QDBus::NoBlock);
}

void
SimpleViewFM::setFMFreq(quint32 f)
{
    fmFreq = f;
}
