#include "SettingsDialog.h"
#include "UI.h"



SettingsDialog::SettingsDialog(UI* parent)
{
    this->parent = parent;

    trSavePosition1 = tr("Save playing position on quit");
    trSavePosition2 = tr("Save playing position on quit (second line if needed)");
    trPauseOnUnplugged1 = tr("Pause on headphones disconnect");
    trPauseOnUnplugged2 = tr("Pause on headphones disconnect (second line if needed)");
    trResumeOnPlugged1 = tr("Resume on headphones connect");
    trResumeOnPlugged2 = tr("Resume on headphones connect (second line if needed)");
    trDir = tr("Directory");
    trNewDir = tr("New Directory");
    trDescription = tr("Description");
    trNumber = tr("No.");
    trPath = tr("Path");
    trBrowse = tr("Browse");
    trDone = tr("Done");
    trShowDescriptions1 = tr("Show descriptions in path display");
    trShowDescriptions2 = tr("Show descriptions in path display (second line if needed)");
    trHideFirstDescription1 = tr("Hide description of first directory");
    trHideFirstDescription2 = tr("Hide description of first directory (second line if needed)");

    signalMapper = new QSignalMapper(this);
    connect(signalMapper, SIGNAL(mapped(int)), this, SLOT(editFolder(int)));
    signalMapper2 = new QSignalMapper(this);
    connect(signalMapper2, SIGNAL(mapped(int)), this, SLOT(deleteDirectory(int)));

    scrArea = new QScrollArea(this);
    scrollW = new QWidget(scrArea);
    scrArea->setWidgetResizable(true);
    scrollLayout = new QVBoxLayout(scrollW);
    configLayout = new QHBoxLayout(this);

    playerBox = new QGroupBox(scrollW);
    playerBox->setFixedWidth(546);
    playerBox->setTitle(tr("Player"));
    playerBox->setObjectName("Player Box");

    playerLayout = new QVBoxLayout(playerBox);

//    defaultPlayer = new QCheckBox(scrollW);
//    defaultPlayer->setText(tr("Default media player") + "*");
//    playerLayout->addWidget(defaultPlayer);

    useSysVolOrAppVol = new QButtonGroup(this);

    labelVolume = new QLabel(scrollW);
    labelVolume->setText(tr("Volume slider") + "*:");
    playerLayout->addWidget(labelVolume);

    useSysVol = new QRadioButton(scrollW);
    useSysVol->setFixedWidth(249);
    useSysVol->setText(tr("System volume"));
    useAppVol = new QRadioButton(scrollW);
    useAppVol->setFixedWidth(249);
    useAppVol->setText(tr("Player volume"));

    useSysVolOrAppVol->addButton(useSysVol);
    useSysVolOrAppVol->addButton(useAppVol);

    volLayout = new QHBoxLayout();
    volLayout->addWidget(useSysVol);
    volLayout->addWidget(useAppVol);

    playerLayout->addLayout(volLayout);

    playlistBackground = new QButtonGroup(this);

    labelBackground = new QLabel(scrollW);
    labelBackground->setText(tr("Playlist view") + ":");

    showSeparators = new QRadioButton(scrollW);
    showSeparators->setFixedWidth(249);
    showSeparators->setText(tr("Separators"));
    showBackground = new QRadioButton(scrollW);
    showBackground->setFixedWidth(249);
    showBackground->setText(tr("Background"));

    playlistBackground->addButton(showSeparators);
    playlistBackground->addButton(showBackground);
    playerLayout->addWidget(labelBackground);
    backgroundLayout = new QHBoxLayout();
    backgroundLayout->addWidget(showSeparators);
    backgroundLayout->addWidget(showBackground);
    playerLayout->addLayout(backgroundLayout);

    useTagsOrNames = new QButtonGroup(this);

    labelPlaylist = new QLabel(scrollW);
    labelPlaylist->setText(tr("Playlist items") + ":");
    playerLayout->addWidget(labelPlaylist);

    useTags = new QRadioButton(scrollW);
    useTags->setFixedWidth(249);
    useTags->setText(tr("Metadata"));
    useFileNames = new QRadioButton(scrollW);
    useFileNames->setFixedWidth(249);
    useFileNames->setText(tr("Filenames"));

    useTagsOrNames->addButton(useTags);
    useTagsOrNames->addButton(useFileNames);

    tagsLayout = new QHBoxLayout();
    tagsLayout->addWidget(useTags);
    tagsLayout->addWidget(useFileNames);

    playerLayout->addLayout(tagsLayout);

    updateOnAddingOrPlaying = new QButtonGroup(this);

    labelMetadata = new QLabel(scrollW);
    labelMetadata->setText(tr("Retrieve metadata") + ":");

    updateOnAdding = new QRadioButton(scrollW);
    updateOnAdding->setFixedWidth(249);
    updateOnAdding->setText(tr("Playlist"));
    updateOnPlaying = new QRadioButton(scrollW);
    updateOnPlaying->setFixedWidth(249);
    updateOnPlaying->setText(tr("Played song"));

    updateOnAddingOrPlaying->addButton(updateOnAdding);
    updateOnAddingOrPlaying->addButton(updateOnPlaying);
    playerLayout->addWidget(labelMetadata);
    tagsOptLayout = new QHBoxLayout();
    tagsOptLayout->addWidget(updateOnAdding);
    tagsOptLayout->addWidget(updateOnPlaying);
    playerLayout->addLayout(tagsOptLayout);

    savePositionOnQuit = new QCheckBox(scrollW);
    savePositionOnQuit->setFixedWidth(506);
    if (trSavePosition2 == "Save playing position on quit (second line if needed)")
    {
        savePositionOnQuit->setText(trSavePosition1);
    }
    else
    {
        savePositionOnQuit->setText(trSavePosition1 + "\n" + trSavePosition2);
    }
    playerLayout->addWidget(savePositionOnQuit);

    pauseOnUnplugged = new QCheckBox(scrollW);
    pauseOnUnplugged->setFixedWidth(506);
    if (trPauseOnUnplugged2 == "Pause on headphones disconnect (second line if needed)")
    {
        pauseOnUnplugged->setText(trPauseOnUnplugged1);
    }
    else
    {
        pauseOnUnplugged->setText(trPauseOnUnplugged1 + "\n" + trPauseOnUnplugged2);
    }
    playerLayout->addWidget(pauseOnUnplugged);

    resumeOnPlugged = new QCheckBox(scrollW);
    resumeOnPlugged->setFixedWidth(506);
    if (trResumeOnPlugged2 == "Resume on headphones connect (second line if needed)")
    {
        resumeOnPlugged->setText(trResumeOnPlugged1);
    }
    else
    {
        resumeOnPlugged->setText(trResumeOnPlugged1 + "\n" + trResumeOnPlugged2);
    }
    playerLayout->addWidget(resumeOnPlugged);

    phoneButtonFn = new QMaemo5ValueButton;
    phoneButtonFn->setFixedWidth(506);
    phoneButtonFn->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    phoneButtonFn->setText(tr("Phone button function"));
    phoneButtonFnSelector = new QMaemo5ListPickSelector(this);
    model = new QStandardItemModel(0, 1, phoneButtonFnSelector);
    model->appendRow(new QStandardItem(tr("Play / Pause")));
    model->appendRow(new QStandardItem(tr("Stop playback")));
    model->appendRow(new QStandardItem(tr("Next song")));
    model->appendRow(new QStandardItem(tr("Previous song")));
    model->appendRow(new QStandardItem(tr("Do nothing")));
    phoneButtonFnSelector->setModel(model);
    phoneButtonFn->setPickSelector(phoneButtonFnSelector);
    playerLayout->addWidget(phoneButtonFn);

    playerBox->setLayout(playerLayout);

    scrollLayout->addWidget(playerBox);

    directoryBox = new QGroupBox(scrollW);
    directoryBox->setTitle(tr("Media"));
    directoryBox->setObjectName("Music Directory Box");
    directoryLayout = new QVBoxLayout(directoryBox);
    
    labelDirectory = new QLabel(scrollW);
    labelDirectory->setText(tr("Directories") + ":");

    directoryLayout->addWidget(labelDirectory);

    for (int i = 0; i <  parent->musicFoldersSize(); i++)
    {
        directories.append(new QMaemo5ValueButton());
        directories[i]->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
        directories[i]->setFixedWidth(426);
        connect(directories[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
        signalMapper->setMapping(directories[i], i);
        buttonDirsDel.append(new QToolButton());
        buttonDirsDel[i]->setFixedWidth(72);
        buttonDirsDel[i]->setIcon(QIcon::fromTheme("general_delete"));
        connect(buttonDirsDel[i], SIGNAL(clicked()), signalMapper2, SLOT(map()));
        signalMapper2->setMapping(buttonDirsDel[i], i);
        directoryLayouts.append(new QHBoxLayout());
        directoryLayouts[i]->addWidget(directories[i]);
        directoryLayouts[i]->addWidget(buttonDirsDel[i]);
        directoryLayout->addLayout(directoryLayouts[i]);
    }

    buttonDirsAddLayout = new QHBoxLayout();
    buttonDirsAddLayout->setMargin(0);
    buttonDirsAddLayout->setAlignment(Qt::AlignRight);
    buttonDirsAdd = new QToolButton();
    buttonDirsAdd->setFixedWidth(72);
    buttonDirsAdd->setIcon(QIcon::fromTheme("general_add"));
    buttonDirsAddLayout->addWidget(buttonDirsAdd);
    directoryLayout->addLayout(buttonDirsAddLayout);

    showDescriptions = new QCheckBox(scrollW);
    showDescriptions->setFixedWidth(506);
    if (trShowDescriptions2 == "Show descriptions in path display (second line if needed)")
    {
        showDescriptions->setText(trShowDescriptions1);
    }
    else
    {
        showDescriptions->setText(trShowDescriptions1 + "\n" + trShowDescriptions2);
    }
    directoryLayout->addWidget(showDescriptions);

    hideFirstDescription = new QCheckBox(scrollW);
    hideFirstDescription->setFixedWidth(506);
    if (trHideFirstDescription2 == "Hide description of first directory (second line if needed)")
    {
        hideFirstDescription->setText(trHideFirstDescription1);
    }
    else
    {
        hideFirstDescription->setText(trHideFirstDescription1 + "\n" + trHideFirstDescription2);
    }
    directoryLayout->addWidget(hideFirstDescription);

    showHiddenFiles = new QCheckBox(scrollW);
    showHiddenFiles->setFixedWidth(506);
    showHiddenFiles->setText(tr("Show hidden files"));
    directoryLayout->addWidget(showHiddenFiles);

    directoryBox->setLayout(directoryLayout);

    labelFooter = new QLabel(scrollW);
    labelFooter->setText("\n*"+tr("requires restart"));

    scrollLayout->addWidget(directoryBox);
    scrollLayout->addWidget(labelFooter);
    scrArea->setWidget(scrollW);
    setLayout(configLayout);

    dialogButton = new QDialogButtonBox(this);
    doneButton = new QPushButton(tr("Done"));
    dialogButton->addButton(doneButton, QDialogButtonBox::ActionRole);
    dialogButton->setOrientation(Qt::Vertical);

    configLayout->addWidget(scrArea);
    configLayout->addWidget(dialogButton);

    setWindowTitle("NecroPlayer2 - " + tr("Settings"));

    connect(useFileNames, SIGNAL(toggled(bool)), updateOnAdding, SLOT(setDisabled(bool)));
    connect(useFileNames, SIGNAL(toggled(bool)), updateOnPlaying, SLOT(setDisabled(bool)));
    connect(useFileNames, SIGNAL(toggled(bool)), labelMetadata, SLOT(setDisabled(bool)));

    connect(showDescriptions, SIGNAL(toggled(bool)), hideFirstDescription, SLOT(setEnabled(bool)));

    connect(buttonDirsAdd, SIGNAL(clicked()), this, SLOT(addDirectory()));

    connect(doneButton, SIGNAL(clicked()), parent, SLOT(settingsDialogAccepted()));
}

SettingsDialog::~SettingsDialog()
{  
//    if(doneButton)                delete doneButton;
//    if(dialogButton)              delete dialogButton;
//    if(showHiddenFiles)           delete showHiddenFiles;
//    if(buttonDirDel)                 delete buttonDirDel;
//    if(directory)                 delete directory;
//    if(labelDirectory)            delete labelDirectory;
//    if(directoryBox)              delete directoryBox;
//    if(savePositionOnQuit)        delete savePositionOnQuit;
//    if(updateOnPlaying)           delete updateOnPlaying;
//    if(updateOnAdding)            delete updateOnAdding;
//    if(labelMetadata)             delete labelMetadata;
//    if(updateOnAddingOrPlaying)   delete updateOnAddingOrPlaying;
//    if(useFileNames)              delete useFileNames;
//    if(useTags)                   delete useTags;
//    if(labelPlaylist)             delete labelPlaylist;
//    if(useTagsOrNames)            delete useTagsOrNames;
//    if(useSysVol)                 delete useSysVol;
//    if(useAppVol)                 delete useAppVol;
//    if(labelVolume)               delete labelVolume;
//    if(useSysVolOrAppVol)         delete useSysVolOrAppVol;
//    if(directoryLayout2)          delete directoryLayout2;
//    if(directoryLayout)           delete directoryLayout;
//    if(tagsOptLayout)             delete tagsOptLayout;
//    if(playerLayout)              delete playerLayout;
//    if(playerBox)                 delete playerBox;
//    if(configLayout)              delete configLayout;
//    if(scrollLayout)              delete scrollLayout;
//    if(scrollW)                   delete scrollW;
//    if(scrArea)                   delete scrArea;
}

void SettingsDialog::setConfig(Config* inputConfig)
{  
//    defaultPlayer->setChecked(inputConfig->defaultPlayer);

    if (inputConfig->useSysVol)
        useSysVol->setChecked(true);
    else
        useAppVol->setChecked(true);

    if (inputConfig->useTags)
        useTags->setChecked(true);
    else
        useFileNames->setChecked(true);

    if (inputConfig->updateOnPlay)
        updateOnPlaying->setChecked(true);
    else
        updateOnAdding->setChecked(true);

    savePositionOnQuit->setChecked(inputConfig->savePosition);
    pauseOnUnplugged->setChecked(inputConfig->pauseOnUnplugged);
    resumeOnPlugged->setChecked(inputConfig->resumeOnPlugged);
    phoneButtonFnSelector->setCurrentIndex(inputConfig->phoneButtonFn);

    if (inputConfig->transparentPlaylist)
        showBackground->setChecked(true);
    else
        showSeparators->setChecked(true);

    for (int i = 0; i < parent->musicFoldersSize(); i++)
    {
        directories[i]->setEnabled(true);
        directories[i]->setText(inputConfig->musicDescriptions[i]);
        directories[i]->setValueText(inputConfig->musicFolders[i]);
    }

    int j = directories.size();
    for (int i = parent->musicFoldersSize(); i < j; i++)
    {
        delete directories[i];
        delete buttonDirsDel[i];
        delete directoryLayouts[i];
        directories.takeLast();
        buttonDirsDel.takeLast();
        directoryLayouts.takeLast();
    }

    showDescriptions->setChecked(inputConfig->showDescriptions);
    hideFirstDescription->setChecked(inputConfig->hideFirstDescription);
    hideFirstDescription->setEnabled(inputConfig->showDescriptions);

    showHiddenFiles->setChecked(inputConfig->showHidden);
}

void SettingsDialog::getConfig(Config* outputConfig)
{
//    outputConfig->defaultPlayer=defaultPlayer->isChecked();
    outputConfig->useSysVol=useSysVol->isChecked();
    outputConfig->transparentPlaylist=showBackground->isChecked();
    outputConfig->useTags=useTags->isChecked();
    outputConfig->updateOnPlay=updateOnPlaying->isChecked();
    outputConfig->savePosition=savePositionOnQuit->isChecked();
    outputConfig->pauseOnUnplugged=pauseOnUnplugged->isChecked();
    outputConfig->resumeOnPlugged=resumeOnPlugged->isChecked();
    outputConfig->phoneButtonFn=phoneButtonFnSelector->currentIndex();

    outputConfig->musicFolders.clear();
    outputConfig->musicDescriptions.clear();

    for (int i = 0; i < directories.size(); i++)
    {
        if (directories.at(i)->isEnabled())
        {
            outputConfig->musicFolders.append(directories.at(i)->valueText());
            outputConfig->musicDescriptions.append(directories.at(i)->text());
        }
    }

    outputConfig->showDescriptions=showDescriptions->isChecked();
    outputConfig->hideFirstDescription=hideFirstDescription->isChecked();
    outputConfig->showHidden=showHiddenFiles->isChecked();
}

void SettingsDialog::addDirectory()
{
    directories.append(new QMaemo5ValueButton());
    directories.last()->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    directories.last()->setText(trNewDir);
    connect(directories.last(), SIGNAL(clicked()), signalMapper, SLOT(map()));
    signalMapper->setMapping(directories.last(), directories.size() - 1);
    buttonDirsDel.append(new QToolButton());
    buttonDirsDel.last()->setFixedWidth(72);
    buttonDirsDel.last()->setIcon(QIcon::fromTheme("general_delete"));
    connect(buttonDirsDel.last(), SIGNAL(clicked()), signalMapper2, SLOT(map()));
    signalMapper2->setMapping(buttonDirsDel.last(), buttonDirsDel.size() - 1);
    directoryLayouts.append(new QHBoxLayout());
    directoryLayouts.last()->addWidget(directories.last());
    directoryLayouts.last()->addWidget(buttonDirsDel.last());
    directoryLayout->insertLayout(directoryLayout->count() - 4, directoryLayouts.last());
}

void SettingsDialog::deleteDirectory(int i)
{
    directories[i]->setEnabled(!directories[i]->isEnabled());
}

void SettingsDialog::editFolder(int i)
{
    folderDialog = new QDialog(this);
    folderDialog->setWindowTitle(directories[i]->text());
    if (directories[i]->text().isEmpty())
    {
        folderDialog->setWindowTitle(trDir);
    }
    folderLayout = new QGridLayout();
    folderCustomNameLabel = new QLabel(trDescription + ":");
    folderCustomName = new QLineEdit();
    folderCustomName->setText(directories[i]->text());
    folderLayout->addWidget(folderCustomNameLabel, 0, 0, 1, 2);
    folderLayout->addWidget(folderCustomName, 1, 0);
    folderIndex = new QMaemo5ValueButton();
    folderIndex->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    folderIndex->setText("   " + trNumber);
    folderIndexSelector = new QMaemo5ListPickSelector(this);
    indexList = new QListWidget();
    for (int j = 0; j < directories.size(); j++)
    {
        indexList->addItem(QString::number(j + 1));
        indexList->item(j)->setTextAlignment(Qt::AlignCenter);
    }
    folderIndexSelector->setModel(indexList->model());
    folderIndexSelector->setView(indexList);
//    model = new QStandardItemModel(0, 1, folderIndexSelector);
//    for (int j = 0; j < directories.size(); j++)
//    {
//        model->appendRow(new QStandardItem(QString::number(j + 1)));
//    }
//    folderIndexSelector->setModel(model);
    folderIndex->setPickSelector(folderIndexSelector);
    folderIndexSelector->setCurrentIndex(i);
    folderLayout->addWidget(folderIndex, 1, 1);
    folderPathLabel = new QLabel(trPath + ":");
    folderPath = new QLineEdit();
    folderPath->setText(directories[i]->valueText());
    folderLayout->addWidget(folderPathLabel, 2, 0, 1, 2);
    folderLayout->addWidget(folderPath, 3, 0, 1, 2);

    folderDialogButtons = new QDialogButtonBox(this);
    folderDoneButton = new QPushButton(trDone);
    browseButton = new QPushButton(trBrowse);
    folderDialogButtons->addButton(folderDoneButton, QDialogButtonBox::AcceptRole);
    folderDialogButtons->addButton(browseButton, QDialogButtonBox::ActionRole);
    folderDialogButtons->setOrientation(Qt::Horizontal);
    folderLayout->addWidget(folderDialogButtons, 4, 0, 1, 2);

    connect(browseButton, SIGNAL(clicked()), this, SLOT(browsePath()));
    connect(folderDialogButtons, SIGNAL(accepted()), folderDialog, SLOT(accept()));
    connect(folderDialogButtons, SIGNAL(rejected()), folderDialog, SLOT(reject()));

    folderDialog->setLayout(folderLayout);
    folderDialog->exec();
    if (folderDialog->result() == QDialog::Accepted)
    {
        for (int k = i; k != folderIndexSelector->currentIndex();
             folderIndexSelector->currentIndex() >= i ? k++ : k--)
        {
            directories[k]->
                    setText(directories[k + copysign(1, folderIndexSelector->currentIndex() - i)]->
                            text());
            directories[k]->
                    setValueText(directories[k + copysign(1, folderIndexSelector->currentIndex() - i)]->
                                 valueText());
        }
        directories[folderIndexSelector->currentIndex()]->setText(folderCustomName->text());
        directories[folderIndexSelector->currentIndex()]->setValueText(folderPath->text());
    }
}

void SettingsDialog::browsePath()
{
    QString res = QFileDialog::getExistingDirectory(this, "Select a directory",
                                                    "/" + folderPath->text(), QFileDialog::ShowDirsOnly);
    if (!res.isNull())
    {
        folderPath->setText(res);
    }
}
