#ifndef COVERDIALOG_H
#define COVERDIALOG_H

#include <QtCore>
#include <QtGui>

class Player;

class CoverDialog : public QDialog
{
    Q_OBJECT
public:
    CoverDialog(Player* parent);

    void getCover(int row);

private:
    QHBoxLayout *layout;
    QScrollArea *labelArea;
    QWidget *labelWidget;
    QHBoxLayout *labelAreaLayout;
    QVBoxLayout *labelAndCoverLayout;
    QString artist;
    QString album;
    QLabel *label;
    QLabel *cover;
    QImage image;
    QDialogButtonBox* dialogButtons;
    QPushButton* chooseButton;
    QPushButton* deleteButton;
    QPushButton* doneButton;
    QString currCoverDir;

    bool changed;

    QString trNoArtistInfo, trNoAlbumInfo;

    Player *parent;

private slots:
    void chooseCover();
    void deleteCover();
    void setCover();
    void hideAndReset();
};

#endif // COVERDIALOG_H
