#include <iostream>
#include "Player.h"
#include "UI.h"
#include "Engine.h"
#define TRANS_DIR "/opt/maemo/usr/share/necroplayer/translations"
//#define TRANS_DIR "translations"

Player::Player(int & argc, char** argv) : QApplication(argc,argv)
{
     QTranslator qtTranslator;
     qtTranslator.load("qt_" + QLocale::system().name(),
             QLibraryInfo::location(QLibraryInfo::TranslationsPath));
     //qDebug()<<QLibraryInfo::location(QLibraryInfo::TranslationsPath);
     //qDebug()<<QLocale::system().name();
     installTranslator(&qtTranslator);

     QTranslator myappTranslator;
     myappTranslator.load("necroplayer_" + QLocale::system().name(),TRANS_DIR);
     installTranslator(&myappTranslator);
     
	setApplicationName("necroplayer");
	musicPath = "/"; // default path : root
	config = new Config();
	config->read();
	engine = new Engine(this);
	ui = new UI(this,config->musicFolder);
	restoreConf();
	restorePlaylist();
	if(argc>1)
	{
	  QStringList files;
	  for(int i=1;i<argc;i++)
	    files.append(argv[i]);
	  addMedia(files);
	}
	
	if(config->lastPlayed>=0)
	{
	  ui->setSelectedRow(config->lastPlayed);
	  //qDebug()<<"last: "<<config->lastPlayed;
	  if(config->savePosition)
	  {
	    if(config->position>0)
	      engine->restoreState(config->lastPlayed,config->position);
	  }
	}
	engine->startMetaUpdater(true);
	
	connect(this, SIGNAL(aboutToQuit()), SLOT(onQuit()));
}

Player::~Player()
{
	if (engine)
		delete engine;
	if (ui)
		delete ui;
}

void Player::addMedia(QStringList ss)
{
	engine->addMedia(ss);
}

void Player::onQuit()
{
	saveConf();
	if (config->savePlaylistOnQuit)
	  savePlaylist();
}

void Player::restorePlaylist(QString filename)
{
	QStringList files;
	if(filename=="")
	  filename=config->configDir.path() + "/necroplayer_list";
	QFile file(filename);
	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream in(&file);
		QString line = in.readLine();
		while (!line.isNull())
		{
			//ignore ext. m3u information
		        if(!line.startsWith("#"))
			{
			  files.append(line);
			}
			line = in.readLine();
		}
	}
	engine->addMedia(files);
}

void Player::openPlaylist_pls(QString filename)
{
  QStringList files;
  QFile file(filename);
  if (file.open(QIODevice::ReadOnly | QIODevice::Text))
  {
    QTextStream in(&file);
    QString line = in.readLine();
    while (!line.isNull())
    {
      if(line.startsWith("File"))
      {
	line.remove(QRegExp("^File\\d+\\="));
	files.append(line);
      }
	line = in.readLine();
    }
   }
   
  engine->addMedia(files);
    
}


void Player::savePlaylist(QString filename)
{
  
  	if(filename=="")
	  filename=config->configDir.path() + "/necroplayer_list";
	
  	QFile file(filename);
	int count=engine->getNUris();
	
	QTextStream out(&file);
	if (file.open(QIODevice::WriteOnly | QIODevice::Text))
	{
		for ( int i = 0; i < count; i++)
		{
			out << engine->getUri(i) << '\n';
		}
	}
	file.close();
  
}


void Player::restoreConf()
{
  ui->getControls().setRandom(config->random);
  engine->setVolume(config->volume);  
}

void Player::play(int row)
{
	switch (engine->getReadingState())
	{
		case Phonon::PlayingState:
			engine->play(row);
			break;
		case Phonon::PausedState:
			engine->play(row);
			break;
		default:
			//int n = row;
			if (row == -1)
			{
				row = ui->playlistCurrentRow();
				if (row == -1) { row = 0; }
			}
			if (row > -1 && row < ui->playlistCount())
			{
				ui->setSelectedRow(row);
				engine->play(row);
			}
			break;
	}

	
}

void
Player::stop()
{
	engine->stop();
}

void
Player::next()
{
	int n = engine->getCurrentPlayedMedia();
	int n_next=n;
	int nPlaylistCount=ui->playlistCount();
	if (config->random)
	{
		if ( nPlaylistCount > 1)
		{
			while (n_next == n )
			{
				n_next = qrand()%nPlaylistCount;
				//qDebug()<<qrand();
				//qDebug()<<qrand()%nPlaylistCount;
			}
		}
		else
		{ // <=1
			n_next = 0;
		}	  
	}
	else
	{
		n_next++;
		if (n_next >= nPlaylistCount)
		{
			n_next = 0;
		}
	}
	if(nPlaylistCount>0) // if not empty playlist
	{
	  play(n_next);
	  ui->setSelectedRow(n_next);
	}
	else
	{
	  engine->stop();
	}
}

void
Player::prev()
{
	if(config->random)
	{
	  next();
	}
	else
	{
	  int n = engine->getCurrentPlayedMedia();
	  int n_prev=n;
	  int nPlaylistCount=ui->playlistCount();
	  n_prev--;
	  if (n_prev < 0)
	  {
		n_prev = nPlaylistCount-1;
	  }
	  
	  if(nPlaylistCount>0) //not epty playlist
	  {
	    play(n_prev);
	    ui->setSelectedRow(n_prev);
	  }
	  else
	  {
	    engine->stop();
	  }
	}
}

void
Player::saveConf()
{
  config->volume=engine->getVolume();
  config->lastPlayed=engine->getCurrentPlayedMedia();
  if(config->savePosition) config->position=engine->getCurrentTime();
  //qDebug()<<"exiit row : "<<config->lastPlayed;
  //qDebug()<<"exit position : "<<config->position;
  config->save();

}
