# -*- coding: utf-8 -*-

"""
Module implementing MainWindow.
"""
from PyQt4  import QtCore, QtGui
from PyQt4.QtSvg import QGraphicsSvgItem 
from Ui_clock import Ui_MainWindow
from PyQt4.QtCore import pyqtSignature
    
class MainWindow(QtGui.QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
        """
        Constructor
        """
        QtGui.QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.themeDir="/home/user/MyDocs/Nclocktheme/"
        self.sysThemeDir="/home/opt/nclock/theme/"
        self.theme=["clock-drop-shadow.svg", 
                               "clock-face.svg", 
                               "clock-face-shadow.svg", 
                                "clock-marks.svg", 
                                "clock-frame.svg"
                             ]  
        self.face="clock-face.svg"
        self.hourHand="clock-hour-hand.svg"
        self.minuteHand="clock-minute-hand.svg"
        self.secondsHand="clock-second-hand.svg"
        self.glass="clock-glass.svg"
     
     #Variables that keep track of the angle of the hands, and  Time
        self.pHour=0
        self.pMinute=0
        self.pSecond=0
        self.counter=0
        self.secTimer = QtCore.QBasicTimer()
        self.minTimer=QtCore.QTimer()
        self.calibrateTimer=QtCore.QTimer()
    #The second hand counter  166=6 beats per second, 1000 =1 beat per sec
        self.secTimerType=166.9
        self.secTimerBeat=1
    #Variables that keep track of scene
        self.sceneWidth=0
        self.sceneHeight=0
        self.centerx=0
        self.centery=0
        self.xoffset=-15
        self.yoffset=-5
        self.ixoffset=self.xoffset*-1
        self.iyoffset=self.yoffset*-1
        self.svgRect=QtCore.QRect()
        self.setWindowTitle('Nclock')

        #Check to see if files in /home/user/MyDocs/Nclocktheme exists
        try:
            f=open ("/home/user/MyDocs/Nclocktheme/clock-face.svg")
        except :
                print"error"
                reply = QtGui.QMessageBox.question(self, 'Message',"No Theme files in directory /home/user/MyDocs/Nclocktheme.     load default theme? No to Exit", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
                if reply==QtGui.QMessageBox.Yes :self.themeDir=self.sysThemeDir
                else :    exit()

        #Initialize the Graphics Scene, Graphicsview is setup in QtDesigner UI
        self.scene = QtGui.QGraphicsScene()
        for path in self.theme:
            self.svgItem=QGraphicsSvgItem(self.themeDir+path)
            renderer=self.svgItem.renderer()
            self.scene.addItem(self.svgItem)
                
    #get the bounding box for the scene now filled with the clock theme
        self.rect=self.scene.itemsBoundingRect()
        self.sceneWidth=self.rect.width()
        self.sceneHeight=self.rect.height()
        self.centerx=self.sceneWidth/2
        self.centery=self.sceneHeight/2
        self.grView.centerOn(self.centerx, self.centery)
        self.scene.setSceneRect(0, 0,self.sceneWidth, self.sceneHeight)
 
    #===Load the Hour hand and scale the viewport to its size===========
        self.svgHour=QGraphicsSvgItem(self.themeDir+self.hourHand)
        self.renderer=self.svgHour.renderer()
        #get the bounding rectangle of hour hand
        self.rect=self.svgHour.boundingRect()
        self.svgRect.setX(self.xoffset)
        self.svgRect.setY(self.yoffset)
        self.svgRect.setWidth(self.rect.width())
        self.svgRect.setHeight(self.rect.height())
        #setup the Viewbox
        self.renderer.setViewBox(self.svgRect)
        self.svgHour.setPos(self.centerx+self.xoffset, self.centery+self.yoffset)
        self.scene.addItem(self.svgHour)
        
        #===Load the Minute hand and scale the viewport to its size===========
        self.svgMinute=QGraphicsSvgItem(self.themeDir+self.minuteHand)
        self.renderer=self.svgMinute.renderer()
        #get the bounding rectangle of minute hand
        self.rect=self.svgMinute.boundingRect()
        self.svgRect.setX(self.xoffset)
        self.svgRect.setY(self.yoffset)
        self.svgRect.setWidth(self.rect.width())
        self.svgRect.setHeight(self.rect.height())
        #setup the Viewbox
        self.renderer.setViewBox(self.svgRect)
        self.svgMinute.setPos(self.centerx+self.xoffset, self.centery+self.yoffset)
        self.scene.addItem(self.svgMinute)
        print "minute hand z ", self.svgMinute.zValue()
        
        #===Load the Seconds Hand and scale the viewport to its size===========
        self.svgSecond=QGraphicsSvgItem(self.themeDir+self.secondsHand)
        self.renderer=self.svgSecond.renderer()
        #get the bounding rectangle of seconds hand
        self.rect=self.svgSecond.boundingRect()
        #setup viewport for the seconds hand, offsetx,y then wdith and height
        self.svgRect.setX(self.xoffset)
        self.svgRect.setY(self.yoffset)
        self.svgRect.setWidth(self.rect.width())
        self.svgRect.setHeight(self.rect.height())
        #setup the Viewbox
        self.renderer.setViewBox(self.svgRect)
        self.svgSecond.setPos(self.centerx+self.xoffset, self.centery+self.yoffset)
        self.scene.addItem(self.svgSecond)
        self.svgSecond.setZValue(1)
         #Add the Glass as the top layer
        self.fileExist=1
        try:
                f=open (self.themeDir+"clock-glass.svg")
        except :
                self.fileExist=0
        if self.fileExist==1:
                self.svgItem=QGraphicsSvgItem(self.themeDir+self.glass)
                renderer=self.svgItem.renderer()
                self.scene.addItem(self.svgItem)
                self.svgItem.setZValue(2)
                
         #setup the  hands against the current time  
        self.showTime()
        self.calibrateTime()
       
        #Paint the Scene and center
        self.rect=self.scene.itemsBoundingRect()
        height=self.rect.height()
        width=self.rect.width()
        if width>height: dimension=width
        else :dimension =height
        #self.scene.setSceneRect(0, 0, dimension, dimension)
         #Display the whole Clock   
        #self.grView.centerOn(-150, -150)
        self.grView.setScene(self.scene)
        
        #set up the Qt Seconds Timers using lightweight QBasic timer
        self.secTimer.start(self.secTimerType, self)
        #set up the Qt Minute Timer every 10 seconds
        self.connect(self.minTimer, QtCore.SIGNAL("timeout()"), self.showTime)
        self.minTimer.start(10000)
        #set up the recalibrate timer every 10Secs
        self.connect(self.calibrateTimer, QtCore.SIGNAL("timeout()"), self.calibrateTime)
        self.calibrateTimer.start(6000)
        
    def timerEvent(self, event):
        """
        animates the seconds hand 
        """
        self.pSecond=self.pSecond+self.secTimerBeat
        self.pSecond=self.pSecond %360
        self.svgSecond.setTransform(QtGui.QTransform().translate(self.ixoffset, self.iyoffset).rotate(self.pSecond).translate(self.xoffset, self.yoffset))
        
    def showTime(self):
        """
        Update the Hour and Minute Hands
        """
        #Get the Time and work out what angle the hands should be at
        self.time = QtCore.QTime.currentTime()
        hour=30.0 * ((self.time.hour() + self.time.minute() / 60.0))-90
        minute=6.0 * (self.time.minute() + self.time.second() / 60.0)-90
        #Rotate the hands into place
        self.svgHour.setTransform(QtGui.QTransform().translate(self.ixoffset, self.iyoffset).rotate(hour).translate(self.xoffset, self.yoffset))
        self.svgMinute.setTransform(QtGui.QTransform().translate(self.ixoffset, self.iyoffset).rotate(minute).translate(self.xoffset, self.yoffset))

    def calibrateTime(self):
        #due to inaccuracies of the seconds timer we recalibrate the second hand every 10 secs
        self.secTimer.stop()
        self.calibrateTimer.stop()
        self.time = QtCore.QTime.currentTime()
        self.pSecond=(self.time.second()*6)-90
        self.svgSecond.setTransform(QtGui.QTransform().translate(self.ixoffset, self.iyoffset).rotate(self.pSecond).translate(self.xoffset, self.yoffset))
        self.secTimer.start(self.secTimerType, self)
        self.calibrateTimer.start(6000)
        
        
    @pyqtSignature("")
    # sets the second hands tick to Quartz style
    def on_actionQuartz_triggered(self):
        self.secTimerType=1000
        self.secTimerBeat=6
        self.calibrateTime()
        
    @pyqtSignature("")
    #Sets the seconds hand to Automatic smooth style
    def on_actionAutomatic_triggered(self):
        self.secTimerType=166.9
        self.secTimerBeat=1
        self.calibrateTime()
        
    @pyqtSignature("")
    #Sets the seconds hand standstill
    def on_actionEco_triggered(self):
        self.secTimer.stop()
        self.calibrateTimer.stop()
        self.svgSecond.resetTransform()
        self.svgSecond.setTransform(QtGui.QTransform().translate(self.ixoffset, self.iyoffset).rotate(-90).translate(self.xoffset, self.yoffset))
        
    @pyqtSignature("")
    #Sets the seconds hand to Automatic smooth style
    def on_ZoomIn_pressed(self):
      
        self.grView.centerOn(-300, -300)
        self.grView.scale(1.1, 1.1)
    
    @pyqtSignature("")
    #Sets the seconds hand to Automatic smooth style
    def on_ZoomOut_pressed(self):
        self.grView.scale(0.9, 0.9)

def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
    
class CustomsvgSecond(QGraphicsSvgItem):
        def __init__(self,parent=None,scene=None):
            QGraphicsSvgItem.__init__(self)

        
              
def loadscend(self):

        for path in self.theme:
            self.fileExist=1
            try:
                f=open (self.themeDir+path)
            except :
                    self.fileExist=0
            if self.fileExist==1:
                self.svgItem=QGraphicsSvgItem(self.themeDir+path)
                renderer=self.svgItem.renderer()
                self.scene.addItem(self.svgItem)




