# -*- coding: utf-8 -*-

# Copyright (c) 2012 Hugo Osvaldo Barrera <hugo@osvaldobarrera.com.ar>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

from PySide.QtGui import QInputDialog, QApplication, QDialog, QDesktopServices, QLabel, QLineEdit, QWidget, QGridLayout, QPushButton, QMainWindow
from PySide.QtCore import QUrl, Signal, SIGNAL, Qt
from PySide.QtMaemo5 import QMaemo5InformationBox
# cgi.parse_qsl is depratated in python, but since maemo uses 2.5, I've no choice
# Newer python implementations should use urlparse.parse_qsl()
import cgi # import urlparse
import httplib
import urllib
import oauth2 as oauth
import time
import os
import sys
from xdg import BaseDirectory
from ConfigParser import SafeConfigParser

REQUEST_TOKEN_URL = "https://api.twitter.com/oauth/request_token"
ACCESS_TOKEN_URL  = "https://api.twitter.com/oauth/access_token"
AUTHORIZE_URL     = "https://api.twitter.com/oauth/authorize"

API_SERVER        = "api.twitter.com"
API_PROTOCOL      = "http"
STATUS_UPDATE_URL = API_PROTOCOL + "://" + API_SERVER + "/1/statuses/update.json"

CONSUMER_KEY      = "UgH47ytIXzZqqnoYIXVOzA"
CONSUMER_SECRET   = "LAN8wuThZXfuPOiejwTe3tDi3OrBepJdciJlK4AI"

TOKEN             = ""
TOKEN_SECRET      = ""

consumer = oauth.Consumer(CONSUMER_KEY, CONSUMER_SECRET)

CONFIG_DIR = os.path.join(BaseDirectory.xdg_config_home, "nanotwit/")
if not os.path.exists(CONFIG_DIR):
    os.makedirs(CONFIG_DIR)

CONFIG_FILE = os.path.join(CONFIG_DIR, "token")


class PinDialog(QMainWindow):

    authorized = Signal()

    def __init__(self, parent = None):
        super(PinDialog, self).__init__(parent)
        self.setWindowTitle("What is the PIN?")
        
        self.cw = QWidget(self)
        self.setCentralWidget(self.cw)

        layout = QGridLayout(self.cw)
        layout.setContentsMargins(22, 22, 22, 22)

        textStr = "I'm going to open a browser window so you can authorize me on twitter."
        textStr += "  Please authorize me, and type in the PIN provided below."
        textStr += "<p>I know this dialog is really ugly, but don't worry, you won't see it again :)"
        self.text = QLabel(textStr)
        self.text.setAlignment(Qt.AlignCenter)
        self.text.setWordWrap(True)

        self.pin = QLineEdit(self)
        self.pin.setPlaceholderText("PIN number")

        self.error = QLabel("")

        button = QPushButton("Authorize")
        self.connect(button, SIGNAL("clicked()"), self.finish_authorization)

        layout.addWidget(self.text, 0, 0, 1, 2)
        layout.addWidget(self.pin, 1, 0)
        layout.addWidget(button, 1, 1)
        layout.addWidget(self.error, 2, 0)
        layout.setRowStretch(3, 3)

    def do_auth(self):
        client = oauth.Client(consumer)
        resp, content = client.request(REQUEST_TOKEN_URL, "GET")

        # TODO
        if resp['status'] != '200':
            raise Exception("Invalid response %s." % resp['status'])

        self.request_token = dict(cgi.parse_qsl(content))
        url = "%s?oauth_token=%s" % (AUTHORIZE_URL, self.request_token['oauth_token'])
        QDesktopServices.openUrl(QUrl(url, QUrl.StrictMode))
        
        self.show()

    def finish_authorization(self):

        print "validating pin"

        oauth_verifier = self.pin.text()

        token = oauth.Token(self.request_token['oauth_token'], self.request_token['oauth_token_secret'])
        token.set_verifier(oauth_verifier)
        client = oauth.Client(consumer, token)

        resp, content = client.request(ACCESS_TOKEN_URL, "POST")
        if resp['status'] != '200':
            print "invalid pin : "
            print oauth_verifier
            self.error.setText("Error, bad PIN.  Please try again.")
        else:
            print "valid pin"
            self.access_token = dict(cgi.parse_qsl(content))

            config.add_section("token")
            config.set("token", "key", self.access_token['oauth_token'])
            config.set("token", "secret", self.access_token['oauth_token_secret'])
            f = open(CONFIG_FILE,"w")
            config.write(f)
            f.close()

            self.authorized.emit()
            self.close()

    def access_token(self):
        return self.access_token


def do_post(status):
    TOKEN        = config.get("token", "key")
    TOKEN_SECRET = config.get("token", "secret")

    params = {
        'oauth_version': "1.0",
        'oauth_nonce': oauth.generate_nonce(),
        'oauth_timestamp': int(time.time()),
        'status': status # TODO: do I need this param here?
    }

    statusdict = { 'status': status.encode('utf-8') }

    token = oauth.Token(key=TOKEN, secret=TOKEN_SECRET)

    params['oauth_token'] = token.key
    params['oauth_consumer_key'] = consumer.key

    req = oauth.Request.from_consumer_and_token(consumer, token, "POST", STATUS_UPDATE_URL, statusdict)
    signature_method = oauth.SignatureMethod_HMAC_SHA1() 
    req.sign_request(signature_method, consumer, token)
    headers = req.to_header()
    params = urllib.urlencode(statusdict)

    conn = httplib.HTTPConnection(API_SERVER)
    conn.request("POST", STATUS_UPDATE_URL, params, headers)

    response = conn.getresponse()
    if response.status != 200:
        QMaemo5InformationBox().information(None, "Twitter return an error updating the status", 3000)
    else:
        QMaemo5InformationBox().information(None, "Tweet successful", 2000)

    # TODO, proper error showing, under certain conditions, clear the config file
    # also, why not retry at least once?


class NewStatusDialog(QInputDialog):

    default_text = "Type a status message "

    def __init__(self):
        super(NewStatusDialog, self).__init__()
        self.setWindowTitle("NanoTwit")
        self.setLabelText(self.default_text)
        self.setOkButtonText("Tweet!")
        self.setInputMode(QInputDialog.TextInput)
        self.textValueChanged.connect(self.text_changed)

    def text_changed(self, text):
        self.setLabelText(self.default_text + "(" + str(140 - len(text)) + " characters remining)")



def main():  
    dialog = NewStatusDialog()
    if dialog.exec_() == QDialog.Accepted:
        do_post(dialog.textValue())

app = QApplication(sys.argv)

config = SafeConfigParser()
config.read(CONFIG_FILE)

if not config.has_section("token"):
    dialog = PinDialog()
    dialog.authorized.connect(main)
    dialog.do_auth()
    sys.exit(app.exec_())
else:
    main()