// -*- qml-mode -*-
import QtQuick 1.0
import Translations 1.0

TranslationsPage {
        id: translationEditPage

        property int tid: 0

        tools: toolBar

        TitleLabel {
                id: title
                width: parent.width
                anchors.top: parent.top
                text: _translations.translationName(parent.tid);
                horizontalAlignment: Text.AlignHCenter // TODO: proper alignment
        }

        DialogButton {
                text: qsTr("Delete translation");
                width: 400
                anchors.top: title.bottom
                anchors.topMargin: 30
                anchors.horizontalCenter: parent.horizontalCenter
                onClicked: askForRemoval(tid);
        }

        ToolBar {
                id: toolBar
                ToolBarLayout {
                        ToolButton { icon: theme.pageBack; onClicked: pageStack.pop(); }
		        }
		}
}
