/* FMRX Enabler for N900 hardware
 * Copyright (C) 2009 Martin Grimme  <martin.grimme@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <dbus/dbus-glib-bindings.h>
#include <glib.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <bluetooth/hci_lib.h>


/* path of the kernel module */
#define RADIO_BCM2048_MODULE "/lib/modules/current/radio-bcm2048.ko"

/* path of device file */
#define FMRADIO_DEVICE "/dev/radio1"

/* timeout intervals in seconds between watchdog iterations */
#define WATCHDOG_TIMEOUT            60

/* if there were no requests for this many seconds, power down the hardware */
#define UNLOAD_TIMEOUT              120

/* return codes of the request D-Bus method */
#define RESULT_OK                   0
#define RESULT_BLUETOOTH_FAILURE    1
#define RESULT_I2C_FAILURE          2
#define RESULT_DRIVER_FAILURE       3
#define RESULT_TUNER_FAILURE        4

/* HCI commands for enabling / disabling the I2C bus on the BCM2048 chip.
 * Thanks to Nokia for providing these.
 */
unsigned char I2C_DISABLE[] = { 0x08, 0x15, 0xFC, 0x03, 0x29, 0x00, 0x7F };
unsigned char I2C_ENABLE[]  = { 0x08, 0x15, 0xFC, 0x03, 0x29, 0x00, 0xa2 };


/*
 * GObject and D-Bus boilerplate stuff that we all hate
 */
#define FMRX_SERVICE_NAME "de.pycage.FMRXEnabler"
#define FMRX_OBJECT_PATH  "/de/pycage/FMRXEnabler"
#define FMRX_INTERFACE    "de.pycage.FMRXEnabler"

#define FMRX_ENABLER_TYPE              (fmrx_enabler_get_type ())
#define FMRX_ENABLER(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), \
                                        FMRX_ENABLER_TYPE, \
                                        FMRXEnabler))
#define FMRX_ENABLER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                        FMRX_ENABLER_TYPE, \
                                        FMRXEnabler))
#define IS_FMRX_ENABLER(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), \
                                        FMRX_ENABLER_TYPE))
#define IS_FMRX_ENABLER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                        FMRX_ENABLER_TYPE))
#define FMRX_ENABLER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                        FMRX_ENABLER_TYPE, \
                                        FMRXEnablerClass))

typedef struct FMRXEnabler FMRXEnabler;
typedef struct FMRXEnablerClass FMRXEnablerClass;

GType fmrx_enabler_get_type (void);

struct FMRXEnabler {

    GObject     parent;
    /* Bluetooth socket for HCI sending commands */
    int         hci_socket;
    /* whether the BCM2048 FMRX driver is currently loaded */
    gboolean    driver_loaded;
    /* whether Bluetooth was already enabled at the time of enabling
       -> if yes, don't power off Bluetooth after disabling the I2C and FM */
    gboolean    had_bluetooth;
    /* timestamp of last request */
    time_t      last_request;

};

struct FMRXEnablerClass {

    GObjectClass parent;

};


gboolean dbus_fmrx_enabler_request(FMRXEnabler *self,
                                   int *result,
                                   char **device,
                                   GError **error);

