# -*- coding: utf-8 -*-

__author__= "Michael Wong"
__email__="imichaelwong@gmail.com"
__version__= "0.3.0"
__build__="101026"

import platform
import sys
import string
import Utils
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *
from PyQt4.QtMaemo5 import *
from flickcharm import *

class HtmlCellDelegate(QStyledItemDelegate):
    def __init__(self, orientation=1, widthAdjust=0, heightAdjust=0, parent=None):
        super(HtmlCellDelegate,self).__init__(parent)
        self.orientation=orientation
        self.widthAdjust=widthAdjust
        self.heightAdjust=heightAdjust

    def sizeHint(self,option,index):
#        width=option.rect.size().width()
        width=470
        height=70
#        if self.orientation==1:
#            width=470
#            height=70
        width+=self.widthAdjust
        height+=self.heightAdjust
#        screenGeometry = QApplication.desktop().screenGeometry();
#        if (screenGeometry.width() < screenGeometry.height()) or self.orientation==1:
#             width=option.rect.size().width()
#             height=option.rect.size().height()*2
#            width=470
#        else:
#            width=790
        return QSize(width,height)

    def paint(self, painter, option, index):
        painter.save()
        value = index.data(Qt.DisplayRole).toString()
        doc=QTextDocument()
        doc.setHtml(value)
#        context=QAbstractTextDocumentLayout.PaintContext() ;
        doc.setPageSize(QSizeF(option.rect.size()));
#        print doc.pageSize().width()
#        print doc.textWidth()
        painter.translate(option.rect.x(), option.rect.y());
#        print option.rect.x(),option.rect.y()
#        doc.documentLayout().draw(painter, context);
        painter.setPen(QColor(211,211,211))
        doc.drawContents(painter)
        painter.restore()
        painter.setPen(QColor(128,128,128))
        painter.drawLine(option.rect.bottomLeft(), option.rect.bottomRight())
#        painter.restore()
        if (option.state & QStyle.State_Selected):
            pal=option.palette;
            brush = pal.highlight();
            col = brush.color(); 
            col.setAlpha(127);
            brush.setColor(col);
            painter.fillRect(option.rect, brush);
#        painter->fillRect(option.rect, option.palette.highlight());

       
class BooksModel(QAbstractListModel):
    def __init__(self, books=None, parent=None):
        super(BooksModel, self).__init__(parent)
        self.books=books

    def rowCount(self,parent=None):
        return len(self.books)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.books)):
            return None
        if (role == Qt.DisplayRole):
            book=self.books[index.row()]
            html=self.makeBookHtml(book)
            return html
        else:
            return self.books[index.row()]


    def makeBookHtml(self,book):
        source="""
            <tr style="font-size:22px;color:$COLOR">
                <td>%s</td>
                <td align=\"right\">%s</td>
            </tr>
            <tr style="font-size:18px;color:#808080">
                <td>%s</td>
                <td align=\"right\">%s</td>
            </tr>
        </table>
            """
        bn=unicode(book["name"])
        num=str(book["unreadChapterNum"])+" / "+str(book["downloadedChapterNum"])+" / "+str(book["chapterNum"])
        aw=unicode(book["author"]+" / "+book["websiteName"])
        date=str(book["updateDate"]).split(".")[0]
        if book["stopUpdate"]:
            date="S / "+date
        if book["autoDownload"]:
            date="A / "+date
        html="<table width=\"100%\" border=\"0\" style=\"border-bottom:1px solid #0000ff;\">"+source % (bn, num, aw, date)

        color="#FFFFFF"
        if book["unreadChapterNum"]>0:
            color="#FF9900"
        html=string.replace(html, "$COLOR", color)
        return html


class ChaptersModel(QAbstractListModel):
    def __init__(self, chapters=None, parent=None):
        super(ChaptersModel, self).__init__(parent)
        self.chapters=chapters

    def rowCount(self,parent=None):
        return len(self.chapters)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return QVariant()
        if (index.row() >= len(self.chapters)):
            return QVariant()
        if (role == Qt.DisplayRole):
            chapter=self.chapters[index.row()]
            html=self.makeChapterHtml(chapter)
            return html
        else:
            return self.chapters[index.row()]

    def makeChapterHtml(self,chapter):
        source="""
            <tr style="font-size:22px;color:$COLOR">
                <td>%s</td>
            </tr>
            <tr style="font-size:18px;color:#808080">
                <td align=\"right\">%s</td>
            </tr>
        </table>
            """
        ct=unicode(chapter["title"])

        date=str(chapter["downloadDate"]).split(".")[0]
        de="Downloadable"
        dd="Downloaded"
        if not chapter["downloadable"]:
            de="<s>Downloadable</s>"
        if not chapter["downloaded"]:
            dd="<s>Downloaded</s>"
        date=dd+" / "+de+" / "+date
        html="<table width=\"100%\" border=\"0\">"+source % (ct, date)
        color="#FFFFFF"
        if chapter["readed"]==0:
            color="#FF9900"
        html=string.replace(html, "$COLOR", color)
        return html

class ChaptersWindow(QMainWindow):
    def __init__(self, parent=None, orientation=0, chapters=None):
        super(ChaptersWindow, self).__init__(parent)
        self.orientation=orientation
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.chaptersListView=QListView()
        if chapters!=None:
            self.chaptersModel=ChaptersModel(chapters)
            self.chaptersListView.setModel(self.chaptersModel)
        self.chaptersListView.setItemDelegate(HtmlCellDelegate(self.orientation))
        self.setCentralWidget(self.chaptersListView)

    def current_index(self):
        return self.chaptersListView.currentIndex()

    def set_current_index(self,index):
        self.chaptersListView.setCurrentIndex(index)

    def load_chapters(self,chapters):
        self.chaptersModel=ChaptersModel(chapters)
        self.chaptersListView.setModel(self.chaptersModel)

    def scroll_to(self,chapterId):
        cindex=None
        if chapterId>=0:
            for row in range(self.chaptersModel.rowCount()):
                cindex=self.chaptersModel.index(row,0)
                c=self.chaptersModel.data(cindex, Qt.EditRole)
                if c["id"]==chapterId:
                    break
        if not cindex==None:
            self.chaptersListView.scrollTo(cindex)

    def scroll_to_new(self):
        cindex=None
        for row in range(self.chaptersModel.rowCount()):
            cindex=self.chaptersModel.index(row,0)
            c=self.chaptersModel.data(cindex, Qt.EditRole)
            if c["readed"]==0:
                break
        if not cindex==None:
            self.chaptersListView.scrollTo(cindex)

class ChaptersManaWindow(QMainWindow):
    def __init__(self, parent=None, chapters=None,orientation=0):
        super(ChaptersManaWindow, self).__init__(parent)
        self.orientation=orientation
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.chaptersListView=QListView()
        self.chaptersListView.setSelectionMode(QAbstractItemView.MultiSelection)
        if chapters!=None:
            self.chapters=chapters
            self.chaptersBackup=chapters
            self.chaptersModel=ChaptersModel(chapters)
            self.chaptersListView.setModel(self.chaptersModel)
        self.chaptersListView.setItemDelegate(HtmlCellDelegate(self.orientation))

        selectOpNames=[unicode("无"),unicode("全选"),unicode("全不选"),unicode("反选")]
        markOpNames=[unicode("无"),unicode("已读"),unicode("未读"),
            unicode("已下载"),unicode("未下载"),unicode("需下载"),unicode("不需下载")]
#        self.values=[QVariant(30),QVariant(60),QVariant(120),QVariant(180)]
        self.selectOpModel=QStringListModel(selectOpNames)
        self.markOpModel=QStringListModel(markOpNames)
        self.selectOpBtn = QMaemo5ValueButton(unicode(" 选择"))
        self.markOpBtn = QMaemo5ValueButton(unicode(" 标记为"))
        self.selectOpBtn.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.markOpBtn.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.selectOpselector =QMaemo5ListPickSelector()
        self.selectOpselector.setModel(self.selectOpModel)
        self.selectOpselector.setCurrentIndex(0)
        self.selectOpBtn.setPickSelector(self.selectOpselector)
        self.markOpselector =QMaemo5ListPickSelector()
        self.markOpselector.setModel(self.markOpModel)
        self.markOpselector.setCurrentIndex(0)
        self.markOpBtn.setPickSelector(self.markOpselector)
        

        self.mainFrame=QFrame()
        self.outerLayout = QVBoxLayout(self.mainFrame)
        self.outerLayout.setObjectName("outerLayout")
        self.buttonFrame=QFrame()
        self.confirmButton = QPushButton(unicode("保存"))
        self.cancelButton = QPushButton(unicode("重置"))

        self.markOpBtn.setMaximumHeight(55)
        self.selectOpBtn.setMaximumHeight(55)
        self.confirmButton.setMaximumWidth(100)
        self.confirmButton.setMaximumHeight(55)
        self.cancelButton.setMaximumWidth(100)
        self.cancelButton.setMaximumHeight(55)

        self.buttonFormLayout=QGridLayout()
        if self.orientation==1:
            self.markOpBtn.setFixedWidth(310)
            self.selectOpBtn.setFixedWidth(310)
#            self.buttonFormLayout.setAlignment(Qt.AlignTop)
            self.buttonFormLayout.addWidget(self.selectOpBtn,0,0)
            self.buttonFormLayout.addWidget(self.confirmButton,0,1)
            self.buttonFormLayout.addWidget(self.markOpBtn,1,0)
            self.buttonFormLayout.addWidget(self.cancelButton,1,1)
            
        else:
            self.markOpBtn.setFixedWidth(200)
            self.selectOpBtn.setFixedWidth(200)
            self.buttonFormLayout.addWidget(self.selectOpBtn,0,0)
            self.buttonFormLayout.addWidget(self.markOpBtn,0,1)
            self.buttonFormLayout.addWidget(self.confirmButton,0,2)
            self.buttonFormLayout.addWidget(self.cancelButton,0,3)


        self.buttonFrame.setLayout(self.buttonFormLayout)
        self.outerLayout.addWidget(self.chaptersListView)
        self.outerLayout.addWidget(self.buttonFrame)
        self.connect(self.selectOpselector,
                     SIGNAL("selected(const QString&)"),
                     self.do_select)
        self.connect(self.markOpselector,
                     SIGNAL("selected(const QString&)"),
                     self.do_mark)
        self.setCentralWidget(self.mainFrame)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        self.buttonFormLayout.removeWidget(self.selectOpBtn)
        self.buttonFormLayout.removeWidget(self.markOpBtn)
        self.buttonFormLayout.removeWidget(self.confirmButton)
        self.buttonFormLayout.removeWidget(self.cancelButton)
        if self.orientation==1:
            self.markOpBtn.setFixedWidth(310)
            self.selectOpBtn.setFixedWidth(310)
#            self.buttonFormLayout.setAlignment(Qt.AlignTop)
            self.buttonFormLayout.addWidget(self.selectOpBtn,0,0)
            self.buttonFormLayout.addWidget(self.confirmButton,0,1)
            self.buttonFormLayout.addWidget(self.markOpBtn,1,0)
            self.buttonFormLayout.addWidget(self.cancelButton,1,1)

        else:
            self.markOpBtn.setFixedWidth(200)
            self.selectOpBtn.setFixedWidth(200)
            self.buttonFormLayout.addWidget(self.selectOpBtn,0,0)
            self.buttonFormLayout.addWidget(self.markOpBtn,0,1)
            self.buttonFormLayout.addWidget(self.confirmButton,0,2)
            self.buttonFormLayout.addWidget(self.cancelButton,0,3)

    def do_select(self):
        selectOp=self.selectOpselector.currentIndex()
        selectionModel=self.chaptersListView.selectionModel()
        if selectOp==0:
            return
        elif selectOp==1:
            selectMode=QItemSelectionModel.Select
        elif selectOp==2:
            selectMode=QItemSelectionModel.Deselect
        elif selectOp==3:
            selectMode=QItemSelectionModel.Toggle
        allSelection=QItemSelection(
            self.chaptersModel.index(0,0),
            self.chaptersModel.index(self.chaptersModel.rowCount()-1,0))
        selectionModel.select(allSelection,selectMode)

    def do_mark(self):
        markOp=self.markOpselector.currentIndex()
        selectionModel=self.chaptersListView.selectionModel()
        if markOp==0:
            return
        selected=selectionModel.selectedIndexes()
        if len(selected)==0:
            return
        if markOp==1:
            p="readed"
            v=1
        elif markOp==2:
            p="readed"
            v=0
        elif markOp==3:
            p="downloaded"
            v=1
        elif markOp==4:
            p="downloaded"
            v=0
        elif markOp==5:
            p="downloadable"
            v=1
        elif markOp==6:
            p="downloadable"
            v=0
        for index in selected:
            row=index.row()
            chapter=self.chapters[row]
            chapter[p]=v

    def reset(self,chapters=None):
        if chapters!=None:
            self.chapters=chapters
            self.load_chapters(chapters)
        self.selectOpselector.setCurrentIndex(0)
        self.markOpselector.setCurrentIndex(0)
        #deselect all
        selectionModel=self.chaptersListView.selectionModel()
        allSelection=QItemSelection(
            self.chaptersModel.index(0,0),
            self.chaptersModel.index(self.chaptersModel.rowCount()-1,0))
        selectionModel.select(allSelection,QItemSelectionModel.Deselect)

    def load_chapters(self,chapters):
        self.chaptersModel=ChaptersModel(chapters)
        self.chaptersListView.setModel(self.chaptersModel)

    def output_chapters(self):
        return self.chapters


class ContentWindow(QMainWindow):
    def __init__(self, parent=None, orientation=0):
        super(ContentWindow, self).__init__(parent)
        self.orientation=orientation
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.chapterContentView = ChaptersContentView(self,self.orientation)
        self.setCentralWidget(self.chapterContentView)
        self.fontColor=Utils.FONT_COLOR_BLACK
        self.bgColor=Utils.BG_COLOR_BLUE
        #zoom size from 0.6 to 2.0
        self.zoomSize=1

    def switch_to_day_mode(self):
        self.fontColor=Utils.FONT_COLOR_BLACK
        self.bgColor=Utils.BG_COLOR_BLUE

    def switch_to_night_mode(self):
        self.fontColor=Utils.FONT_COLOR_WHITE
        self.bgColor=Utils.BG_COLOR_BLACK

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        if self.orientation==0:
            self.chapterContentView.setFixedSize(800,425)
#            self.chapterContentView.setFixedWidth(800)
        elif self.orientation==1:
            self.chapterContentView.setFixedSize(480,745)
#            self.chapterContentView.setFixedWidth(480)

    def zoom_in(self):
        if self.zoomSize<1.9:
            self.zoomSize+=0.2
            self.chapterContentView.zoom(self.zoomSize)

    def zoom_out(self):
        if self.zoomSize>0.7:
            self.zoomSize-=0.2
            self.chapterContentView.zoom(self.zoomSize)

    def load_content(self,filename):
        self.chapterContentView.update_content(filename)

    def load_content_html(self,contentHtml=None, baseUrl=None):
        ch=contentHtml
        ch=string.replace(ch, Utils.FONT_COLOR_PLACE_HOLDER, self.fontColor)
        ch=string.replace(ch, Utils.BG_COLOR_PLACE_HOLDER, self.bgColor)
        self.chapterContentView.update_content_html(ch,baseUrl)

class ChaptersContentView(QWebView):
    def __init__(self, parent=None,orientation=0):
        super(ChaptersContentView, self).__init__(parent)
        self.orientation=orientation
        #set the size for the rendering problem when change the content
        if self.orientation==0:
            self.setFixedSize(800,425)
#            self.setFixedWidth(800)
        elif self.orientation==1:
            self.setFixedSize(480,745)
#            self.setFixedWidth(480)
#        print self.sizeHint()
#        self.settings().setAttribute(QWebSettings.PluginsEnabled,True)
#        self.grabGesture(Qt.SwipeGesture)
#        self.setRenderHint(QPainter.HighQualityAntialiasing)
#        scroller=self.property("kineticScroller").toPyObject()
#        scroller.setEnabled(True)

    #disable the right-click menu
    def contextMenuEvent (self, event):
        pass

#    def event(self,event):
##        print "event"
#        if (event.type() == QEvent.Gesture):
#            print "aa"
#            gesture=event.gesture(Qt.SwipeGesture)
#            if (gesture.state() == Qt.GestureFinished):
#                if gesture.horizontalDirection() == QSwipeGesture.Left:
#                    print "left"
#                elif gesture.horizontalDirection() == QSwipeGesture.Right:
#                    print "right"
#            return True
#        else:
#            return super(ChaptersContentView, self).event(event)

    def update_content(self, filename=None):
        if filename!=None:
            self.load(QUrl(filename))

    def update_content_html(self, contentHtml=None, baseUrl=None):
#        settings=self.settings()
#        settings.setDefaultTextEncoding("gbk")
#        self.reload()
#        self.setHtml("")
        self.setHtml(contentHtml,baseUrl)
#        self.reload()

    def zoom(self,size):
        self.setZoomFactor(size)

#class ContentEventFilter(QObject):
#
#    def __init__(self, parent = None):
#        QObject.__init__(self, parent)
#        self.mousePressed=False
#
#    def eventFilter(self, object, event):
#        eventType = event.type()
#        if eventType == QEvent.MouseButtonPress:
#            if event.buttons() == Qt.LeftButton:
#                self.mousePressed  = True
#        if eventType == QEvent.MouseButtonRelease:
#            if event.buttons() == Qt.LeftButton:
#                self.mousePressed  = False
#        if eventType == QEvent.MouseMove:
#            if self.mousePressed:
#                return True
#        return False

class SearchConfigForm(QDialog):
    def __init__(self, websites=None, orientation=0, parent=None):
        super(SearchConfigForm, self).__init__(parent)
        self.orientation=orientation
        self.websitesModel=WebsitesModel(websites)
        websitesListView=QListView()
        websitesListView.setSelectionMode(QAbstractItemView.MultiSelection)
        websitesListView.setVerticalScrollMode(QAbstractItemView.ScrollPerItem)
        websitesListView.setViewMode(QListView.ListMode)
        websitesListView.setMovement(QListView.Static)
        websitesListView.setItemDelegate(HtmlCellDelegate(self.orientation,-50))
        websitesListView.setModel(self.websitesModel)
        self.selectionModel=websitesListView.selectionModel()
        for row in range(self.websitesModel.rowCount()):
            cindex=self.websitesModel.index(row,0)
            c=self.websitesModel.data(cindex, Qt.EditRole)
            if c["enabled"]:
                self.selectionModel.select(cindex,QItemSelectionModel.Select)
        websitesListView.setSelectionModel(self.selectionModel)
        self.confirmButton = QPushButton(unicode("确定"))
        self.cancelButton = QPushButton(unicode("取消"))

        self.setWindowTitle(unicode("选择搜索网站"))
#        if self.orientation==1:
#            self.outerLayout = QVBoxLayout(self)
#        else:
        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        
        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        if self.orientation==1:
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.setFixedHeight(500)
        else:
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.setFixedHeight(300)
        self.buttonFrame=QFrame()
        self.buttonFrame.setLayout(self.buttonFormLayout)

        self.outerLayout.addWidget(websitesListView,0,0)
        if self.orientation==1:
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.outerLayout.addWidget(self.buttonFrame,0,1)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        self.buttonFormLayout.removeWidget(self.confirmButton)
        self.buttonFormLayout.removeWidget(self.cancelButton)
        self.outerLayout.removeWidget(self.buttonFrame)
        if self.orientation==1:
            self.setFixedHeight(500)
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.setFixedHeight(300)
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,0,1)

    def output_websites(self):
        result=[]
        for row in range(self.websitesModel.rowCount()):
            cindex=self.websitesModel.index(row,0)
            c=self.websitesModel.data(cindex, Qt.EditRole)
            if self.selectionModel.isSelected(cindex):
                c["enabled"]=1
            else:
                c["enabled"]=0
            result.append(c)
        return result

class WebsitesModel(QAbstractListModel):
    def __init__(self, websites=None, parent=None):
        super(WebsitesModel, self).__init__(parent)
        self.websites=websites

    def rowCount(self,parent=None):
        return len(self.websites)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.websites)):
            return None
        if (role == Qt.DisplayRole):
            website=self.websites[index.row()]
            source="""
            <tr style="font-size:22px;color:#FFFFFF">
                <td>%s</td>
                <td align="left">%s</td>
            </tr>
            </table>
            """
            html="<table width=\"80%\" border=\"0\">"+source % (unicode(website["name"]), website["indexUrl"])
            return html
        else:
            return self.websites[index.row()]

class SearchResultsForm(QDialog):
    def __init__(self, searchResults=None, orientation=0, parent=None):
        super(SearchResultsForm, self).__init__(parent)
        self.orientation=orientation
        self.searchResultsModel=SearchResultsModel(searchResults)
        self.searchResultsView=QListView()
        self.searchResultsView.setSelectionMode(QAbstractItemView.SingleSelection)
        self.searchResultsView.setVerticalScrollMode(QAbstractItemView.ScrollPerItem)
        self.searchResultsView.setViewMode(QListView.ListMode)
        self.searchResultsView.setMovement(QListView.Static)
        self.searchResultsView.setItemDelegate(HtmlCellDelegate(self.orientation,-50))
        self.searchResultsView.setModel(self.searchResultsModel)
        self.setWindowTitle(unicode("搜索结果"))
        self.confirmButton = QPushButton(unicode("确定"))
        self.cancelButton = QPushButton(unicode("取消"))
        
#        if self.orientation==1:
#            self.outerLayout = QVBoxLayout(self)
#        else:
        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        
        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        if self.orientation==1:
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.setFixedHeight(500)
        else:
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.setFixedHeight(300)
        self.buttonFrame=QFrame()
        self.buttonFrame.setLayout(self.buttonFormLayout)
        self.outerLayout.addWidget(self.searchResultsView,0,0)
        if self.orientation==1:
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.outerLayout.addWidget(self.buttonFrame,0,1)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        self.buttonFormLayout.removeWidget(self.confirmButton)
        self.buttonFormLayout.removeWidget(self.cancelButton)
        self.outerLayout.removeWidget(self.buttonFrame)
        if self.orientation==1:
            self.setFixedHeight(500)
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.setFixedHeight(300)
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,0,1)

    def get_selected(self):
        rownum=-1
        smodel=self.searchResultsView.selectionModel()
        if smodel.hasSelection():
            index=smodel.selectedIndexes()[0]
            rownum=index.row()
        return rownum

class SearchResultsModel(QAbstractListModel):
    def __init__(self, searchResults=None, parent=None):
        super(SearchResultsModel, self).__init__(parent)
        self.searchResults=searchResults

    def rowCount(self,parent=None):
        return len(self.searchResults)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.searchResults)):
            return None
        if (role == Qt.DisplayRole):
            book=self.searchResults[index.row()]
            source="""
            <tr style="font-size:22px;color:#FFFFFF">
                <td>%s</td>
                <td align=\"right\">%s</td>
            </tr>
            <tr style="font-size:18px;color:#808080">
                <td>%s</td>
                <td align=\"right\">%s</td>
            </tr>
            </table>
            """
            html="<table width=\"80%\" border=\"0\">"+source % (
                unicode(book["name"]), unicode(book["websiteName"]),
                unicode(book["author"]),unicode(book["latestChapter"]))
            return html
        else:
            return self.searchResults[index.row()]

class NewBookForm(QDialog):
    def __init__(self, websites=None,book=None, parent=None,orientation=0):
        super(NewBookForm, self).__init__(parent)
        self.orientation=orientation
        self.obook=book
        self.label = QLabel(unicode("书名"))
        self.label.setObjectName("label")
        self.label_2 = QLabel(unicode("目录页网址"))
        self.label_2.setObjectName("label_2")
        self.label_3 = QLabel(unicode("作者"))
        self.label_3.setObjectName("label_3")
        self.label_4 = QLabel(unicode("网站"))
        self.label_4.setObjectName("label_4")
        self.bookNameLE = QLineEdit(self)
        self.bookNameLE.setObjectName("bookName")
        self.urlLE = QLineEdit(self)
        self.urlLE.setObjectName("url")
        self.authorLE = QLineEdit(self)
        self.authorLE.setObjectName("author")
        self.webCB=QComboBox(self)
        index=0
        for website in websites:
            self.webCB.insertItem(index,unicode(website["name"])+":"+website["indexUrl"],QVariant(website["id"]))
            index+=1
        self.autoDownloadCB = QCheckBox(unicode("自动下载"))
        self.autoDownloadCB.setObjectName("autoDownload")
        self.stopUpdateCB = QCheckBox(unicode("停止更新"))
        self.stopUpdateCB.setObjectName("stopUpdate")
        self.confirmButton = QPushButton(unicode("确定"))
        self.searchButton = QPushButton(unicode("搜索"))
        self.searchConfigButton = QPushButton(unicode("搜索配置"))
        self.cancelButton = QPushButton(unicode("取消"))
        self.searchConfigButton.setFixedWidth(200)
        self.searchButton.setFixedWidth(200)
        self.cancelButton.setFixedWidth(200)
        self.confirmButton.setFixedWidth(200)

#        if self.orientation==1:
#            self.outerLayout = QVBoxLayout(self)
#        else:
        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        self.formLayout=QFormLayout()
        self.formLayout.setAlignment(Qt.AlignTop)
        self.formLayout.addRow(self.label,self.bookNameLE)
        self.formLayout.addRow(self.label_3,self.authorLE)
        self.formLayout.addRow(self.label_2,self.urlLE)
        self.formLayout.addRow(self.label_4,self.webCB)
        if not book is None:
            btnLayout = QHBoxLayout()
            btnLayout.addWidget(self.autoDownloadCB)
            btnLayout.addWidget(self.stopUpdateCB)
            self.formLayout.addRow(btnLayout)
        else:
            self.formLayout.addRow(self.autoDownloadCB)
        self.frame=QFrame()
        self.frame.setLayout(self.formLayout)
        
        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        if self.orientation==1:
            if book is None:
#                self.searchConfigButton.setFixedWidth(200)
#                self.searchButton.setFixedWidth(200)
                self.buttonFormLayout.addRow(self.searchButton,self.searchConfigButton)
#            self.cancelButton.setFixedWidth(200)
#            self.confirmButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
        else:
            if book is None:
                self.buttonFormLayout.addRow(self.searchButton)
                self.buttonFormLayout.addRow(self.searchConfigButton)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
        self.buttonFrame=QFrame()
        self.buttonFrame.setLayout(self.buttonFormLayout)

        self.outerLayout.addWidget(self.frame,0,0)
        if self.orientation==1:
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.outerLayout.addWidget(self.buttonFrame,0,1)
        self.outerLayout.setAlignment(self.formLayout,Qt.AlignTop)
        self.update_new_book(book)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
#        if self.book is None:
        self.buttonFormLayout.removeWidget(self.searchButton)
        self.buttonFormLayout.removeWidget(self.searchConfigButton)
        self.buttonFormLayout.removeWidget(self.confirmButton)
        self.buttonFormLayout.removeWidget(self.cancelButton)
        if orientation==1:
            if self.obook is None:
#                self.confirmButton.setFixedWidth(200)
#                self.cancelButton.setFixedWidth(200)
                self.buttonFormLayout.addRow(self.searchButton,self.searchConfigButton)
#            self.confirmButton.setFixedWidth(200)
#            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            if self.obook is None:
                self.buttonFormLayout.addRow(self.searchButton)
                self.buttonFormLayout.addRow(self.searchConfigButton)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,0,1)

    def update_new_book(self,book=None):
        self.book=book
        if book is not None:
            self.bookNameLE.setFocus()
            if book["name"] is None:
                self.bookNameLE.setText("")
            else:
                self.bookNameLE.setText(unicode(book["name"]))
                self.bookNameLE.selectAll()
            if book["author"] is None:
                self.authorLE.setText("")
            else:
                self.authorLE.setText(unicode(book["author"]))
            if book["url"] is None:
                self.urlLE.setText("")
            else:
                self.urlLE.setText(book["url"])
            if book["url"] is None:
                self.webCB.setCurrentIndex(0)
            else:
                for i in range(self.webCB.count()):
                    self.webCB.setCurrentIndex(i)
                    if self.webCB.itemData(self.webCB.currentIndex())==QVariant(book["websiteId"]):
                        break
            if book["autoDownload"]:
                self.autoDownloadCB.setCheckState(Qt.Checked)
            else:
                self.autoDownloadCB.setCheckState(Qt.Unchecked)
            if book["stopUpdate"]:
                self.stopUpdateCB.setCheckState(Qt.Checked)
            else:
                self.stopUpdateCB.setCheckState(Qt.Unchecked)

    def validate(self,callback):
        if self.bookNameLE.text() is None or self.bookNameLE.text()=="":
            callback(unicode("请输入书名"))
            return 0
        elif self.urlLE.text() is None or self.urlLE.text()=="":
            callback(unicode("请输入目录页网址"))
            return 0
        else:
            url=self.urlLE.text()
            if string.find(str(url), "http://") != 0:
                url = "http://" + url
                self.urlLE.setText(url)
            return 1

    def output_book(self,callback):
        if self.validate(callback):
            self.book["name"]=str(self.bookNameLE.text())
            self.book["url"]=str(self.urlLE.text())
            self.book["author"]=str(self.authorLE.text())
            self.book["websiteId"]=int(self.webCB.itemData(self.webCB.currentIndex()).toString())
            self.book["autoDownload"]=self.autoDownloadCB.checkState()>0 and 1 or 0
            self.book["stopUpdate"]=self.stopUpdateCB.checkState()>0 and 1 or 0
            return self.book
        else:
            return None
        
class DeleteBookForm(QDialog):
    def __init__(self, book=None, parent=None,orientation=0):
        super(DeleteBookForm, self).__init__(parent)
        self.orientation=orientation
        self.book=book
        bookName=book["name"]
        self.setWindowTitle(unicode("删除"))
        self.label = QLabel(unicode("确认删除 <<%s>> ?" %bookName))
        self.label.setWordWrap(True)
        self.fileCB = QCheckBox(unicode("删除已下载/本地文件"))
#        if self.orientation==1:
#            self.outerLayout = QVBoxLayout(self)
#        else:
        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        self.formLayout=QFormLayout()
        self.formLayout.setAlignment(Qt.AlignTop)
        self.formLayout.addRow(self.label)
        self.formLayout.addRow(self.fileCB)

        self.frame=QFrame()
        self.frame.setLayout(self.formLayout)
        
        self.confirmButton = QPushButton(unicode("确定"))
        self.cancelButton = QPushButton(unicode("取消"))
        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        self.buttonFrame=QFrame()
        if self.orientation==1:
            self.label.setFixedWidth(430)
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
        else:
            self.label.setFixedWidth(600)
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
        self.buttonFrame.setLayout(self.buttonFormLayout)
        self.outerLayout.addWidget(self.frame,0,0)
        if self.orientation==1:
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.outerLayout.addWidget(self.buttonFrame,0,1)
        self.outerLayout.setAlignment(self.formLayout,Qt.AlignTop)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        self.buttonFormLayout.removeWidget(self.confirmButton)
        self.buttonFormLayout.removeWidget(self.cancelButton)
        self.outerLayout.removeWidget(self.buttonFrame)
        if self.orientation==1:
            self.label.setFixedWidth(430)
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.label.setFixedWidth(600)
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,0,1)

class ConfigForm(QDialog):
    def __init__(self, config=None, parent=None,orientation=0):
        super(ConfigForm, self).__init__(parent)
        self.orientation=orientation
        self.setWindowTitle(unicode("配置"))
        
        self.autoUpdateCB = QCheckBox(unicode("启动后自动更新全部小说"))
        self.scheUpdateCB = QCheckBox(unicode("定时更新"))
        
        names=[unicode("30分钟"),unicode("1小时"),unicode("2小时"),unicode("3小时")]
        self.values=[QVariant(30),QVariant(60),QVariant(120),QVariant(180)]
        self.scheTimeModel=QStringListModel(names)
        self.scheTimeBtn = QMaemo5ValueButton(unicode("更新时间间隔"))
        self.scheTimeBtn.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.selector1 =QMaemo5ListPickSelector()
        self.selector1.setModel(self.scheTimeModel)
        self.scheTimeBtn.setPickSelector(self.selector1)

        ortNames=[unicode("横屏"),unicode("竖屏"),unicode("自动")]
        self.ortValues=[QVariant(0),QVariant(1),QVariant(2)]
        self.ortModel=QStringListModel(ortNames)
        self.ortBtn = QMaemo5ValueButton(unicode("屏幕显示"))
        self.ortBtn.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.selector2 =QMaemo5ListPickSelector()
        self.selector2.setModel(self.ortModel)
        self.ortBtn.setPickSelector(self.selector2)

        self.label2 = QLabel(unicode("下载文件存储路径 *"))
        self.label2.setObjectName("label2")
        self.pathLabel = QLabel("")
        self.pathLabel.setFrameStyle(QFrame.StyledPanel|
                                         QFrame.Sunken)
        self.pathButton = QPushButton(unicode("更改"))
        self.pathButton.setAutoDefault(False)
        self.connect(self.pathButton, SIGNAL("clicked()"),
                     self.set_path)
        self.notice=QLabel(unicode("* 该配置更改后须重启N3DR方可生效"))
        self.confirmButton = QPushButton(unicode("确定"))
        self.cancelButton = QPushButton(unicode("取消"))

        self.outerLayout = QGridLayout()
        self.outerLayout.setObjectName("outerLayout")
        self.formLayout=QFormLayout()
        self.formLayout.setAlignment(Qt.AlignTop)
        self.formLayout.addRow(self.autoUpdateCB)
        self.formLayout.addRow(self.scheUpdateCB)
        self.formLayout.addRow(self.scheTimeBtn)
        self.formLayout.addRow(self.ortBtn)
        if self.orientation==1:
            self.formLayout.addRow(self.label2,self.pathButton)
            self.formLayout.addRow(self.pathLabel)
        else:
            self.formLayout.addRow(self.label2)
            self.formLayout.addRow(self.pathLabel,self.pathButton)
        self.formLayout.addRow(self.notice)

        self.frame=QFrame()
        self.frame.setLayout(self.formLayout)
        self.scrollArea=QScrollArea()
        self.scrollArea.setWidget(self.frame)

        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        if self.orientation==1:
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
        else:
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
        self.buttonFrame=QFrame()
        self.buttonFrame.setLayout(self.buttonFormLayout)

        self.outerLayout.addWidget(self.scrollArea,0,0)
        if self.orientation==1:
            self.frame.setFixedWidth(440)
            self.outerLayout.addWidget(self.buttonFrame,1,0)
            self.setFixedHeight(600)
        else:
            self.frame.setFixedWidth(550)
            self.outerLayout.addWidget(self.buttonFrame,0,1)
            self.setFixedHeight(300)
        self.outerLayout.setAlignment(self.formLayout,Qt.AlignTop)
        self.setLayout(self.outerLayout)
        
        self.config=config
        self.update_config(config)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        self.scrollArea.takeWidget()
        self.outerLayout.removeWidget(self.buttonFrame)
        self.formLayout.removeWidget(self.label2)
        self.formLayout.removeWidget(self.pathButton)
        self.formLayout.removeWidget(self.pathLabel)
        self.formLayout.removeWidget(self.notice)
        self.buttonFormLayout.removeWidget(self.confirmButton)
        self.buttonFormLayout.removeWidget(self.cancelButton)
        if orientation==1:
            self.frame.setFixedWidth(440)
            self.scrollArea.setWidget(self.frame)
            self.formLayout.addRow(self.label2,self.pathButton)
            self.formLayout.addRow(self.pathLabel)
            self.formLayout.addRow(self.notice)
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,1,0)
            self.setFixedHeight(600)
        else:
            self.frame.setFixedWidth(550)
            self.scrollArea.setWidget(self.frame)
            self.formLayout.addRow(self.label2)
            self.formLayout.addRow(self.pathLabel,self.pathButton)
            self.formLayout.addRow(self.notice)
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,0,1)
            self.setFixedHeight(300)

    def update_config(self,config=None):
        if config is not None:
            self.config=config
            self.pathLabel.setText(self.config["storagePath"])
            if self.config["autoUpdateWhenStart"]:
                self.autoUpdateCB.setCheckState(Qt.Checked)
            if self.config["scheduledUpdate"]:
                self.scheUpdateCB.setCheckState(Qt.Checked)
            for i in range(len(self.values)):
                if self.values[i]==QVariant(self.config["scheduledUpdateTime"]):
                    self.selector1.setCurrentIndex(i)
                    break
            for i in range(len(self.ortValues)):
                if self.ortValues[i]==QVariant(self.config["orientation"]):
                    self.selector2.setCurrentIndex(i)
                    break

    def output_config(self):
        self.config["autoUpdateWhenStart"]=self.autoUpdateCB.checkState() and 1 or 0
        self.config["scheduledUpdate"]=self.scheUpdateCB.checkState() and 1 or 0
        self.config["scheduledUpdateTime"]=str(self.values[self.selector1.currentIndex()].toString())
        self.config["orientation"]=str(self.ortValues[self.selector2.currentIndex()].toString())
        return self.config

    def set_path(self):
        path = QFileDialog.getExistingDirectory(self,
                    unicode("请选择下载文件存储路径"), self.config["storagePath"])
        if path:
            if path[-1]!='/':
                path+="/"
            self.config["storagePath"] = path
            self.pathLabel.setText(self.config["storagePath"])

class AboutForm(QDialog):
    def __init__(self, parent=None):
        super(AboutForm, self).__init__(parent)
        self.setWindowTitle(unicode("关于"))
        self.aboutLabel=QLabel()
        st="""<b>N3DR</b>
            <p>  Nokia N900 Novel Downloader and Reader
            <p>  Version %s   Build %s
            <p>  %s
            <p>  %s
            <p>  Python %s - Qt %s
            <p>  PyQt %s""" % (
                          __version__, __build__,
                          __author__,__email__, platform.python_version(),
                          QT_VERSION_STR, PYQT_VERSION_STR)
        self.aboutLabel.setText(st)
        self.formLayout=QFormLayout(self)
        self.formLayout.addRow(self.aboutLabel)

class LogWindow(QMainWindow):
    def __init__(self, parent=None):
        super(LogWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setWindowTitle(unicode("N3DR-日志"))
        self.textEdit=QPlainTextEdit()
        self.textEdit.setReadOnly(True)
        self.setCentralWidget(self.textEdit)

    def write(self,text):
        tc=self.textEdit.textCursor()
        tc.movePosition(QTextCursor.End)
        self.textEdit.setTextCursor(tc)
        self.textEdit.appendHtml(unicode(text))
