# -*- coding: utf-8 -*-
'''
Created on 2010-1-17

@author: Michael
'''
import os
from DAO import DAO
from Downloader import Downloader
from Processor import Processor
from Exceptions import *
import Utils
import string
import urllib2
from Writer import Writer
from datetime import datetime
from Logger import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *

class Controller():
    def __init__(self,logger):
#        self.logger = logging.getLogger('Controller')
        self.logger=logger
        self.dao = DAO(self.logger)
        self.writer = Writer(self.logger)

    def get_all_websites(self):
        return self.dao.get_all_websites()

    def update_websites(self,websites):
        return self.dao.update_websites(websites)

    def get_a_book(self,id):
        return self.dao.get_a_book(id)

    def get_all_books(self):
        return self.dao.get_all_books()

    def get_chapters_for_a_book(self,bookId):
        return self.dao.get_chapters_for_a_book(bookId)

    def get_all_chapters_for_a_book(self,bookId):
        return self.dao.get_all_chapters_for_a_book(bookId)

    def save_a_book(self,book,filepath=None):
        if book is not None:
            if book["id"] is None or book["id"]=="":
                abook=self.dao.add_a_book(book)
                if filepath is not None:
                    self.writer.mk_book_dir(abook["id"],filepath)
                return abook
            else:
                return self.dao.update_a_book(book)

    def delete_a_book(self,book,filepath=None):
        self.dao.delete_a_book(book["id"])
        if filepath!=None:
            if book["websiteId"]==Utils.UMD_WEBSITE_ID:
                self.writer.del_book_files(None,book["url"])
            else:
                self.writer.del_book_files(book["id"],filepath)

    def delete_chapters(self,chapters,filepath):
        self.dao.delete_chapters(chapters)
        for chapter in chapters:
            self.writer.del_chapter_files(chapter,filepath)

    def update_chapters(self,chapters):
        self.dao.update_chapters(chapters)

    def add_chapters(self,chapters):
        return self.dao.add_chapters(chapters)

class SearchThread(QThread):
    def __init__(self, logger, parent=None):
#        self.logger = logging.getLogger('SearchThread')
        super(SearchThread, self).__init__(parent)
        self.logger=logger
        self.logger.debug("SearchThread:__init__")
        self.stopped = False
        self.mutex = QMutex()
        self.completed = False
        self.searchResults=[]

    def initialize(self, websites,bookName):
        self.logger.debug("SearchThread:initialize")
        self.stopped = False
        self.originalBookName=bookName
        self.bookName=urllib2.quote(bookName.encode("gbk"))
        self.websites=websites
        self.completed = False
        self.downloader = Downloader(self.logger)
        self.processor = Processor()
        self.searchResults=[]

    def stop(self):
        try:
            self.mutex.lock()
            self.stopped = True
        finally:
            self.mutex.unlock()


    def is_stopped(self):
        try:
            self.mutex.lock()
            return self.stopped
        finally:
            self.mutex.unlock()

    def run(self):
        self.logger.debug("run")
        self.search_books()
        self.stop()

    def search_books(self):
        if len(self.websites)==0:
            return
        realWebsites=[]
        for website in self.websites:
            if website["enabled"]==0:
                continue
            searchUrl=website["searchUrl"]
            if searchUrl is None or len(searchUrl)==0:
                continue
            realWebsites.append(website)

        if len(realWebsites)==0:
            return
        #for showing progress
        progressBase=10
        websiteNum=len(realWebsites)
        everyWebsiteProgress=(100-progressBase)/websiteNum
        nowProgress=progressBase
        websiteSeq=0
        for website in realWebsites:
            if self.is_stopped():
                self.emit(SIGNAL("finished(bool,int,int)"),self.completed,websiteSeq,len(self.searchResults))
                return
            
            self.emit(SIGNAL("show_progress(int)"), nowProgress)
#            self.emit(SIGNAL("show_status(QString)"), unicode("正在搜索网站: %s %s" % (website["name"],website["indexUrl"])))
            nowProgress+=everyWebsiteProgress
            searchUrl=website["searchUrl"]
            placeHolder=Utils.BOOK_NAME_PLACE_HOLDER
            searchUrl=string.replace(searchUrl, placeHolder, self.bookName)
            if self.is_stopped():
                self.emit(SIGNAL("finished(bool,int,int)"),self.completed,websiteSeq,len(self.searchResults))
                return
            self.logger.info("searching %s in website %s, url: %s" %((self.bookName),(website["name"]),searchUrl))
            try:
                contentHtml = self.downloader.download(searchUrl)
            except NetworkError:
#                self.emit(SIGNAL("show_errors(QString)"), unicode("无法读取网站: %s ,网络故障" % website["name"]))
                self.logger.error("error to access website: %s" % (website["name"]))
                continue
#            print contentHtml
            if self.is_stopped():
                self.emit(SIGNAL("finished(bool,int,int)"),self.completed,websiteSeq,len(self.searchResults))
                return
            self.processor.init(website)
            srs= self.processor.process_search(contentHtml)
            if self.is_stopped():
                self.emit(SIGNAL("finished(bool,int,int)"),self.completed,websiteSeq,len(self.searchResults))
                return
            for sr in srs:
                book=Utils.build_a_default_book()
                try:
                    book["name"]=unicode(sr["name"][0],"gbk")
                    if book["name"].find(self.originalBookName)==-1:
                        continue
                except UnicodeDecodeError:
                    continue
                try:
                    book["author"]=unicode(sr["author"][0],"gbk")
                except KeyError:
                    book["author"]=""
                book["websiteId"]=website["id"]
                book["websiteName"]=website["name"]
                try:
                    book["latestChapter"]=unicode(sr["latestChapter"][0],"gbk")
                except UnicodeDecodeError:
                    continue
                try:
                    url=sr["latestChapter"][1]
                    index=url.rfind("/")
                    url=url[0:index+1]
                    if url[0]=='/':
                        url=website["indexUrl"]+url
                    book["url"]=url
                    self.searchResults.append(book)
                except:
                    continue
            websiteSeq+=1
        self.completed=True
        self.emit(SIGNAL("finished(bool,int,int)"),self.completed,websiteSeq,len(self.searchResults))
        return




class UpdateThread(QThread):
    def __init__(self, logger,parent=None):
        super(UpdateThread, self).__init__(parent)
        self.stopped = False
        self.mutex = QMutex()
        self.completed = False
#        self.logger = logging.getLogger('UpdateThread')
        self.logger =logger
        self.logger.debug("UpdateThread:__init__")

    def initialize(self, books, chapters, filepath):
        self.logger.debug("UpdateThread:initialize")
        self.stopped = False
        self.books=books
        self.chapters=chapters
        self.filepath=filepath
        self.completed = False
        self.dao = DAO(self.logger)
        self.writer = Writer(self.logger)
        self.downloader = Downloader(self.logger)
        self.processor = Processor()

    def stop(self):
        try:
            self.mutex.lock()
            self.stopped = True
        finally:
            self.mutex.unlock()
            

    def is_stopped(self):
        try:
            self.mutex.lock()
            return self.stopped
        finally:
            self.mutex.unlock()

    def run(self):
        self.logger.debug("run")
        if self.books is not None:
            self.update_books(self.books)
        if self.chapters is not None:
            self.update_chapters(self.chapters)
        self.stop()
        
        
    def update_books(self, books):
        self.logger.debug('UpdateThread.update_books')
        self.logger.debug(books)
        #for showing status
        updateBooksNum=0
        newChaptersNum=0
        downloadChaptersNum=0

        if books is None or len(books)==0:
            self.emit(SIGNAL("finished(bool,int,int,int)"),
                    self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
            return

        if self.is_stopped():
            self.emit(SIGNAL("finished(bool,int,int,int)"),
                    self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
            return
        #for showing progress
#        progressBase=0
#        bookCount=len(books)
#        everyBookProgress=100/bookCount
#        nowProgress=progressBase
#        bookSeq=-1
        for book in books:
            if self.is_stopped():
                self.emit(SIGNAL("finished(bool,int,int,int)"),
                    self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                return

#            bookSeq+=1
#            nowProgress=bookSeq*everyBookProgress
#            self.emit(SIGNAL("show_progress(int)"), nowProgress)
            bookName=book["name"]
            #check if this book is updatable
            if book["stopUpdate"] == 1:
                continue

            website=self.dao.get_a_website(book["websiteId"])
            self.processor.init(website)
            updateBooksNum+=1
#            self.emit(SIGNAL("begin_update_the_book(int,int)"), 1,book["id"])
#            self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :开始更新" % bookName))
            self.logger.info("updating the book: %s, from url: %s " %(bookName,book["url"]))
            book["updateDate"]=datetime.now()
            if self.is_stopped():
#                self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                self.emit(SIGNAL("finished(bool,int,int,int)"),
                    self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                return
            #get old but need to download chapters
            chapters = self.dao.get_all_chapters_for_a_book(book['id'])
            #check the index page if latest
#            self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :检查远程服务器是否更新" % bookName))

            try:
                headers=self.downloader.check_if_latest(book)
            except NetworkError:
#                self.emit(SIGNAL("show_errors(QString)"), unicode("无法读取 <<%s>> 目录页, 地址: %s" % (bookName,book["url"])))
                self.logger.error("error to read the index page: %s, %s" % ((bookName),book["url"]))
#                self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                continue

#            nowProgress+=everyBookProgress/5
#            self.emit(SIGNAL("show_progress(int)"), nowProgress)
            if headers is None:
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :远程服务器没有更新" % bookName))
                self.logger.info("updating the book: %s, it is latest" %(bookName))
            else:
                if self.is_stopped():
#                    self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                    self.emit(SIGNAL("finished(bool,int,int,int)"),
                        self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                    return
                indexUrl = book["url"]
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :正在连接目录页" % bookName))

                try:
                    indexHtml = self.downloader.download(indexUrl)
                except NetworkError:
#                    self.emit(SIGNAL("show_errors(QString)"), unicode("无法读取 <<%s>> 目录页, 地址: %s" % (bookName,indexUrl)))
                    self.logger.error("error to read the index page: %s, %s" % ((bookName),indexUrl))
#                    self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                    continue

                if self.is_stopped():
#                    self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                    self.emit(SIGNAL("finished(bool,int,int,int)"),
                        self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                    return
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :正在解析目录页内容" % bookName))
                links = self.processor.process_catalog(indexHtml)
                if self.is_stopped():
#                    self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                    self.emit(SIGNAL("finished(bool,int,int,int)"),
                        self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                    return
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :正在比较本地内容" % bookName))

                newChaptersLink = []
                for link in links:
                    link[0] = unicode(link[0], "gbk")
                    link[1] = Utils.generate_chapter_url(indexUrl, link[1])
                    newFlag = 1
                    for chapter in chapters:
                        if link[0] == chapter["title"] and link[1] == chapter["url"]:
                            newFlag = 0
                            break
                    if newFlag:
                        newChaptersLink.append(link)

                if self.is_stopped():
#                    self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                    self.emit(SIGNAL("finished(bool,int,int,int)"),
                        self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                    return
                
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :比较完毕，共有%s个新章节" % (bookName,len(newChaptersLink))))
                self.logger.info("updating the book: %s, found %s new chapters" %((bookName),len(newChaptersLink)))
                #update the cataglog at first
                maxSeq = self.dao.get_max_sequence_for_a_book(book["id"])
                if maxSeq is None:
                    maxSeq=0
                newChapterList = []
                for newLink in newChaptersLink:
                    if self.is_stopped():
#                        self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                        self.emit(SIGNAL("finished(bool,int,int,int)"),
                            self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                        return
                    chapter = Utils.build_a_default_chapter()
                    chapter["bookId"] = book["id"]
                    chapter["title"] = newLink[0]
                    chapter["url"] = newLink[1]
                    maxSeq += 1
                    chapter["sequence"] = maxSeq
                    chapter["downloadable"] = book["autoDownload"]
                    newChapterList.append(chapter)

                if self.is_stopped():
#                    self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                    self.emit(SIGNAL("finished(bool,int,int,int)"),
                        self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                    return

                book["chapterNum"] = len(newChapterList) + book["chapterNum"]
                book["unreadChapterNum"] = len(newChapterList) + book["unreadChapterNum"]
                newChapterList = self.dao.add_chapters(newChapterList)
                try:
                    book["lastModified"]=headers["last-modified"]
                    book["eTag"]=headers["etag"]
                except KeyError:
                    self.logger.warning("error to read lastModified and eTag ")
                self.dao.update_a_book(book)
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :检查更新完毕" % bookName))
                self.emit(SIGNAL("end_download_one_chapter(int,int)"), book["id"],-1)
                newChaptersNum+=len(newChapterList)
                if self.is_stopped():
#                    self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                    self.emit(SIGNAL("finished(bool,int,int,int)"),
                        self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                    return

#            nowProgress+=everyBookProgress/5
#            self.emit(SIGNAL("show_progress(int)"), nowProgress)

            #find the chapters need to download
#            self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :检查需要下载的章节" % bookName))
            chapters = self.dao.get_all_chapters_for_a_book(book['id'])
            oldChapters=[]
            for chapter in chapters:
                if chapter["downloadable"] and chapter["downloaded"] == 0 and chapter["filtered"] == 0:
                    oldChapters.append(chapter)
            chapterNum=len(oldChapters)
            if chapterNum>0:
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :共有%s个章节需要下载" % (bookName,chapterNum)))
                self.logger.info("updating the book: %s, there are %s chapters need to download" %((bookName),chapterNum))

#                cc=chapterNum
#                ocp=everyBookProgress*3/5/cc
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :开始下载" % bookName))

                for chapter in oldChapters:
                    self.logger.info("updating the book: %s, downloading chapter: %s from url: %s" %((bookName),(chapter["title"]),chapter["url"]))
                    if self.is_stopped():
#                        self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                        self.emit(SIGNAL("finished(bool,int,int,int)"),
                        self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                        return
                    try:
                        filename=self.__download_and_write_a_chapter(book,chapter,self.filepath)
                    except NetworkError:
#                        self.emit(SIGNAL("show_errors(QString)"), unicode("无法下载 <<%s>> <%s>" % (bookName,chapter["title"])))
                        self.logger.error("error to download the chapter: %s, %s, %s" % ((bookName),(chapter["title"]),chapter["url"]))
                        continue
                    chapter["filename"] = filename
                    chapter["downloaded"] = 1
                    chapter["downloadDate"] = datetime.now()
                    self.dao.update_chapters([chapter])
                    book["downloadedChapterNum"] = 1 + book["downloadedChapterNum"]
                    downloadChaptersNum+=1
                    self.dao.update_a_book(book)
#                    nowProgress+=ocp
#                    self.emit(SIGNAL("show_progress(int)"), nowProgress)
                    self.emit(SIGNAL("end_download_one_chapter(int,int)"), book["id"],chapter["id"])

                if self.is_stopped():
#                    self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
                    self.emit(SIGNAL("finished(bool,int,int,int)"),
                        self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                    return

#            self.emit(SIGNAL("end_update_the_book(int,int)"), 0,book["id"])
#            self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :更新完毕" % bookName))
            self.logger.info("updating the book: %s done" %(bookName))
        self.completed = True
        self.emit(SIGNAL("finished(bool,int,int,int)"),
                            self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
        self.logger.info("update completed!")

    def update_chapters(self,chapters):
#        self.emit(SIGNAL("show_progress(int)"), 1)
#        progressBase=10
#        count=len(chapters)
#        count=count==0 and 1 or count
#        everyChapterProgress=100/count
#        chapterSeq=0
        for chapter in chapters:
            if self.is_stopped():
                self.emit(SIGNAL("finished(bool,int,int,int)"),
                    self.completed,updateBooksNum,newChaptersNum,downloadChaptersNum)
                return
#            nowProgress=chapterSeq*everyChapterProgress+progressBase
#            self.emit(SIGNAL("show_progress(int)"), nowProgress)
#            chapterSeq+=1
            book=self.dao.get_a_book(chapter["bookId"])
            website=self.dao.get_a_website(book["websiteId"])
            self.processor.init(website)
            try:
                filename=self.__download_and_write_a_chapter(book,chapter,self.filepath)
            except NetworkError:
#                self.emit(SIGNAL("show_errors(QString)"), unicode("无法下载 <%s>" % (chapter["title"])))
                self.logger.error("error to download the chapter:  %s, %s" % ((chapter["title"]),chapter["url"]))
                continue
            chapter["filename"] = filename
            chapter["downloadDate"] = datetime.now()
            if chapter["readed"] ==0:
                chapter["readed"] =1
                book["unreadChapterNum"] =  book["unreadChapterNum"]-1
            if chapter["downloaded"] == 0:
                chapter["downloaded"] =1
                book["downloadedChapterNum"] = 1 + book["downloadedChapterNum"]
            self.dao.update_chapters([chapter])
            self.dao.update_a_book(book)
            self.emit(SIGNAL("end_download_one_chapter(int,int)"), book["id"],chapter["id"])
        self.completed = True
        self.emit(SIGNAL("finished(bool,int,int,int)"),
                            self.completed,-1,-1,-1)

    def __download_and_write_a_chapter(self,book,chapter,filepath):
#        bookName=book["name"]
#        chapterName=chapter["title"]
#        self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :正在下载章节 <%s>" % (bookName,chapterName)))
#       just for www.mx99.com, because it use frame to load the content since 10.10.3
#        print book["websiteId"]
        if book["websiteId"]==1:
            url=chapter["url"]+"?UpdatedPage=aGlqYWNr"
            contentHtml = self.downloader.download(url)
#            print contentHtml
        else:
            contentHtml = self.downloader.download(chapter["url"])
        content = self.processor.process_chapter(contentHtml)
        content["title"] = chapter["title"].encode("gbk")
        filedir = filepath + str(chapter["bookId"]) + "/"
        if os.access(filedir, os.W_OK) == 0:
            os.makedirs(filedir)
        partFilename=str(chapter["bookId"]) + "/" + str(chapter["bookId"]) + "_" + str(chapter["id"]) + ".html"
        filename = filepath + partFilename

        picPlaceHolder=Utils.PIC_PLACE_HOLDER
        picString=Utils.PIC_STRING
        fileId=string.split(filename,".")[0]
        
        if content["links"] is not None and len(content["links"])>0:
            #this is actually just for qidian
            strContent=""
            i=1
            for link in content["links"]:
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :正在下载章节 <%s> 中的脚本%s" % (bookName,chapterName,str(i))))
                linkSource=self.downloader.download(link)
                #need to filter the qidian sign in the script text
                strContent+=self.processor.filter(linkSource)
                i+=1
        else:
            i=1
            strContent=content["string"]
            for pic in content["pics"]:
#                self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :正在下载章节 <%s> 中的图片%s" % (bookName,chapterName,str(i))))
                filetype=string.split(pic, ".")[-1]
                newPic=fileId+"_"+str(i)+"."+filetype
                picSource=self.downloader.download(pic)
                picFilename=str(chapter["bookId"]) + "_" + str(chapter["id"]) +"_"+str(i)+"."+filetype
                self.writer.write_to(newPic, picSource)
                s=string.replace(picString, picPlaceHolder, picFilename)
                i+=1
                strContent+=s
        content["string"]=strContent
#        result=string.replace(result, contentPlaceHolder, strContent)
        self.writer.write(filename, content)
#        self.emit(SIGNAL("show_status(QString)"), unicode("<<%s>> :章节下载完毕 <%s>" % (bookName,chapterName)))
        return partFilename
