#include <stdio.h>

/* Need for I18n */
#include <libintl.h>
#include <locale.h>
#include <glib.h>
#include "kernel/kernel.h"
#include "msa.h"
#include <gettext.h>


#define CONST_PROXY "proxy.karelia.ru"
#define CONST_PORT 81
#define _(String) gettext (String)

#define OSSO_SERVICE "ru.karelia.cs.mysocials"
#ifdef __ARMEL__
#define TABLET
#endif

xmlXPathObject* msa_xpath(char* req, xmlDocPtr doc);

#ifndef TEST
int main(int argc, char *argv[])
{

	//GConfClient* gclient;

	/* Initialise the locale stuff */
	/* Should be before gtk_init!!! */
	setlocale ( LC_ALL, "" );
	bindtextdomain ( GETTEXT_PACKAGE, LOCALEDIR );
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain ( GETTEXT_PACKAGE );

        g_debug(_("test"));
	/* Initialize GConf configuration system */
	/*gconf_init(argc, argv, NULL);

	GConfClient* gclient = gconf_client_get_default();
	gconf_client_add_dir(client,
		"/apps/metacity/general",
		GCONF_CLIENT_PRELOAD_NONE,
		NULL);*/

	//if (gtk_init_check(&argc, &argv) == FALSE) {
        //        g_debug("main gtkinit error");
       // } else {
//		g_debug("main gtkinit ok!");
//	}

        MSA_END = 1; // if msa_end == 0 then exit

        //gtk_init(&argc, &argv);

	
	/** init kernel **/
	if (kernel_initialization() == 1) {
		g_debug("msa: can't init kernel");
		return FAILURE;
	}	


	/** intit DB **/
	if (start_module(DB_ID, argc, argv) != 0) {
		g_debug("main: error start db!");
		return 1;	
	}

	/** init UI **/
	if (start_module(UI_ID, argc, argv) != 0) {
		g_debug("main: error start ui!");
		return 1;		
	}

#ifdef TABLET
	/* init osso */
	g_debug("osso initialize start");
	osso_context_t *osso;
	osso = osso_initialize(OSSO_SERVICE, "0.1", TRUE, NULL );
	g_debug("osso initialize end");

	/* init conic */
	if (start_connection() != 0) {
		g_debug("main: error start coonection!");
		return 1;		
	} 
#endif
	
#ifndef TABLET
    // get settings in from gconf
    GConfClient *client = gconf_client_get_default ();

    gchar* set_proxy = (gchar*)gconf_client_get_string(client, PATH_PROXY_HOST, NULL);
    gint set_port = (gint)gconf_client_get_int(client, PATH_PROXY_PORT, NULL);

    g_object_unref((gpointer)client);

    msa_set_driver_status(ON, set_proxy, set_port);
#endif
      gtk_main();
	
      while(MSA_END != 0) {
          g_usleep(G_USEC_PER_SEC * 1);
      }

      g_usleep(G_USEC_PER_SEC * 2);

      return 0;
}
#endif
void msa_end()
{
    g_debug(_("msa end porgram"));
    MSA_END = 0;
    return;
}
/**
 * @brief start module
 * @param id module
 * @param argc
 * @param argv
 * @return 0 or status error.
 */
static int start_module(const char* id, int argc, char *argv[])
{
    gpointer msa_data;
    gpointer value;
    msa_module_disp* target_module;
    msa_module_disp* target_kernel;
    msa_driver_info* drv;

    value = g_hash_table_lookup(table_mod, (gpointer)id);
      
    target_module = (msa_module_disp*)value;
    value = g_hash_table_lookup(table_mod, (gpointer)KERNEL_ID);
      
    target_kernel = (msa_module_disp*)value;
    value = (gpointer)target_kernel->msa_mod; 
    drv = (msa_driver_info*)list_drivers->data;
    
    if(target_module->msa_mod->module_start != NULL) {
        target_module->msa_mod->module_start(value, (gpointer)list_drivers, argc, argv);
		return 0;    
    }
	
    return 1;
}

/**
 * @brief create new connection
 * @return 0 or status error.
 */
static int start_connection()
{
    g_debug("start_cooncetion:START");
	
    /** try to connect libconic **/
    gboolean success = FALSE;

    /** Create connection object **/
    ConIcConnection* connection = con_ic_connection_new();

    /** Connect signal to receive connection events **/
    g_signal_connect(G_OBJECT(connection), "connection-event", 
                     G_CALLBACK(msa_connection_handler), NULL);

    /** Request connection and check for the result **/
    success = con_ic_connection_connect(connection, CON_IC_CONNECT_FLAG_NONE);
    if (!success) 
    {
        g_warning("Request for connection failed");
        return (-1);
    }
	
    g_debug("start_cooncetion:END");
    return 0;

}


static void msa_connection_handler(ConIcConnection *connection,
                                  ConIcConnectionEvent *event,
                                  gpointer user_data)
{
    g_debug("msa_connection_handler:START");

    ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
    ConIcConnectionError error;
    gchar* proxy;
    gint port;

    switch(status) {
        case CON_IC_STATUS_CONNECTED:
            g_debug("Hey, we are connected");			
			msa_get_conic_settings(connection, &proxy, &port);
			msa_set_driver_status(ON, proxy, port);			
                        g_debug("proxy = %s port = %d", proxy, port);
            break;

            case CON_IC_STATUS_DISCONNECTING:
                        g_debug("We are disconnecting...");
			msa_set_driver_status(OFF, NULL, NULL);	
            break;
		
		case CON_IC_STATUS_DISCONNECTED:
            g_debug("We are disconnecting...");
			msa_set_driver_status(OFF, NULL, NULL);	
            break;

            default:
                     g_debug("Unknown connection status received");
    }
	
	g_debug("msa_connection_handler:END");

}

static void msa_get_conic_settings(ConIcConnection* connection, gchar** proxy, gint* port)
{
	switch (con_ic_connection_get_proxy_mode(connection)) {
            case CON_IC_PROXY_MODE_NONE:
				g_debug("No proxies defined, it is direct connection");
				*proxy = NULL;
				*port = 0;
				break;

            case CON_IC_PROXY_MODE_MANUAL: 
				g_debug("connection is ok");				
				*proxy = con_ic_connection_get_proxy_host(connection, CON_IC_PROXY_PROTOCOL_HTTP);
				*port = con_ic_connection_get_proxy_port(connection, CON_IC_PROXY_PROTOCOL_HTTP);
				break;
	}

}

static void msa_set_driver_status(msa_module_status _status, gchar* proxy, gint port)
{
    GList* node;
    msa_driver_info* info;
    msa_module_disp* target_module;
    gpointer value;

	
    for (node = list_drivers; node != NULL; node = node->next) {
	
        info = (msa_driver_info*)node->data;
        info->proxy = proxy;
        info->port = port;
        info->status = _status;
        g_debug("!!!! info status %s %d", info->id, info->status);

        value = g_hash_table_lookup(table_mod, (gpointer)info->id);
        target_module = (msa_module_disp*)value;
      
        target_module->msa_mod->status = _status;

    }


}

static int init_event_manager()
{

    char* event_message = "<helloworld/>";    
    char* event_struct = g_strconcat("\
<TransitData type=\"signal\">\
<SourceID>", KERNEL_ID, "</SourceID>\
<TargetID>", HANDLER_ID, "</TargetID>\
<Content>\
<Signal id=\"event_message\">\
<StartTime>25</StartTime>\
<Action>set</Action>\
<RepeatTime>25</RepeatTime>\
<Content/>\
</Signal>\
</Content>\
</TransitData>", NULL);

    GList* list;
    msa_driver_info* info;

    xmlNodePtr node;
    xmlNodePtr node_root;
    xmlDocPtr doc;
    xmlDocPtr doc_root;

    xmlChar* doc_char;
    int size;    
    doc = xmlParseDoc(event_message);
        
    for (list = list_drivers; list != NULL; list = list->next) {

        info = (msa_driver_info*)list->data;       
        add_target(doc, info->id, 0);

    }  
    
    //xmlDocPtr(stdout,doc);    

    doc_root = xmlParseDoc(event_struct);
    node = xmlDocGetRootElement(doc);   

    xmlXPathObject* Obj = msa_xpath("//TransitData/Content/Signal/Content", doc_root);
    node_root = Obj->nodesetval->nodeTab[0];

    xmlAddChild(node_root, node);
    xmlDocDump(stdout, doc_root);
    

    xmlDocDumpMemory(doc_root, &doc_char, &size);    
    handler_put_data(doc_char);  

}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
xmlXPathObject* msa_xpath(char* req, xmlDocPtr doc)
{
	xmlXPathObject *Obj;
	xmlXPathContextPtr Ctx;
	Ctx = xmlXPathNewContext(doc);
	if (Ctx == NULL) {
		g_debug("msa_xpath: error wrong request format!");
		return NULL;	
	}
	Obj = xmlXPathEvalExpression(req, Ctx);
	xmlFree(Ctx);
	return Obj;

}

