/**
 * dispatcher_interface.c
 * 
 * This file is part of MSA program
 * 
 * Copyright (C) 2009 Burlak I.L.
 * 
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *#include <drivers/vkontakte/driver.h>
#include <drivers/vkontakte/vkontakte.h>
#include <drivers/vkontakte/parser.h>
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include "dispatcher.h"

static void start_thread(gpointer);
static void msa_disp_free(gpointer key, gpointer value, gpointer data);

/**
 * @brief interface programm function. Function send request in curent extern module.
 * @return 0 and send response to sender module, 
           or status error and info message to sender module.
 */
extern int msa_disp_send_request(xmlChar* target_id, xmlDocPtr msa_ui_request)
{
	g_debug("dispatcher send START! target id = %s", target_id);
    
    gpointer msa_data;
    msa_module_disp* target_module;
    gpointer value;

    /** if dispatcher inizialization **/
    if (msa_disp_status == DISP_OFF) {
        g_debug("disp:msa_disp_send_request: not init, stop!");
        return FAILURE;
    }

    /** get module from hash table on id **/
    value = g_hash_table_lookup(table_mod, (gpointer)target_id);
    target_module = (msa_module_disp*)value;
    
   
    if (target_module == NULL) {
        g_debug("disp:msa_disp_send_request: can't find driver.");
        return FAILURE;
    }

    if (target_module->msa_mod == NULL) {
        g_debug("disp:msa_disp_send_request: target modue is NULL");
        return FAILURE;
    }
 
    /** check target module **/
    if (target_module->msa_mod->status == ON ) {

        /** set target module is busy **/    
        target_module->msa_mod->status = BUSY;        

        /** create a new thread for sending request **/
        target_module->data = (gpointer)msa_ui_request;
        msa_data = (gpointer)target_module;
        g_thread_create((GThreadFunc)start_thread, msa_data, FALSE, NULL);
        return SUCCESS;

    } else {
        g_debug("disp:msa_disp_send_request: the module is not ready to work or is occupied!");
        return FAILURE;
    }

    return SUCCESS;
}

/**
 * @brief The stream which sends request and expects the answer from the external module
 */
static void start_thread(gpointer _data)
{
    g_debug("disp:start_thread: START");

    msa_module_disp* target_module;
    xmlDocPtr value = NULL;
    target_module = (msa_module_disp*)_data; 
    target_module->msa_mod->status = BUSY;

    if (target_module->msa_mod->send == NULL) {
        g_debug("disp:start_thread: ERROR func send if NULL");
        return;   
    }

    g_debug("%s",target_module->msa_mod->id);    
    msa_driver_info* info = msa_driver_info_get(target_module->msa_mod->id);
  

    if (target_module->msa_mod->send((xmlDocPtr)target_module->data, &value, info) == FAILURE) {
        g_debug("disp:start_thread: error when programm try send data to %s", target_module->msa_mod->name);
        return;
    }

    if (info != NULL) {       
        target_module->msa_mod->status = info->status;
        target_module->msa_mod->state = info->state;
        g_debug("SETTINGS status = %d, %d", info->status, target_module->msa_mod->status);                
    }
   
    if (value != NULL) {
        if (kernel_put_data(value) == FAILURE) {
            g_debug("disp:start_thread: error when i try kernel_put_data");
        }
    }
    else {
        g_debug("disp:start_thread: warrning response is NULL!");
    }

    /** if function end the driver on! **/
	target_module->msa_mod->status = ON;
    //xmlFreeDoc((xmlDocPtr)target_module->data);

    g_debug("disp:start_thread: END");
        
    return;
}

/** 
 * @brief get msa_driver_info from global GList list_drivers 
 * @param id driver 
 * @return msa_driver_inf or NULL if error.
 */
static msa_driver_info* msa_driver_info_get(gchar* id)
{
    GList* list;
    msa_driver_info* info;
    
    for (list = list_drivers; list != NULL; list = list->next)
    {    
        info = (msa_driver_info*)list->data;

        if (strcmp(info->id, id) == 0) {
            return info;        
        } 
    }

    return NULL;
}

/**  
*   @brief Function set or get settings external module   
*/
extern int msa_settings(xmlChar* target_id, xmlDocPtr request)
{
    gpointer msa_data;
    msa_module_disp* target_module;
    gpointer value;

    /** if dispatcher inizialization **/
    if (msa_disp_status == DISP_OFF) {
        g_debug("disp:msa_disp_send_request: not init, stop!");
        return FAILURE;
    }

    /** get module from hash table on id **/
    value = g_hash_table_lookup(table_mod, (gpointer)target_id);
    target_module = (msa_module_disp*)value;
    
   
    if (target_module == NULL) {
        g_debug("disp:msa_disp_send_request: can't find driver.");
        return FAILURE;
    }

    if (target_module->msa_mod == NULL) {
        g_debug("disp:msa_disp_send_request: target modue is NULL");
        return FAILURE;
    }

    /** check target module **/
    if (target_module->msa_mod->status != BROKEN ) {

        /** set target module is busy **/    
        target_module->msa_mod->status = BUSY;        

        /** create a new thread for sending request **/
        target_module->data = (gpointer)request;
        msa_data = (gpointer)target_module;
        g_thread_create((GThreadFunc)start_thread, msa_data, FALSE, NULL);
        return SUCCESS;

    } else {
        g_debug("disp:msa_disp_send_request: the module is not ready to work or is occupied!");
        return FAILURE;
    }

    return SUCCESS;
 

}

/**
 * @brief shutdown dispatcher and disconnect all modules
 * @return 0 or status error.
 */
extern int msa_module_shutdown() {

    g_debug("msa_shutdown START");
    g_hash_table_foreach(table_mod, msa_disp_free, NULL);
	g_debug("msa_shutdown END");
    return SUCCESS;

}

/**
 * @brief free curent module
 * @param key - id modules (no use in this function)
 * @param value - msa_module_disp struct
 * @param data - data (no use in this function)
 * @return 0 or status error.
 */
static void msa_disp_free(gpointer key, gpointer value, gpointer data) {

   msa_module_disp* mod;
   mod = (msa_module_disp*)value;
   
   if((mod->msa_mod->type != SYSTEM) && (mod->msa_mod->shutdown != NULL)) {
       mod->msa_mod->shutdown();
   }
  
   if (mod->handle != NULL) {
       dlclose(mod->handle);
   }
   g_free(mod->msa_mod);
   g_free(mod);

}

