/*
 * parser.c -  parser for driver vkontakte of MSA program
 * This file is part of MSA program
 *
 * Copyright (C) 2009 - Sergey Zakharov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#include "parser.h"

const char* gender[3] = {
    NO_MALE,
    FEMALE,
    MALE
};
const char* family_state[7] = {
    FAMILY_STATE_0,
    FAMILY_STATE_1, 
    FAMILY_STATE_2, 
    FAMILY_STATE_3, 
    FAMILY_STATE_4, 
    FAMILY_STATE_5, 
    FAMILY_STATE_6,  
};

const char* pol_view[9] = {
    POL_VIEW_0,
    POL_VIEW_1, 
    POL_VIEW_2, 
    POL_VIEW_3, 
    POL_VIEW_4, 
    POL_VIEW_5, 
    POL_VIEW_6, 
    POL_VIEW_7, 
    POL_VIEW_8 
};

/**
 * Parses json data, validate it
 *
 * @param json - data in json format
 * @return 0 - data valid,  -1, 1 - server response status  or -2, -3 if data not valid
 */
int check(char* json)
{
    g_debug("check START");

    struct json_object *buf = NULL;
    struct json_object *status = NULL;
    if(json != NULL) {
        status = json_tokener_parse(json);
        if(is_error(status))
            return -2;
        if(status != NULL) {
            if (json_object_get_type(status) == json_type_array) {
                return 0;
            }
            //Get server response status
            buf = json_object_object_get(status, "ok" );
            if(buf != NULL) {
                g_debug("read ok status");
                return json_object_get_int(buf);
            } else
                return 0;
        }
    }
    return -3;
}
/**
 * Parses image data, form xml 
 *
 * @param doc - response
 * @param data - image
 * @return 0 on success or 1 otherwise.
 */

int parser_image(xmlDocPtr doc, char* data, char* url)
{
    xmlNodePtr rootNode, childNode;
    rootNode = xmlDocGetRootElement(doc);     //response 
    if (rootNode != NULL) {
        rootNode = rootNode->children;           //params

        childNode = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_IMG, data);
        g_free(data);
        xmlSetProp(childNode, NAME, "Img");
        xmlSetProp(childNode, "uri", url);
        xmlAddChild(rootNode, childNode);
        xmlDocDump(stdout,doc);
        return 0;
    } else
        return 1;
}
/**
 * Parses json data, form xml profile
 *
 * @param doc - response
 * @param json - data in json format
 * @return 0 on success or 1 otherwise.
 */
int parser_profile(xmlDocPtr doc, char* json, char* remixmid)
{
    int i = 0, j = 0, buf_serialized = 0;
    char* file_name;
    struct json_object* buf, *profile, *ht, *edu,*edu_item;
    
    xmlNodePtr rootNode, childNode, node, node2;
    xmlAttrPtr attr;

    rootNode = xmlDocGetRootElement(doc);     //response 
    rootNode = rootNode->children;           //params

    profile = json_tokener_parse(json);
    
    if(profile != NULL){
        buf = json_object_object_get(profile, ID_KEY );
        if(buf == NULL)
            return 1;
        //PARSE FRIEND'S ID
        if (strcmp(remixmid, json_object_get_string(buf)) != 0 ) {
            xmlSetProp(rootNode, "id", g_strconcat(PREFIX, json_object_get_string(buf), NULL));
        }

        //PARSE FIRST NAME
        buf = json_object_object_get(profile, FIRST_NAME_KEY );
        if(buf == NULL)
            return 1;
        node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, json_object_get_string(buf));
        xmlSetProp(node, NAME, "FirstName");
        node = xmlAddChild(rootNode, node);
        //PARSE LAST NAME
        buf = json_object_object_get(profile, LAST_NAME_KEY );
        if(buf == NULL)
            return 1;
        node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, json_object_get_string(buf));
        xmlSetProp(node, NAME, "LastName");
        node = xmlAddChild(rootNode, node);

        //PARSE IMAGE
        buf = json_object_object_get(profile, IMG_KEY );
        if(buf == NULL)
            return 1;
        char* img;
        if(http_get(json_object_get_string(buf), info_proxy, info_port, NULL, &img) == 200) {
            node = xmlNewDocNode(doc, NULL,  BAD_CAST "img", img);
            xmlSetProp(node, NAME, "Img");
            xmlSetProp(node, "uri", json_object_get_string(buf));
            node = xmlAddChild(rootNode, node);
        }

        ht = json_object_object_get(profile, HABITATION_KEY);
        if(ht == NULL)
            return 1;
        //PARSE CITY
        childNode = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_STRUCT, NULL );
        xmlSetProp(childNode, NAME, "City");
        childNode = xmlAddChild(rootNode, childNode);

        buf = json_object_object_get(ht, CITY_ID_KEY);
        node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, json_object_get_string(buf) );
        xmlSetProp(node, NAME, "CityId");
        node = xmlAddChild(childNode, node);

        buf = json_object_object_get(ht, CITY_KEY);
        node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, json_object_get_string(buf) );
        xmlSetProp(node, NAME, "CityName");
        node = xmlAddChild(childNode, node);

        //PARSE COUNTRY
        childNode = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_STRUCT, NULL );
        xmlSetProp(childNode, NAME, "Country");
        childNode = xmlAddChild(rootNode, childNode);

        buf = json_object_object_get(ht, COUNTRY_ID_KEY);
        node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, json_object_get_string(buf) );
        xmlSetProp(node, NAME, "CountryId");
        node = xmlAddChild(childNode, node);

        buf = json_object_object_get(ht, COUNTRY_KEY);
        node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, json_object_get_string(buf) );
        xmlSetProp(node, NAME, "CountryName");
        node = xmlAddChild(childNode, node);	

        struct tm tm_date;

        buf = json_object_object_get(profile, BIRTH_DAY_KEY );
        tm_date.tm_mday = json_object_get_int(buf);

        buf = json_object_object_get(profile, BIRTH_MONTH_KEY);
        tm_date.tm_mon = json_object_get_int(buf) - 1;

        buf = json_object_object_get(profile, BIRTH_YEAR_KEY);
        tm_date.tm_year = json_object_get_int(buf) - 1900;

        char* date;
        date = malloc(sizeof(char)*11);
        strftime(date, 11, "%d.%m.%Y\0", &tm_date);

        node = xmlNewDocNode(doc, NULL, BAD_CAST "date", date);
        xmlSetProp(node, NAME, "Birthday");
        node = xmlAddChild(rootNode, node);

        //PARSE GENDER
        childNode = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_SELECT, NULL );
        xmlSetProp(childNode, NAME, "Gender");
        childNode = xmlAddChild(rootNode, childNode);

        buf = json_object_object_get(profile, MALE_KEY );
        int sx_serialized = json_object_get_int(buf);

        for (i = 0; i < 3; i++) {
            g_debug(gender[i]);
            node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, gender[i]);
            if (sx_serialized == i)
                xmlSetProp(node, "selected", "1");
            else
                xmlSetProp(node, "selected", "0");
            node = xmlAddChild(childNode, node);	
        }

        //PARSE FAMILY STATE
        childNode = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_SELECT, NULL );
        xmlSetProp(childNode, NAME, "FamilyState");
        childNode = xmlAddChild(rootNode, childNode);


        buf = json_object_object_get(profile, FAMILY_KEY );
        int family_serialized = json_object_get_int(buf);

        for (i = 0; i < 7; i++) {
            g_debug(family_state[i]);
            node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, family_state[i]);
            if (family_serialized == i)
                xmlSetProp(node, "selected", "1");
            else
                xmlSetProp(node, "selected", "0");
            node = xmlAddChild(childNode, node);	
        }

        //PARSE POLITICAL VIEW
        childNode = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_SELECT, NULL );
        xmlSetProp(childNode, NAME, "PoliticalView");
        childNode = xmlAddChild(rootNode, childNode);

        buf = json_object_object_get(profile, POL_VIEW_KEY );
        int pol_view_serialized = json_object_get_int(buf);

        for (i = 0; i < 9; i++) {
            g_debug("!!!%d", i);
            g_debug(pol_view[i]);
            node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, pol_view[i]);
            if (pol_view_serialized == i)
                xmlSetProp(node, "selected", "1");
            else
                xmlSetProp(node, "selected", "0");
            node = xmlAddChild(childNode, node);	
        }

        //PARSE EDUCATION
        childNode = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_ARRAY, NULL );
        xmlSetProp(childNode, NAME, "EducationList");
        childNode = xmlAddChild(rootNode, childNode);

        int length = 0;
        edu = json_object_object_get(profile, EDUCATION_KEY );
        if(edu != NULL){
        length=json_object_array_length(edu);

        for(i = 0; i < length; i++)
        {
            edu_item = json_object_array_get_idx(edu, i );
       
            buf = json_object_array_get_idx(edu_item, 2 );
            buf_serialized = json_object_get_int(buf);
            if (buf_serialized < 21 || buf_serialized == 100 ) {
                node = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRUCT, NULL );
                xmlSetProp(node, NAME, "Education");
                node = xmlAddChild(childNode, node);
                if (buf_serialized < 21) {
                    node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, "School" );
                    node2 = xmlAddChild(node, node2);
                } else { 
                    if (buf_serialized == 100) {
                        node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, "High school");
                        node2 = xmlAddChild(node, node2);
                    } 
                }
                xmlSetProp(node2, NAME,"Type");

                buf = json_object_array_get_idx(edu_item, 3 );		 
                node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, BAD_CAST json_object_get_string(buf));
                node2 = xmlAddChild(node, node2);
                xmlSetProp(node2, NAME, "Name");

                buf = json_object_array_get_idx(edu_item, 4 );
                node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, json_object_get_string(buf));
                node2 = xmlAddChild(node, node2);
                xmlSetProp(node2, NAME, "DateComplete");
            }
        }
	}
        return 0;
    } else 
        return 1;
    
    
 }

/**
 * Parses json data, form xml friends list
 *
 * @param doc - response
 * @param json - data in json format
 * @return number of friends
 */
int parser_friends(char *json, xmlDocPtr doc)
{
    int i=0;
    int length = 0;
    struct json_object *friend, *friends, *id, *name, *img, *status;
    char* file_name;
    char** friend_name;
    char* friend_surname;
    xmlNodePtr rootNode, childNode, node,node2;
    xmlAttrPtr attr;
    
    rootNode = xmlDocGetRootElement(doc);     //response
    if(rootNode == NULL)
        return 0;   
    rootNode = rootNode->children;           //params
    if(rootNode == NULL)
        return 0;
    childNode = rootNode->children;          //array

    if (childNode == NULL) {
        node = xmlNewDocNode(doc, NULL, TYPE_ARRAY,  NULL);
        childNode = xmlAddChild(rootNode, node);
        xmlSetProp(childNode, NAME, "contactList");
        xmlSetProp(childNode, "from", "0");
        xmlSetProp(childNode, "to", "0" );
    }

    friends = json_tokener_parse(json);
    length = json_object_array_length(friends);
    for(i = 0; i < length; i++) {
        friend = json_object_array_get_idx(friends, i );
        
        if (friend == NULL) {
            length = i;
            break;
            //xmlSetProp(childNode, "to", g_strdup_printf("%d", i + atoi(xmlGetProp(childNode,"to")) ) );
           //return i;
        }
        id = json_object_array_get_idx(friend, 0 );
        if (id == NULL) {
            length = i;
            break;
        }
        node = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_STRUCT, NULL );
        xmlSetProp(node, NAME, "contact");
        xmlSetProp(node, "id", g_strconcat(PREFIX, json_object_get_string(id), NULL));
        node = xmlAddChild(childNode, node);

        name = json_object_array_get_idx(friend, 1 );
        if(name == NULL){
            xmlUnlinkNode(node);
            length = i;
            break;
        }
        
        friend_name = g_strsplit(json_object_get_string(name), " ",2);
        if( friend_name[1] == NULL)
            friend_surname = strdup(" ");
        else
            friend_surname = strdup(friend_name[1]);
        node2 = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_STRING,
                              g_strconcat(friend_surname," ",strdup(friend_name[0]),NULL));
        xmlSetProp(node2, NAME, "FriendName");
        node2 = xmlAddChild(node, node2);
        g_strfreev (friend_name);

        status = json_object_array_get_idx(friend, 3 );
        if(status == NULL){
            xmlUnlinkNode(node);
            length = i;
            break;
        }	
        node2 = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_STRING, json_object_get_string(status));
        xmlSetProp(node2, NAME, "FriendStatus");
        node2 = xmlAddChild(node, node2);


        img = json_object_array_get_idx(friend, 2 );
        if(img == NULL){
            xmlUnlinkNode(node);
            length = i;
            break;
        }
	
        g_debug("IMG=%s",json_object_get_string(img));

        node2 = xmlNewDocNode(doc, NULL,  BAD_CAST "img", NULL);
        xmlSetProp(node2, NAME, "FriendImg");
        if (strcmp(json_object_get_string(img),"0") != 0) {
            //xmlSetProp(node2, "uri", "http://kappa.cs.karelia.ru/~szaharov/tmp/ava.jpg");
            xmlSetProp(node2, "uri", json_object_get_string(img));
        }
        node2 = xmlAddChild(node, node2);
    }
    xmlSetProp(childNode, "to", g_strdup_printf("%d", length + atoi(xmlGetProp(childNode,"to")) ) );
    return length;
}

/**
 * Parses json data, form xml list of messages
 * @param doc - response
 * @param json - data in json format
 * @return number of messages
 */
int parser_messages(char *json, xmlDocPtr doc)
{
    g_debug("parser_messages START");
    int i = 0;
    int length = 0;
    struct json_object *message, *messages, *id, *sender, *time, *text, *status;
    
    xmlNodePtr rootNode, childNode, node,node2;
    xmlAttrPtr attr;

    rootNode = xmlDocGetRootElement(doc);     //response 
    rootNode = rootNode->children;            //params
    childNode = rootNode->children;           //array

    if (childNode == NULL) {
        node = xmlNewDocNode(doc, NULL, TYPE_ARRAY,  NULL);
        childNode = xmlAddChild(rootNode, node);
        xmlSetProp(childNode, NAME, "messagetList");
        xmlSetProp(childNode, "from", "0");
        xmlSetProp(childNode, "to", "0" );
    }

    messages = json_tokener_parse(json);
    messages = json_object_object_get(messages,"d");
    length = json_object_array_length(messages);
    g_debug("Start parse");
    for(i = 0; i < length; i++) {

        message = json_object_array_get_idx(messages, i );

        if (message == NULL) {
            xmlSetProp(childNode, "to", g_strdup_printf("%d", i + atoi(xmlGetProp(childNode,"to")) ) );
            return i;
        }

        g_debug("parse id_message");
        id = json_object_array_get_idx(message, 0);
        node = xmlNewDocNode(doc, NULL,  BAD_CAST TYPE_STRUCT, NULL );
        xmlSetProp(node, NAME, "message");
        if(id == NULL){
            break;
        }
        xmlSetProp(node, "id", g_strconcat(PREFIX, json_object_get_string(id), NULL));
        node = xmlAddChild(childNode, node);
	
        sender = json_object_array_get_idx(message, 3);
        if(sender == NULL)
            break;
        
        id = json_object_array_get_idx(sender, 0 );
        if(id == NULL)
            break;
        node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, g_strconcat(PREFIX, json_object_get_string(id), NULL));
        xmlSetProp(node2, NAME, "SenderId");
        node2 = xmlAddChild(node, node2);

        char** name_list;
        char* tmp_str;
        id = json_object_array_get_idx(sender, 1 );
        //if(id == NULL)
           // break;
        if (json_object_get_string(id) != NULL) {
            name_list = g_strsplit(json_object_get_string(id), "\t", 2);
	    tmp_str = g_strconcat(name_list[0], " ", name_list[1], NULL);
            node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, tmp_str);
	    g_free(tmp_str);
        } else {
                node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, NULL);
        }
        xmlSetProp(node2, NAME, "SenderName");
        node2 = xmlAddChild(node, node2);

        sender = json_object_array_get_idx(message, 4);
        if(sender == NULL)
             break;
        id = json_object_array_get_idx(sender, 0 );
        if(id == NULL)
            break;
        node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, g_strconcat(PREFIX, json_object_get_string(id), NULL));
        xmlSetProp(node2, NAME, "RecipientId");
        node2 = xmlAddChild(node, node2);

        id = json_object_array_get_idx(sender, 1 );
        //if(id == NULL)
            //break;
        if (json_object_get_string(id) != NULL) {
            name_list = g_strsplit(json_object_get_string(id), "\t", 2);
            node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, g_strconcat(name_list[0], " ", name_list[1], NULL));
        } else {
                node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, NULL);
        }
        xmlSetProp(node2, NAME, "RecipientName");
        node2 = xmlAddChild(node, node2);
        g_strfreev(name_list);

        g_debug("parse_time");
        time = json_object_array_get_idx(message,1);
        if(time == NULL)
            break;
        unsigned long int t;
        t = json_object_get_int(time);

        node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, g_strdup_printf("%d",t));
        xmlSetProp(node2, NAME, "Time");
        node2 = xmlAddChild(node, node2);

        g_debug("parse text");
        text = json_object_array_get_idx(message,2);
        if(text == NULL)
            break;
        char* mess_text;
        char* tmp;
        mess_text = json_object_get_string(text);
        while((tmp = strstr(mess_text,"<br>"))!=NULL)
        {
            int k;
            for(k=0;k<3;k++)
                *(tmp+k)=' ';
            *(tmp+k)='\n';
        }

        char* temp;
        char** list;

        list = g_strsplit(mess_text,"\"",3);
        temp = g_strdup(list[1]);
        g_strfreev (list);

        node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, temp);
        xmlSetProp(node2, NAME, "Text");
        node2 = xmlAddChild(node, node2);

        g_debug("parse read_status");
        status = json_object_array_get_idx(message,5);
        node2 = xmlNewDocNode(doc, NULL, BAD_CAST TYPE_STRING, json_object_get_string(status));
        xmlSetProp(node2, NAME, "Status");
        node2 = xmlAddChild(node, node2);
    }
    if(i != length){
        xmlUnlinkNode(node);
        xmlFreeNode(node);
        length = i;
    }
    xmlSetProp(childNode, "to", g_strdup_printf("%d", length + atoi(xmlGetProp(childNode,"to")) ) );
    g_debug("parser_messages END");
return length;
}

/**
 * Parses json data, form xml
 * @param json - data in json format
 * @return number of new messages
 */
int parser_new_messages(char* json)
{
#ifndef TEST
    g_print("TEST NOT DEFINE FROM MESSAGES\n");
#else
    g_print("TEST DEFINE FROM MESSAGES\n"); 
#endif
    struct json_object *buf = NULL;
    struct json_object *num;
    if(json != NULL) {
        buf = json_tokener_parse(json);

            num = json_object_object_get(buf, "nm" );
            if(num != NULL) {
                return json_object_get_int(num);
            } else
                return 0;
        }
}
   
