/*
 * handler_test_func.h - interface for handler test functions.
 * This file is part of MAS program.
 *
 * Copyright (C) 2009 - Alexander A. Lomov.
 *
 * MAS program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MAS program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MAS program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
 
/* Define signal */
typedef struct signal
{
    xmlChar* id;
    xmlChar* source_id;
    GTimeVal time;
    glong start_time;
    glong repeat_time;
    xmlDocPtr data;
} signal_data;

/* Actions for signal */
typedef enum actions
{
    NOT_SET,
    SET_SIGNAL,
    REMOVE_SIGNAL
} action_type;

 
xmlDocPtr create_xml_doc_with_root_call(xmlNodePtr root_node);
xmlDocPtr get_inner_content_call(const xmlDocPtr doc, xmlChar* node_name);
signal_data* convert_to_handler_format_call(xmlDocPtr doc, action_type* action);
