/*
 * db_config_manager.h - interface file for config manager.
 * This file is part of Maemo-DB project
 *
 * Copyright (C) 2009 - Alexander A. Lomov.
 *
 * Maemo-DB project is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Maemo-DB project is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Maemo-DB project; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
 
#ifndef __DB_CONFIG_MANAGER_H__
#define __DB_CONFIG_MANAGER_H__

#include "db.h"


/* load, close and save config file functions */ 
gint cm_load_config(const gchar* file_path);
gint cm_save_config_to_file(const gchar* file_path);
gint cm_save_config();
void cm_close_config();


/* db config functions */ 
gchar* cm_get_db_path_by_name_or_default(const gchar* db_name);
gchar* cm_get_db_path_by_name(const gchar* db_name);
gchar* cm_get_default_db_path();
void cm_set_db_path_by_name(const gchar* db_name, const gchar* db_path);

gchar* cm_get_db_config_key(const gchar* key_name);
gchar* cm_get_profiles_file_path();

gchar** cm_get_all_schemas_names();
gchar** cm_get_all_binary_tags_names();


/* xslt config parameters functions */
gchar* cm_get_xslt_path_key(const gchar* schema_name);
gchar* cm_get_revers_xslt_path_key(const gchar* schema_name);


/* different config function for schema */
gchar** cm_get_unique_columns_keys(const gchar* schema_name);
gchar* cm_get_namespaces_key(const gchar* schema_name);


/* ID config parameters functions */
gchar* cm_get_table_id_path_key(const gchar* schema_name);
gchar* cm_get_table_id_name_key(const gchar* schema_name);
gchar* cm_get_table_max_id_path_key(const gchar* schema_name);
gchar* cm_get_table_id_ns_key(const gchar* schema_name);
gchar* cm_get_table_id_ns_prefix_key(const gchar* schema_schema);


/* Links config functions */
//gint* cm_get_links_actions(const gchar* schema_name, const gchar* linked_schema_name); // Not use now
gchar** cm_get_links_names(const gchar* schema_name);
gchar** cm_get_revers_links_names(const gchar* schema_name);
gchar** cm_get_links(const gchar* schema_name, const gchar* linked_schema_name);
gchar** cm_get_keys(const gchar* schema_name, const gchar* linked_schema_name);

#endif /* __DB_CONFIG_MANAGER_H__ */

