#include "uiapplicationsettings.h"
#include "ui_uiapplicationsettings.h"

#include <QFileDialog>
#include <QMessageBox>

UIApplicationSettings::UIApplicationSettings(ServiceMgr *sm, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::UIApplicationSettings)
{
    ui->setupUi(this);
    this->sm = sm;

    ui->cbRotateWindow->setChecked(this->sm->settings->value(SETTINGS_AUTOROTATE).toBool());
    ui->cbMultiPanel->setChecked(this->sm->settings->value(SETTINGS_MULTIPANEL).toBool());
    ui->fileSelectField->setText(this->sm->settings->value(SETTINGS_ALBUM_DIRECTORY).toString());
    ui->cbGroupFeeds->setChecked(this->sm->settings->value(SETTINGS_GROUP_FEEDS).toBool());

    connect(ui->fileSelectButton, SIGNAL(clicked()), this, SLOT(showFileDialog()));
}

UIApplicationSettings::~UIApplicationSettings()
{
    delete ui;
}

void UIApplicationSettings::on_buttonBox_accepted()
{
    this->sm->settings->setValue(SETTINGS_AUTOROTATE, ui->cbRotateWindow->isChecked());
    this->sm->settings->setValue(SETTINGS_MULTIPANEL, ui->cbMultiPanel->isChecked());
    this->sm->settings->setValue(SETTINGS_ALBUM_DIRECTORY, ui->fileSelectField->text());
    this->sm->settings->setValue(SETTINGS_GROUP_FEEDS, ui->cbGroupFeeds->isChecked());
    emit updateSettings();
}

void UIApplicationSettings::on_btnClearCache_clicked()
{
    this->sm->clearCache();
    this->on_buttonBox_accepted();
}

void UIApplicationSettings::showFileDialog()
{
    QString dir = QFileDialog::getExistingDirectory(this, tr("Album directory"));
    if (!dir.isEmpty()) {
        QFileInfo dirInfo(dir);
        if (dirInfo.isWritable() && dirInfo.isExecutable())
            ui->fileSelectField->setText(dir);
        else
            QMessageBox::warning(this, tr("Wrong directory"), tr("This directory cannot be used to save photos"));
    }
}
