#ifdef ENABLE_NOTIFY
#include <libnotify/notify.h>
#endif

#include "mainwindow.h"

#include <QLibraryInfo>
#include <QtGui/QApplication>
#include <QObject>
#include <QTranslator>
#include <QtSingleApplication>

int main(int argc, char *argv[])
{
    // register required types for inter-thread communications
    QtSingleApplication app(argc, argv);

    if (app.isRunning())
        return 0;

    app.setApplicationName(APP_NAME);
    app.setOrganizationName("PetrSU");
    app.setOrganizationDomain("cs.karelia.ru");

    QString locale = QLocale::system().name();
    QTranslator translator;
    translator.load(QString(APP_NAME) + "_" + locale,
        DATAPREFIX"/qt4/translations/");
    app.installTranslator(&translator);

    QTranslator commontr;
    commontr.load(QString("mysocials_core") + "_" + locale,
        DATAPREFIX"/qt4/translations");
    app.installTranslator(&commontr);

    QTranslator widgettr;
    widgettr.load(QString("msaqtwidgets") + "_" + locale,
        DATAPREFIX"/qt4/translations");
    app.installTranslator(&widgettr);

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(),
                      QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);

    Q_INIT_RESOURCE(mysocials_res);

#ifdef ENABLE_NOTIFY
    // init libnotify library
    notify_init(APP_NAME);
#endif

    // Style sheet
    QString styleName = "default";
#ifdef Q_WS_MAEMO_5
    styleName = "maemo5";
#endif

#ifdef  MEEGO_EDITION_HARMATTAN
    styleName = "harmattan";
#endif

    QFile styleFile(":/res/qss/" + styleName + ".qss");
    styleFile.open(QFile::ReadOnly);
    app.setStyleSheet(QString::fromLatin1(styleFile.readAll()));
    styleFile.close();

    MainWindow w;
    app.setActivationWindow(&w);

    w.showMaximized();
    return app.exec();
}
