%define origname mysocials-ui

%define revision 3

Name:       mysocials
Summary:    MySocials client to access services of social networks
Version:    1.0.3
Release:    1
Group:      Productivity/Networking/Other
License:    GPL
URL:         http://oss.fruct.org/wiki/MySocials
Source0:    %{origname}_%{version}-%{revision}.tar.gz
BuildRoot:  %{_tmppath}/%{origname}-root
 
%if 0%{?suse_version}  
BuildRequires:  libqt4-devel >= 4.6.0  
BuildRequires:  libQtWebKit-devel
Requires:       libQtWebKit4
Requires:       libqt4 >= 4.6.0
%endif  

%if 0%{?rhel_version} || 0%{?centos_version}
BuildRequires:  qt4-devel >= 4.6.0
BuildRequires:  gcc-c++
Requires:       qt4 >= 4.6.0
%endif

%if 0%{?mdkversion}
BuildRequires:  qt4-devel >= 4.6.0
BuildRequires:  gcc-c++
Requires:       qt4-common >= 4.6.0
%endif

%if 0%{?fedora_version}
BuildRequires:  qt4-devel
BuildRequires:  qt4-x11
BuildRequires:  gcc-c++
Requires:       qt4
%if 0%{?fedora_version} < 14
Requires:       qt4-x11
%else
Requires:       qt4-webkit
BuildRequires:  qt-webkit-devel
%endif
%endif

%if "0%{?meego_version}" != "0"
BuildRequires:  libqt-devel
BuildRequires:  libqtwebkit-devel
Requires:       qt
%endif

BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(libxml-2.0) >= 2.6.32

BuildRequires:  mysocials-core-devel >= 1.2.0
Requires:       mysocials-core >= 1.2.0
Requires:       libmsavk0 >= 0.4.8
Requires:       libmsafl0 >= 0.1.5
Requires:       libmsamm0 >= 0.1.4

AutoReqProv:    1
#Requires(post):
 
%description
MySocials is a client to access services of social networks from desktop or mobile platform.
The MySocials core provides a Qt library to easy access to MySocials project functions.
The data from requests store into cache and can be requested iteratively.
 
%prep
%setup -q -n %{origname}-%{version}

%build
# >> build pre
export PATH=/usr/lib/qt4/bin:$PATH

%if 0%{?mdkversion} > 2006  
export PATH=/usr/lib/qt4/bin:$PATH  
export QTDIR=%{_prefix}/lib/qt4/  
%endif  

%if 0%{?fedora_version} || 0%{?centos_version}
qmake-qt4  PREFIX=%{_prefix}
%else
qmake PREFIX=%{_prefix}
%endif

%__make

%install
export INSTALL_ROOT=%{buildroot} 
  
%if 0%{?mdkversion} || 0%{?fedora_version} < 13
make install
%else
%make_install
%endif
 
%post 
/sbin/ldconfig
 
%postun 
/sbin/ldconfig
 
%files
%defattr(-,root,root,-)
%{_bindir}/*
%{_datadir}/qt4/translations/*.qm
%{_datadir}/applications/*
%dir %{_datadir}/icons/hicolor
%dir %{_datadir}/icons/hicolor/26x26
%dir %{_datadir}/icons/hicolor/26x26/apps
%{_datadir}/icons/hicolor/26x26/apps/*
%dir %{_datadir}/icons/hicolor/40x40
%dir %{_datadir}/icons/hicolor/40x40/apps
%{_datadir}/icons/hicolor/40x40/apps/*
%dir %{_datadir}/icons/hicolor/64x64
%dir %{_datadir}/icons/hicolor/64x64/apps
%{_datadir}/icons/hicolor/64x64/apps/*
%dir %{_datadir}/pixmaps
%{_datadir}/pixmaps/*
%dir %{_datadir}/doc/mysocials
%{_datadir}/doc/mysocials/*

