#ifdef ENABLE_NOTIFY
#include <libnotify/notify.h>
#endif

#include "ui/vkgallery.h"

#include <QApplication>
#include <QObject>
#include <QTranslator>
#include <QLibraryInfo>

int main(int argc, char *argv[])
{
    // register required types for inter-thread communications
    QApplication a(argc, argv);
    a.setApplicationName(APP_NAME);
    a.setOrganizationName("PetrSU");
    a.setOrganizationDomain("cs.karelia.ru");

    QString locale = QLocale::system().name();
    QTranslator translator;
    translator.load(QString(APP_NAME) + "_" + locale,
	DATAPREFIX"/qt4/translations/");
    a.installTranslator(&translator);

    QTranslator commontr;
    commontr.load(QString("mysocials_core") + "_" + locale,
	DATAPREFIX"/qt4/translations/");
    a.installTranslator(&commontr);

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(),
                      QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    a.installTranslator(&qtTranslator);

#ifdef ENABLE_NOTIFY
    /* Init libnotify library */
    notify_init(APP_NAME);
#endif

    // Style sheet
#ifdef Q_WS_MAEMO_5
    QString styleName = "maemo5";
#else
    QString styleName = "default";
#endif

    QFile styleFile(":/res/qss/" + styleName + ".qss");
    styleFile.open(QFile::ReadOnly);
    a.setStyleSheet(QString::fromLatin1(styleFile.readAll()));
    styleFile.close();

    VKGallery w;
    w.showMaximized();
    return a.exec();
}
