#include "item.h"
 
        item::item(QObject *parent)
	{
 
	}
 
        void item::paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const{
		QRect r = option.rect;
 
		//Color: #C4C4C4
		QPen linePen(QColor::fromRgb(211,211,211), 1, Qt::SolidLine);
 
		//Color: #005A83
		QPen lineMarkedPen(QColor::fromRgb(0,90,131), 1, Qt::SolidLine);
 
		//Color: #333
                QPen fontPen(QColor::fromRgb(255,255,255), 1, Qt::SolidLine);
 
		//Color: #fff
                QPen fontMarkedPen(Qt::white, 1, Qt::SolidLine);
 
		if(option.state & QStyle::State_Selected){
			QLinearGradient gradientSelected(r.left(),r.top(),r.left(),r.height()+r.top());
                        gradientSelected.setColorAt(0.0, QColor::fromRgb(0,120,174));
                        gradientSelected.setColorAt(1.0, QColor::fromRgb(119,213,247));

                        painter->setBrush(gradientSelected);
                        painter->setPen(Qt::transparent);
                        painter->drawRect(r);
 
			//BORDER
                        /*painter->setPen(lineMarkedPen);
			painter->drawLine(r.topLeft(),r.topRight());
			painter->drawLine(r.topRight(),r.bottomRight());
			painter->drawLine(r.bottomLeft(),r.bottomRight());
			painter->drawLine(r.topLeft(),r.bottomLeft());
 
			painter->setPen(fontMarkedPen);
                        */
 
		} else {
			//BACKGROUND
                        //ALTERNATING COLORS
                        /*painter->setBrush( (index.row() % 2) ? Qt::white : QColor(252,252,252) );
                        painter->drawRect(r);
 
			//BORDER
			painter->setPen(linePen);
			painter->drawLine(r.topLeft(),r.topRight());
			painter->drawLine(r.topRight(),r.bottomRight());
			painter->drawLine(r.bottomLeft(),r.bottomRight());
			painter->drawLine(r.topLeft(),r.bottomLeft());
 
			painter->setPen(fontPen);
                        */
		}
                painter->setPen(fontMarkedPen);
		//GET TITLE, DESCRIPTION AND ICON
		QIcon ic = QIcon(qvariant_cast<QPixmap>(index.data(Qt::DecorationRole)));
		QString title = index.data(Qt::DisplayRole).toString();
		QString description = index.data(Qt::UserRole + 1).toString();
 
		int imageSpace = 10;
		if (!ic.isNull()) {
			//ICON
                        r = option.rect.adjusted(5, 10, -10, -10);
                        ic.paint(painter, r, Qt::AlignVCenter|Qt::AlignCenter);
                        imageSpace = 80;
		}
 
		//TITLE
                r = option.rect.adjusted(imageSpace, 0, 0, -30);
                //painter->setFont( QFont( "Lucida Grande", 6, QFont::Normal ) );
		painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignBottom|Qt::AlignLeft, title, &r);
 
		//DESCRIPTION
                r = option.rect.adjusted(imageSpace, 30, 0, 0);
                //TODO FIX FONT SIZE
                //painter->setFont( QFont(QApplication::font(), 50, QFont::Normal ) );
                painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignLeft, description, &r);
	}
 
        QSize item::sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const{
		return QSize(200, 60); // very dumb value
	}
 
        item::~item()
	{
 
	}
