#ifndef VKGALLERY_H
#define VKGALLERY_H

#include <QMainWindow>
#include <QDebug>
#include <QPushButton>
#include <QListWidgetItem>
#include <QList>
#include <QLabel>
#include <QRadioButton>
#include <QShortcut>
#include "widgets/uiaccountsettings.h"
#include "widgets/uinetworksettings.h"
#include "ui/uiapplicationsettings.h"
#include "widgets/uihelp.h"
#include "ui_vkgallery.h"
//#include "item.h"
#include "widgets/qimageviewer.h"
#include <servicemgr.h>
#include <panels/imagebrowserpanel.h>

#ifdef Q_WS_MAEMO_5
    #include "utils/fullscreenexitbutton.h"
#endif

#ifdef TARGET
    #define APP_NAME TARGET
#else
    #define APP_NAME "mysocials-gallery"
#endif

namespace Ui {
    class VKGallery;
}

class VKGallery : public QMainWindow {
    Q_OBJECT
public:
    VKGallery(QWidget *parent = 0);
    ~VKGallery();

protected:
    void changeEvent(QEvent *e);

private:
    QFont usedFont;

    Ui::VKGallery *ui;

    ImageBrowserPanel *panel;

    void init();
    //void ownrChanged();
    void createMenus();
#ifdef Q_WS_MAEMO_5
    FullScreenExitButton *fullScreenButton;
#endif
    ServiceMgr *sm;

private slots:
    void actionAccSettings_toggled();
    void actionNetSettings_toggled();
    void actionAppSettings_toggled();

    void actionFull_screen_toggled();

    void help();
    void about();

    void settingsUpdated();
    void openImage(Photo photo);

    void gotErrorMsg(QString errorMsg, QTransport::Action acc);
};

#endif // VKGALLERY_H
