#include "qmousetrackingview.h"

QMouseTrackingView::QMouseTrackingView(QGraphicsScene *scene, QWidget *parent) :
    QGraphicsView(scene, parent)
{
}

void QMouseTrackingView::reset()
{
    this->mousePoints.clear();
}

void QMouseTrackingView::mousePressEvent(QMouseEvent * event)
{
    if (event->button() == Qt::LeftButton) {
        this->mousePoints.clear();
        this->mousePoints.append(event->pos());
        qDebug() << "Pressed at " << event->pos();
    }
}

void QMouseTrackingView::mouseMoveEvent(QMouseEvent * event)
{
    if (!(event->buttons() & Qt::LeftButton))
        return;

    if (this->mousePoints.length() > 0) {
        this->mousePoints.append(event->pos());
        if (this->mousePoints.length() > NUM_MOVE_EVENTS)
            this->getDirection();
    }
}

void QMouseTrackingView::mouseDoubleClickEvent(QMouseEvent *event)
{
    emit this->mouseDoubleClick();
}

void QMouseTrackingView::getDirection()
{
    Qt::ArrowType direction;
    if ((this->mousePoints.at(0) - this->mousePoints.at(this->mousePoints.length() - 1)).manhattanLength()
        < QApplication::startDragDistance())
        return;

    if (this->mousePoints.at(0).x() - this->mousePoints.at(this->mousePoints.length() - 1).x() > 0)
        direction = Qt::RightArrow;
    else
        direction = Qt::LeftArrow;
    this->mousePoints.clear();
    emit this->mouseDragged(direction);
}
