#ifndef QIMAGEVIEWER_H
#define QIMAGEVIEWER_H

#include <QMainWindow>
#include <QGraphicsView>
#include <QGraphicsScene>
#include <QGraphicsPixmapItem>
#include <QMessageBox>
#include <QDebug>
#include <QMouseEvent>
#include <QLibrary>

#include "servicemgr.h"
#include "photo.h"
#include "qmousetrackingview.h"

#ifdef Q_WS_MAEMO_5
#include "fullscreenexitbutton.h"
#include <libosso.h>
#endif

#ifdef Q_WS_MAEMO_5
#define WINDOW_TITLE "Gallery"
#else
#define WINDOW_TITLE "MySocials Gallery Image Viewer"
#endif

class QImageViewer : public QMainWindow
{
    Q_OBJECT
public:
    explicit QImageViewer(QWidget *parent = 0);
    ~QImageViewer();

    /**
     * @brief This function set ups photo for showing and open window
     *
     * @param image initial photo for showing
    */
    void loadImage(ServiceMgr *sm, Photo image);

private:
    /**
     * @brief Shows selected images
    */
    void showImage(bool isNeedCompare);

    // start photo for slide showing
    Photo currentPhoto;

    // list of photos that are showing
    PhotoList list;

    // service manager
    ServiceMgr *sm;

    QMouseTrackingView *view;
    QGraphicsScene *scene;

    // container for photos
    QGraphicsPixmapItem *pixmapItem;

    // container for text messages
    QGraphicsTextItem *processItem;

    // the current size of window
    QSize windowSize;

    // index of current showing image
    int currentImageIndex;

#ifdef Q_WS_MAEMO_5
    FullScreenExitButton *fullScreenButton;
    osso_context_t *osso;
#endif

signals:

public slots:

    void imageListUpdate(QString accountId, QString friendId, QString albumId, PhotoList list, bool isLastUpdate);
    void close();
    void resizeEvent(QResizeEvent *);
    void moveImage(Qt::ArrowType);
    void on_actionFull_screen_toggled();
};

#endif // QIMAGEVIEWER_H
