#ifndef FRIEND_H
#define FRIEND_H

#include <QObject>
#include <QString>
#include <QDomDocument>
#include <QFile>
#include <QDebug>
#include <QMetaType>
#include "album.h"
#include "utils.h"

// the suffix of file with list of albums
#define FILE_ALBUMS_DATA "/albums_%1.xml"
#define NODE_ALBUMS_ROOT "albums"


#define NODE_FRIEND_ROOT "friend"
#define NODE_FRIEND_ID "id"
#define NODE_FRIEND_NAME "name"
#define NODE_FRIEND_ICON "icon"
#define NODE_FRIEND_ICON_URL "iconUrl"

class Friend : public QObject
{
    Q_OBJECT

public:
    Friend();
    Friend(const Friend&);
    ~Friend();

    // friend ID from service
    QString id;

    // friend name
    QString name;

    // path to friend avatar image
    QString icon;

    // url of friend avatar image
    QString icon_url;

    // true if friend is online, otherwise false (not stored in cache)
    bool online;

    // the name of account of this friend (not stored in cache)
    QString accountId;

    // load album list from cache file.
    AlbumList getAlbumList();

    // set album list and store it to cache file.
    static void setAlbumList(AlbumList list, QString accountId, QString friendId);


    // store friends data to XML format
    static QDomElement toQDomElement(QDomDocument doc, Friend src);

    // load friend from XML struct
    static Friend fromQDomElement(QDomElement fr, QString accountId);

    Friend& operator=(const Friend&);

    static void copyData(Friend *dst, const Friend *src);
};

typedef QList<Friend> FriendList;

Q_DECLARE_METATYPE(Friend)
Q_DECLARE_METATYPE(FriendList)

#endif // FRIEND_H
