#include "album.h"

Album::Album()
{
}

Album::Album(const Album &src) : QObject(0)
{
    this->accountId = src.accountId;
    this->albumId = src.albumId;
    this->description = src.description;
    this->icon = src.icon;
    this->icon_url = src.icon_url;
    this->ownerId = src.ownerId;
    this->size = src.size;
    this->time_create = src.time_create;
    this->time_update = src.time_update;
    this->title = src.title;
}

Album::~Album()
{
}

QDomElement Album::toQDomElement(QDomDocument doc) {
    QDomElement ret = doc.createElement(NODE_ALBUM_ROOT);

    // ID
    QDomElement node = doc.createElement(NODE_ALBUM_ID);
    QDomText t = doc.createTextNode(this->albumId);
    ret.appendChild(node);
    node.appendChild(t);

    // Name
    node = doc.createElement(NODE_ALBUM_TITLE);
    t = doc.createTextNode(this->title);
    ret.appendChild(node);
    node.appendChild(t);

    // description
    node = doc.createElement(NODE_ALBUM_DESCRIPTION);
    t = doc.createTextNode(this->description);
    ret.appendChild(node);
    node.appendChild(t);

    // size
    node = doc.createElement(NODE_ALBUM_SIZE);
    t = doc.createTextNode(QString("%1").arg(this->size));
    ret.appendChild(node);
    node.appendChild(t);

    //time create
    node = doc.createElement(NODE_ALBUM_CREATE);
    t = doc.createTextNode(this->time_create);
    ret.appendChild(node);
    node.appendChild(t);

    //time update
    node = doc.createElement(NODE_ALBUM_UPDATE);
    t = doc.createTextNode(this->time_update);
    ret.appendChild(node);
    node.appendChild(t);

    //icon
    node = doc.createElement(NODE_ALBUM_ICON);
    t = doc.createTextNode(this->icon);
    ret.appendChild(node);
    node.appendChild(t);

    //icon url
    node = doc.createElement(NODE_ALBUM_ICON_URL);
    t = doc.createTextNode(this->icon_url);
    ret.appendChild(node);
    node.appendChild(t);


    return ret;
}

Album Album::fromQDomElement(QDomElement fr, QString accountId, QString friendId) {
    Album ret = Album();

    ret.albumId = fr.elementsByTagName(NODE_ALBUM_ID).at(0).firstChild().toText().data();
    ret.title = fr.elementsByTagName(NODE_ALBUM_TITLE).at(0).firstChild().toText().data();
    ret.icon = fr.elementsByTagName(NODE_ALBUM_ICON).at(0).firstChild().toText().data();
    ret.icon_url = fr.elementsByTagName(NODE_ALBUM_ICON_URL).at(0).firstChild().toText().data();
    ret.description = fr.elementsByTagName(NODE_ALBUM_DESCRIPTION).at(0).firstChild().toText().data();
    ret.time_create = fr.elementsByTagName(NODE_ALBUM_CREATE).at(0).firstChild().toText().data();
    ret.time_update = fr.elementsByTagName(NODE_ALBUM_UPDATE).at(0).firstChild().toText().data();
    ret.size = fr.elementsByTagName(NODE_ALBUM_SIZE).at(0).firstChild().toText().data().toInt();
    ret.accountId = accountId;
    ret.ownerId = friendId;

    return ret;
}

// load album list from cache file.
PhotoList Album::getPhotoList() {
    PhotoList ret;
    QFile file(Utils::getAccountDir(this->accountId) + QString(FILE_PHOTOS_DATA).arg(this->ownerId, this->albumId));
    qDebug() << file.fileName();
    if (file.open(QIODevice::ReadOnly) == false)
        return ret;

    QDomDocument doc;
    doc.setContent(&file);
    file.close();

    QDomNodeList lst = doc.elementsByTagName(NODE_PHOTO_ROOT);

    qDebug() << "Start load of " << lst.length() << " photos for " << this->albumId;
    for (uint i = 0; i < lst.length(); i++) {
        ret.append(Photo::fromQDomElement(lst.at(i).toElement(), this->accountId, this->ownerId, this->albumId));
    }

    return ret;


}

void Album::setPhotoList(PhotoList list, QString accountId, QString friendId, QString albumId) {

    // store photo lists into cache
    QDomDocument out("MyDoc");
    QDomElement profile = out.createElement(NODE_PHOTOS_ROOT);
    out.appendChild(profile);

    for (int i = 0; i < list.length(); i++) {
        Photo curPh = list.at(i);
        qDebug() << "Image " << curPh.photoId << " stored at " << curPh.photo;
        profile.appendChild(Photo::toQDomElement(out, curPh));
    }

    QDir dir;

    dir.setPath(dir.cleanPath(Utils::getAccountDir(accountId)));
    if (!dir.exists())
        dir.mkpath(dir.absolutePath());

    QFile file(dir.absolutePath() + QString(FILE_PHOTOS_DATA).arg(friendId, albumId));
    qDebug() << file.fileName();
    if (file.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate) == false) {
        qDebug() << "can't open file: " + file.errorString();
    }
    //file.write(output.toUtf8());
    file.write(out.toByteArray(1));
    file.close();

}

