#include <glib.h>
#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>
#include <string.h>

#include "console.h"
#include "getopt_args.h"
#include "messages.h"

extern gchar *optarg;
extern gint optind, opterr, optopt;

    static struct option long_options[] = {
	{"file", 1, 0, 'f'},
	{"log", 1, 0, 'l'},
	{"help", 0, 0, 'h'},
	{0, 0, 0, 0}
    };



void parse_args(gint argc, gchar *argv[])
{
    g_debug("Parsing arguments");
    gint c = 0;
    gint option_index = 0;

    while (1)
    {
	c = getopt_long (argc, argv, "hf:l:",
			 long_options, &option_index);
    
	if (c == -1)
	{
	    break;
	}
	
	switch (c) { 
	case 'h':
	    PrintHelp();
	    exit(EXIT_SUCCESS);
	    

	case 'f':
	    if (optarg == NULL)
		g_error("wrong option argument");

	    if (command_file == NULL)
		command_file = g_malloc(sizeof(gchar) * (strlen(optarg) + 1));
	    if (command_file == NULL)
		g_error(ERR_MEM, __FILE__, __LINE__);
	    g_strlcpy(command_file, optarg, strlen(optarg) + 1);
	    g_debug("%s:%d: command_file=%s", __FILE__, __LINE__, command_file);
	    break;

	case '?':
	    break;

	case 'l':
	    if (log_file == NULL)
		log_file = g_malloc(sizeof(gchar) * (strlen(optarg) + 1));
	    if (log_file == NULL)
		g_error(ERR_MEM, __FILE__, __LINE__);
	    g_strlcpy(log_file, optarg, strlen(optarg) + 1);
	    g_debug("%s:%d: log_file=%s", __FILE__, __LINE__, log_file);
	    break;

	default:
	    g_warning("Unknown option %c\n", c);
	    PrintHelp();
	    exit(EXIT_FAILURE);
	}
    }
    if (optind == argc - 1)
    {
	driver = argv[optind];
    }else{
	g_warning("Network Driver didn't set");
	PrintHelp();
	exit(EXIT_FAILURE);
    }
}


void PrintHelp()
{
    fprintf(stderr, "Usage:\n\t %s [options] driver\n", progname);
    fprintf(stderr, "\ndriver:\n\t library of social network driver\n\n");
    fprintf(stderr, "options:\n");
    fprintf(stderr, "\t-f, --file=scenary\t\tFile of command sequence\n");
    fprintf(stderr, "\t-l, --log=logfile\t\tFile for output result\n");
    fprintf(stderr, "\t-h, --help\t\tThis help\n");
}
