#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>

#include "getopt_args.h"
#include "console.h"
#include "nd_interface.h"
#include "messages.h"

#define _GNU_SOURCE

gchar *progname = NULL;
gchar *login = NULL;
gchar *params = NULL;
gchar *password = NULL;
gchar *autoupdate = NULL;
gchar *active = NULL;
gchar *proxy = NULL;
gint port = 0;
FILE *file_sett;

/*pointer to social network driver library */
void *handle = NULL;

/* Name of file with command sequence */
gchar *command_file = NULL;

gchar *log_file = NULL;

/* Path to library of social network driver */
gchar *driver = NULL;

/* Struct driver_info contains links for used functions */
struct msa_module *driver_module = NULL;

gint (*driver_init)(struct msa_module *);

FILE *stdlog = NULL;

gint main(gint argc, gchar *argv[])
{
    setlocale(LC_ALL, "");
    gchar *error = bindtextdomain("mysocials-console", "./po/");
    g_debug("bindtextdomain: %s", error);
    error = bind_textdomain_codeset("mysocials-console", "UTF-8");
    g_debug("bind_textdomain_codeset: %s", error);
    error = textdomain("mysocials-console");
    g_debug("textdomain: %s", error);



    FILE * inStream = stdin;

    gchar *curCommand =  NULL; 
    gchar *friendID = NULL;
    gchar *messageID = NULL;
    gchar *url = NULL;
    gchar* recipient_id = NULL;
    gchar* text = NULL;
    gchar* url_encoded_text = NULL;
    gchar* from = NULL;
    gchar* to = NULL;
    gchar* offset = NULL;
    gchar* aid = NULL;
    gchar* pid = NULL;
    gchar* file = NULL;
    gchar* file_name = NULL;
    gchar* title = NULL;
    gchar* description = NULL;
    gchar* privacy = NULL;    
    error = NULL;

    curCommand = (gchar *)g_malloc(sizeof(gchar) * 255);
    friendID = (gchar *)g_malloc(sizeof(gchar) * 255);
    messageID = (gchar *)g_malloc(sizeof(gchar) * 255);
    recipient_id = (gchar *)g_malloc(sizeof(gchar) * 255);
    url = (gchar *)g_malloc(sizeof(gchar) * 255);
    from = (gchar *)g_malloc(sizeof(gchar) * 255);
    to = (gchar *)g_malloc(sizeof(gchar) * 255);
    offset = (gchar *)g_malloc(sizeof(gchar) * 255);
    aid = (gchar *)g_malloc(sizeof(gchar) * 255);
    pid = (gchar *)g_malloc(sizeof(gchar) * 255);
    file = (gchar *)g_malloc(sizeof(gchar) * 255);
    file_name = (gchar *)g_malloc(sizeof(gchar) * 255);
    title = (gchar *)g_malloc(sizeof(gchar) * 255);
    description = (gchar *)g_malloc(sizeof(gchar) * 255);
    privacy = (gchar *)g_malloc(sizeof(gchar) * 255);
 
   
    if (curCommand == NULL || friendID == NULL || url == NULL)
	g_error(ERR_MEM, __FILE__, __LINE__);
    
    
    progname = argv[0];
    parse_args(argc, argv);

    /* load driver */
    handle = dlopen(driver, RTLD_LAZY);
    if (handle == NULL)
    {
	g_warning("can't load driver: %s", dlerror());
	exit(EXIT_FAILURE);
    }

    dlerror();

    if (NULL == (driver_module = g_malloc(sizeof(struct msa_module))))
    {
	g_error(ERR_MEM, __FILE__, __LINE__);
    }
    //driver_module->set_events = cur_events;
    driver_module->proxy = NULL;
    driver_module->port = 0;
    driver_module->id = g_strdup("TEST_VK");

    *(void **) (&driver_init) = dlsym(handle, MODULE_INIT);
    (*driver_init)(driver_module);

    if ((error = dlerror()) != NULL)  {
	fprintf(stderr, "%s\n", error);
	exit(EXIT_FAILURE);
    }

    /* open command stream */
    if (command_file != NULL)
    {
	inStream = freopen(command_file, "r", inStream);
    }

    if (inStream == NULL)
    {
	g_error(_("can't read input stream"));
    }

    if (log_file != NULL)
    {
	stdlog = fopen(log_file, "w");
	if (stdlog == NULL)
	    g_error("can't open log file");
    }else
	stdlog = stdout;
    
   /* parsing command file */
    g_debug(_("Parse command file"));
    gint retNum = 0;

    while ((retNum = fscanf(inStream, "%254s", curCommand)) != EOF)
    {
	if (retNum != 1)
	    break;

	fprintf(stdlog, "=========================== %s ==========================\n", curCommand);

	if (strcmp(curCommand, "INIT") == 0)
	{
	    /* read proxy host */
	    if (fscanf(inStream, "%254s", curCommand) <=0)
		g_error("wrong INIT: proxy host");
		
	    if (proxy == NULL)
		proxy = g_malloc(sizeof(gchar) * (strlen(curCommand) + 1));
	    else
		proxy = g_realloc(proxy, sizeof(gchar) * (strlen(curCommand) + 1));
	    if (proxy == NULL)
		g_error(ERR_MEM, __FILE__, __LINE__);
		
	    g_strlcpy(proxy, curCommand, strlen(curCommand) + 1);
	    g_debug("%s:%d: proxy=%s", __FILE__, __LINE__, proxy);
	    
	    /* read proxy port */
	    if (fscanf(inStream, "%254s", curCommand) <=0)
		g_error("wrong INIT: proxy port");
		
	    error = curCommand;
	    port = strtol(curCommand, &error, 10);
	    if (*error != '\0')
		g_error("Can't parse proxy port number");
	    g_debug("%s:%d: port=%d", __FILE__, __LINE__, port);

	    nd_init(proxy, port);
	    continue;
	}

	if (strcmp(curCommand, "GETSETTINGS") == 0)
	{
	    nd_get_settings();
	    continue;
	}

	if (strcmp(curCommand, "GETMETHODS") == 0)
	{
	    nd_get_methods();
	    continue;
	}


        if (strcmp(curCommand, "TESTCONNECTION") == 0)
        {
            nd_test_connection();
            continue;
        }
	
	if (strcmp(curCommand, "SETSETTINGS") == 0)
	{
	    /* read params */
        if (fscanf(inStream, "%254s", file) != EOF)
            if(g_file_get_contents(file, &params, NULL, NULL))	    	    
	            nd_set_settings(params);
	    continue;
	}

	if (strcmp(curCommand, "GETALBUMS") == 0)
	{
	if (fscanf(inStream, "%254s", aid) != EOF)
	    nd_getAlbums(aid);
	    continue;
	}

	if (strcmp(curCommand, "UPLOADPHOTO") == 0)
	{
	    if (fscanf(inStream, "%254s", aid) != EOF && fscanf(inStream, "%254s", file) != EOF && fscanf(inStream, "%254s", file_name) != EOF)
	    nd_uploadPhoto(aid, file, file_name);
	    continue;
	}

	if (strcmp(curCommand, "GETPHOTOS") == 0)
	{
	    if (fscanf(inStream, "%254s", friendID) != EOF 
            && fscanf(inStream, "%254s", aid) != EOF 
            && fscanf(inStream, "%254s", from) != EOF 
            && fscanf(inStream, "%254s", to) != EOF)
	    nd_getPhotos(friendID, aid, from, to);
	    continue;
	}


        if (strcmp(curCommand, "GETUSERPHOTOS") == 0)
        {
            if (fscanf(inStream, "%254s", friendID) != EOF
            && fscanf(inStream, "%254s", from) != EOF
            && fscanf(inStream, "%254s", to) != EOF)
                nd_getUserPhotos(friendID, from, to);
                continue;
        }

        if (strcmp(curCommand, "GETPHOTOTAGS") == 0)
        {
            if (fscanf(inStream, "%254s", friendID) != EOF
                && fscanf(inStream, "%254s", aid) != EOF
                && fscanf(inStream, "%254s", pid) != EOF)
            nd_getPhotoTags(friendID, aid, pid);
            continue;
        }

        if (strcmp(curCommand, "GETFAVORITEPHOTOS") == 0)
        {
            if (fscanf(inStream, "%254s", friendID) != EOF
                && fscanf(inStream, "%254s", from) != EOF
                && fscanf(inStream, "%254s", to) != EOF)
                nd_getFavoritePhotos(friendID, from, to);
                continue;
            }			
	if (strcmp(curCommand, "GETPHOTOSUPDATES") == 0)
	{
	    if (fscanf(inStream, "%254s", friendID) != EOF)
	    nd_getPhotosUpdates(friendID);
	    continue;
	}

        if (strcmp(curCommand, "GETPHOTOCOMMENTS") == 0)
        {
            if (fscanf(inStream, "%254s", friendID) != EOF
                && fscanf(inStream, "%254s", aid) != EOF
                && fscanf(inStream, "%254s", pid) != EOF 
                && fscanf(inStream, "%254s", from) != EOF 
                && fscanf(inStream, "%254s", to) != EOF)
            nd_getPhotoComments(friendID, aid, pid, from, to);
            continue;
        }

        if (strcmp(curCommand, "SENDPHOTOCOMMENT") == 0)
        {
            if (fscanf(inStream, "%254s", friendID) != EOF
                && fscanf(inStream, "%254s", aid) != EOF
                && fscanf(inStream, "%254s", pid) != EOF
                && fscanf(inStream, "%254s", file) != EOF)
            nd_sendPhotoComment(friendID, aid, pid, file);
            continue;
        }

        if (strcmp(curCommand, "CREATEALBUM") == 0)
        {
            if (fscanf(inStream, "%254s", friendID) != EOF
                && fscanf(inStream, "%254s", title) != EOF
                && fscanf(inStream, "%254s", description) != EOF
                && fscanf(inStream, "%254s", privacy) != EOF)
            nd_createAlbum(friendID, title, description, privacy);
            continue;
        }

	if (strcmp(curCommand, "DOWNLOADPHOTO") == 0)
	{
	    if (fscanf(inStream, "%254s", file_name) != EOF && fscanf(inStream, "%254s", url) != EOF)
	    nd_downloadPhoto(file_name, url);
	    continue;
	}

	if (strcmp(curCommand, "GETAUDIO") == 0)
	{
	if (fscanf(inStream, "%254s", aid) != EOF)
	    nd_getAudio(aid);
	    continue;
	}


	if (strcmp(curCommand, "GETFRIENDS") == 0)
	{
	    if (fscanf(inStream, "%254s", from) != EOF && fscanf(inStream, "%254s", to) != EOF)
	    nd_getFriends(from, to);
	    continue;
	}

	if (strcmp(curCommand, "GETFRIENDINFO") == 0)
	{
	    if (fscanf(inStream, "%254s", friendID) != EOF)
		nd_getFriendInfo(friendID);
	    continue;
	}
        
        if (strcmp(curCommand, "DELFRIEND") == 0)
        {
            if (fscanf(inStream, "%254s", friendID) != EOF)
                   nd_delFriend(friendID);
                continue;
        }

	if (strcmp(curCommand, "GETTHREADS") == 0)
	{
	    if (fscanf(inStream, "%254s", from) != EOF 
            && fscanf(inStream, "%254s", to) != EOF)
	        nd_getThreads(from, to);
	    continue;
	}

	if (strcmp(curCommand, "GETTHREADMESSAGES") == 0)
	{
	    if (fscanf(inStream, "%254s", friendID) != EOF
            && fscanf(inStream, "%254s", from) != EOF 
            && fscanf(inStream, "%254s", to) != EOF)
	        nd_getThreadMessages(friendID, from, to);
	    continue;
	}

	if (strcmp(curCommand, "GETINBOX") == 0)
	{
	    if (fscanf(inStream, "%254s", from) != EOF 
            && fscanf(inStream, "%254s", to) != EOF
            && fscanf(inStream, "%254s", offset) != EOF)
	        nd_getInbox(from, to, offset);
	    continue;
	}

	if (strcmp(curCommand, "GETSEND") == 0)
	{
	    if (fscanf(inStream, "%254s", from) != EOF 
            && fscanf(inStream, "%254s", to) != EOF
            && fscanf(inStream, "%254s", offset) != EOF)
	        nd_getSend(from, to, offset);
	    continue;
	}

	if (strcmp(curCommand, "GETWALL") == 0)
	{
	    if (fscanf(inStream, "%254s", from) != EOF 
            && fscanf(inStream, "%254s", to) != EOF
            && fscanf(inStream, "%254s", friendID) != EOF)
	        nd_getWall(from, to, friendID);
	    continue;
	}

    if (strcmp(curCommand, "GETINBOXCOUNT") == 0)
    {
        nd_getInboxCount();
        continue;
    }
    if (strcmp(curCommand, "GETSENDCOUNT") == 0)
    {
        nd_getSendCount();
        continue;
    }
    if (strcmp(curCommand, "GETWALLCOUNT") == 0)
    {
        if (fscanf(inStream, "%254s", friendID) != EOF)
            nd_getWallCount(friendID);
        continue;
    }

	if (strcmp(curCommand, "GETINBOXCOUNTTIME") == 0)
	{
	    if (fscanf(inStream, "%254s", from) != EOF)
            nd_getInboxCountTime(from);
	    continue;
	}

	if (strcmp(curCommand, "GETSENDCOUNTTIME") == 0)
	{
	    if (fscanf(inStream, "%254s", from) != EOF)
            nd_getSendCountTime(from);
	    continue;
	}

    if (strcmp(curCommand, "DELMESSAGE") == 0)
    {
        if (fscanf(inStream, "%254s", messageID) != EOF)
            nd_delMessage(messageID);
        continue;
    }

    if (strcmp(curCommand, "DELWALLMESSAGE") == 0)
    {
        if (fscanf(inStream, "%254s", messageID) != EOF)
            nd_delWallMessage(messageID);
        continue;
    }

    if (strcmp(curCommand, "READMESSAGE") == 0)
    {
        if (fscanf(inStream, "%254s", messageID) != EOF)
            nd_readMessage(messageID);
        continue;
    }
	if (strcmp(curCommand, "GETIMAGE") == 0)
	{
	    if (fscanf(inStream, "%254s", url) != EOF)
		nd_getFriendImage(url);
	    continue;
	}

	if (strcmp(curCommand, "SETLOGIN") == 0)
	{
	    if (1 != fscanf(inStream, "%254s", login))
		g_error("Can't read login value");
	    continue;
	}

	if (strcmp(curCommand, "SETPASSWORD") == 0)
	{
	    if (1 != fscanf(inStream, "%254s", password))
		g_error("Can't read password value");
	    continue;
	}

	if (strcmp(curCommand, "GETPROFILE") == 0)
	{
	    nd_getProfile();
            continue;
	}

	if (strcmp(curCommand, "GETBASEPROFILE") == 0)
	{
	    nd_getBaseProfile();
            continue;
	}

        if (strcmp(curCommand, "SETPROFILE") == 0)
        {

            //nd_setProfile();
            continue;
        } 
     
        if (strcmp(curCommand, "SENDMESSAGE") == 0)
        {   	    

            /* read recipient_id */
            if (fscanf(inStream, "%254s", recipient_id) != EOF 
                && fscanf(inStream, "%254s", file) != EOF){

                if(g_file_get_contents(file, &text, NULL, NULL))	 
	                nd_sendMessage(recipient_id, text);
            }
            continue;
        }

        if (strcmp(curCommand, "SENDWALLMESSAGE") == 0)
        {

            /* read recipient_id */
            if (fscanf(inStream, "%254s", recipient_id) != EOF 
                && fscanf(inStream, "%254s", file) != EOF){

                if(g_file_get_contents(file, &text, NULL, NULL))	 
	                nd_sendWallMessage(recipient_id, text);
            }
            continue;
        }

	if (strcmp(curCommand, "GETNEWINBOX") == 0)
        {
            nd_getNewInbox();
            continue;
        }

	if (strcmp(curCommand, "GETNEWS") == 0)
	{
	    if (fscanf(inStream, "%254s", from) != EOF 
            && fscanf(inStream, "%254s", to) != EOF
            && fscanf(inStream, "%254s", offset) != EOF
            && fscanf(inStream, "%254s", title) != EOF)
	        nd_getNews(from, to, offset, title);
	    continue;
	}
	
	g_warning(_("Can't recognize command \"%s\"\n"), curCommand);
    }

    g_debug(_("Process comleted. Closing..."));
    if (driver_module->shutdown != NULL)
	driver_module->shutdown(driver_module);

    /* clean used memory */
    if (curCommand != NULL)
	g_free(curCommand);
    if (friendID != NULL)
	g_free(friendID);
    if (messageID != NULL)
        g_free(messageID);
    if (url != NULL)
        g_free(url);
    if (recipient_id != NULL)
        g_free(recipient_id);
    if (text != NULL)
        g_free(text);
    if (url_encoded_text != NULL)
        g_free(url_encoded_text);
    if (login != NULL)
        g_free(login);
    if (password != NULL)
	g_free(password);
    if (params != NULL)
        g_free(params);
    if (command_file != NULL)
	g_free(command_file);
    if (log_file != NULL)
	g_free(log_file);
    if (from != NULL)
        g_free(from);
    if (to != NULL)
        g_free(to);
    if (aid != NULL)
        g_free(aid);
    if (title != NULL)
        g_free(title);
    if (description != NULL)
        g_free(description);
    if (privacy != NULL)
        g_free(privacy);
    if (file != NULL)
        g_free(file);

    if (driver_module != NULL)
    {
	//g_free(driver_module->name);
	//g_free(driver_module->id);
	//g_free(driver_module->pic);
	g_free(driver_module);
    }

    //dlclose(handle);

    return EXIT_SUCCESS;
}
