#!/bin/sh

# Check for lockfile
if test -f /opt/menu-update/lock
then 
  exit 1
fi

# Create lockfile
touch /opt/menu-update/lock

# start user info
/usr/bin/run-standalone.sh /opt/menu-update/mymenu-update-info &


###################################################################################
###          First Run - Create Backup of original hildon.menu                  ###
###################################################################################



if test -f /home/user/.config/menus/hildon.menu-old
then
 echo "Backup of hildon.menu exist"
else
 mv /home/user/.config/menus/hildon.menu /home/user/.config/menus/hildon.menu-old
fi

###################################################################################
###          First Run END - Create Backup of original hildon.menu              ###
###################################################################################



# pathvariable
menu=/opt/menu-update
menui=/opt/menu-update/mymenu
menun=/opt/menu-update/mymenu/new
menu_new=$menun/category
menu_old=$menu/category


# clear old files
rm -r $menun/*
cd $menun
wget http://maemo.3ion.at/category
# wget http://maemo.3ion.at/install

# filevariable
#install_old='$menui/install.sh'
#install_new='$menun/install'
hildon_menu='/opt/menu-update/mymenu/new/hildon.menu'


#check for update 
if [ "$menu_old" -ot "$menu_new" ]; then
cp $menun/category $menu/
fi

touch /opt/menu-update/mymenu/new/hildon.menu

# create hildon.menu

###################################################################################
###          Start check for installed apps                                     ###
###################################################################################

newline='\n'

for i in $(ls /usr/share/applications/hildon | grep .desktop)
do

desktop=`cat  /opt/menu-update/category | grep -i "$i"`

test=`echo $desktop | grep -i "Science+learn"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss="-"
fi
test=`echo $desktop | grep -i "office"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss1="-"
fi
test=`echo $desktop | grep -i "Multimedia"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss2="-"
fi
test=`echo $desktop | grep -i "Programmierung"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss3="-"
fi
test=`echo $desktop | grep -i "Spiele" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss4="-"
fi
test=`echo $desktop | grep -i "Graphics" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss5="-"
fi
test=`echo $desktop | grep -i "Netzwerk" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss6="-"
fi
test=`echo $desktop | grep -i "System" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss7="-"
fi
test=`echo $desktop | grep -i "sonstige" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss8="-"
fi
test=`echo $desktop | grep -i "gps"  |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss9="-"
fi
test=`echo $desktop | grep -i "tools"  |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss10="-"
fi

done
###################################################################################
###         Stop check for installed apps                                       ###
###################################################################################


##########################################################################################
#     start creating menu.hildon                                                         #
##########################################################################################


#### Main Menu ####
echo '<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
 "http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd">

<!-- Created & Edited by Manfred Weiß (C) - 2010
     you can freely rewrite & distripute this Script....
     Mail: maemo@3ion.at -->

<Menu>

  <Name>Main</Name>

  <!-- Search the default locations -->
  <AppDir>/usr/share/applications/hildon</AppDir>
  <DirectoryDir>/usr/share/applications/hildon/directory</DirectoryDir>

  <Include>
    <Filename>calendar.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
  </Include>
  <Layout>
    <Filename>calendar.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
  </Layout>

' >> $hildon_menu

#### Science & Learn ####
if [ ${#ergebniss} -gt 0 ]; then
echo '
  <Menu>
    <Name>Science+learn</Name>
    <Directory>education.directory</Directory>
    <Include>' >> $hildon_menu
    cat $menu/category | grep -i "Science+learn" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Science+learn
fi

#### Office ####
if [ ${#ergebniss1} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Office</Name>
    <Directory>office.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "office" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no office
fi

#### Multimedia ####
if [ ${#ergebniss2} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Multimedia</Name>
    <Directory>audiovideo.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Multimedia" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no multimedia
fi

#### Development ####
if [ ${#ergebniss3} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Programmierung</Name>
    <Directory>development.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Programmierung" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Programmierung
fi

#### Games ####
if [ ${#ergebniss4} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Spiele</Name>
    <Directory>game.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Spiele" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Spiele
fi

#### Graphics ####
if [ ${#ergebniss5} -gt 0 ]; then
echo '   
   <Menu>
    <Name>Graphics</Name>
    <Directory>graphics.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Graphics" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Graphics
fi

#### Network ####
if [ ${#ergebniss6} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Netzwerk</Name>
    <Directory>network.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Netzwerk" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Netzwerk
fi

#### GPS ####
if [ ${#ergebniss9} -gt 0 ]; then
echo '   
  <Menu>
    <Name>GPS</Name>
    <Directory>geo.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "gps" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no gps
fi

#### System ####
if [ ${#ergebniss7} -gt 0 ]; then
echo '   
  <Menu>
    <Name>System</Name>
    <Directory>system.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "System" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no System
fi

#### Other ####
echo '   
  <Menu>
    <Name>sonstige</Name>
    <Directory>other.directory</Directory>
    <OnlyUnallocated/>
    <Include>
      <All/>' >> $hildon_menu
cat $menu/category | grep -i "sonstige" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu


#### Tools ####
if [ ${#ergebniss10} -gt 0 ]; then
echo '   
  <Menu>
    <Name>tools</Name>
    <Directory>tools.directory</Directory>
    <OnlyUnallocated/>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "tools" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no tools
fi
echo '</Menu>' >> $hildon_menu

if test -f /home/user/.config/menus/hildon.menu
then
rm /home/user/.config/menus/hildon.menu
fi 

cp $hildon_menu /home/user/.config/menus

rm /opt/menu-update/lock

killall mymenu-update-info
exit 0

