#ifndef TUBESTATUS_H
#define TUBESTATUS_H

#include <QString>
#include <qstringlist.h>
#include <QVariant>

/** TubeStatus
 *
 * This class abstracts the status for a single Tube Line.
 */
class TubeStatus
{
private:
    /** The key of a Tube Line. */
    QString key;
    /** The human-readable name. */
    QString name;
    /** The current status of a tube line. */
    QString status;
    /** An array of informational messages for the tube line. */
    QStringList messages;
    /** The time the status was requested. */
    QString statusRequestedTime;


public:
    TubeStatus();
    TubeStatus(const QVariant &data);
    TubeStatus(const QString &json);
    TubeStatus(const QString & key, const QString & name, const QString & status,const QStringList & messages = QStringList());

    ~TubeStatus();

    void clear();

    void fromQVariant(const QVariant &data);
    QVariant toQVariant() const;

    void setKey(const QString & newKey);
    QString getKey() const;

    void setName(const QString & newName);
    QString getName() const;

    void setStatus(const QString & newStatus);
    QString getStatus() const;

    const QStringList & getMessages() const;
    void setMessages(const QStringList & newMessages);
    void addMessage(const QString & newMessage);
    void clearMessages();

    QString getRequestedTime() const;

    int numMessages() const;

    bool isOk() const;
    bool isGoodService() const;

private:
    /** Converts a string containing HTML entities into a unicode string. */
    static QString fromHtml(const QString & str, bool * ok = 0);
};
Q_DECLARE_METATYPE(TubeStatus);

#endif // TUBESTATUS_H
